/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt101;

import de.businesslogics.format.swift.Field20;
import de.businesslogics.format.swift.Field28D;
import de.businesslogics.format.swift.Field30;
import de.businesslogics.format.swift.Field50G;
import de.businesslogics.format.swift.Field50H;
import de.businesslogics.format.swift.Field52A;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.format.swift.mt101.MT101SequenceA;
import de.businesslogics.format.swift.mt101.MT101SequenceB;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class MT101LogicalFile {
    private static final String CRLF = "\r\n";
    private final String senderBIC;
    private final String receiverBIC;
    private final MT101SequenceA sequenceA;
    private final List<MT101PaymentData> payments;

    public MT101LogicalFile(String senderBIC, String receiverBIC, MT101SequenceA sequenceA) {
        this.senderBIC = senderBIC;
        this.receiverBIC = receiverBIC;
        this.sequenceA = sequenceA;
        this.payments = new ArrayList<MT101PaymentData>();
    }

    public MT101LogicalFile(MT101PaymentData paymentData) {
        this.senderBIC = paymentData.getSenderBic();
        this.receiverBIC = paymentData.getReceiverBic();
        int messageIndex = 1;
        int messageCount = 1;
        Field20 f20 = new Field20(paymentData.getSenderReference());
        Field28D f28D = new Field28D(messageIndex, messageCount);
        Field30 f30 = new Field30(paymentData.getExecutionDate());
        this.sequenceA = new MT101SequenceA(f20, f28D, f30);
        String[] originatorAddress = paymentData.getOriginatorAddress();
        if (originatorAddress != null && originatorAddress.length > 0) {
            Field50H f50H = new Field50H(paymentData.getOriginatorAccount(), paymentData.getOriginatorAddress());
            this.sequenceA.setOrderingCustomer(f50H);
        } else {
            Field50G f50G = new Field50G(paymentData.getOriginatorAccount(), paymentData.getReceiverBic());
            this.sequenceA.setOrderingCustomer(f50G);
        }
        if (paymentData.getOriginatorBic() != null && !paymentData.getOriginatorBic().equals(this.receiverBIC)) {
            this.sequenceA.setAccountServicingInstitution(new Field52A(paymentData.getOriginatorBic()));
        } else {
            this.sequenceA.setAccountServicingInstitution(new Field52A(this.receiverBIC));
        }
        this.payments = new ArrayList<MT101PaymentData>();
        this.payments.add(paymentData);
    }

    public void addPayment(MT101SequenceB sequenceB) {
        this.payments.add(new MT101PaymentData(this.senderBIC, this.receiverBIC, this.sequenceA, sequenceB));
    }

    public List<MT101PaymentData> getPayments() {
        return this.payments;
    }

    public void save(OutputStream out, boolean structuredHeader, boolean saveAccountCurrency, int sessionNumber, int sequenceNumber) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out);
        if (structuredHeader) {
            w.write("{1:F01");
            if (this.senderBIC.length() > 8) {
                w.write(this.senderBIC.substring(0, 8));
            } else {
                w.write(this.senderBIC);
            }
            w.write(88);
            if (this.senderBIC.length() > 8) {
                w.write(this.senderBIC.substring(8));
            } else {
                w.write("XXX");
            }
            w.write(String.format("%04d", sessionNumber % 10000));
            w.write(String.format("%06d", sequenceNumber % 1000000));
            w.write("}{2:I101");
            if (this.receiverBIC.length() > 8) {
                w.write(this.receiverBIC.substring(0, 8));
            } else {
                w.write(this.receiverBIC);
            }
            w.write(88);
            if (this.receiverBIC.length() > 8) {
                w.write(this.receiverBIC.substring(8));
            } else {
                w.write("XXX");
            }
            w.write("N}{4:");
            w.write(CRLF);
        } else {
            w.write("{-");
            w.write(CRLF);
            w.write(this.senderBIC);
            w.write(CRLF);
            w.write(this.receiverBIC);
            w.write(CRLF);
            w.write("101");
            w.write(CRLF);
        }
        this.sequenceA.writeTo(w);
        for (MT101PaymentData payment : this.payments) {
            payment.writeTo(w, saveAccountCurrency);
        }
        w.write("-");
        w.write("}");
        w.flush();
    }
}

