/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift.mt101;

import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.mt101.MT101Listener;
import de.businesslogics.format.swift.mt101.MT101LogicalFile;
import de.businesslogics.format.swift.mt101.MT101Parser;
import de.businesslogics.format.swift.mt101.MT101SequenceA;
import de.businesslogics.format.swift.mt101.MT101SequenceB;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class MT101Extractor
implements MT101Listener {
    private List<MT101LogicalFile> logicalFiles;
    private MT101LogicalFile currentLogicalFile;

    public List<MT101LogicalFile> getLogicalFiles(InputStream inputStream) throws ParseException, IOException {
        this.logicalFiles = new ArrayList<MT101LogicalFile>();
        MT101Parser parser = new MT101Parser(this);
        parser.parse(inputStream);
        parser.close();
        return this.logicalFiles;
    }

    @Override
    public void handle(String senderBIC, String receiverBIC, MT101SequenceA sequenceA) {
        this.currentLogicalFile = new MT101LogicalFile(senderBIC, receiverBIC, sequenceA);
        this.logicalFiles.add(this.currentLogicalFile);
    }

    @Override
    public void handle(MT101SequenceB sequenceB) {
        this.currentLogicalFile.addPayment(sequenceB);
    }

    @Override
    public void handleEOF() {
    }
}

