/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.ParseException;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Pattern;

public abstract class SwiftHandler {
    protected static final Pattern BIC_PATTERN = Pattern.compile("[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}");
    protected static final Pattern YYMMDD_PATTERN = Pattern.compile("[0-9]{2,2}[0-1][0-9][0-3][0-9]");
    boolean mandatory;

    public int getMaxBlockLength() {
        return 1;
    }

    public abstract String willHandle(String var1);

    public abstract void handle(List<String> var1) throws ParseException;

    public final boolean isMandatory() {
        return this.mandatory;
    }

    protected Currency parseCurrency(String s) {
        return Currency.getInstance(s);
    }

    protected int skipInteger(String s, int i) {
        while (i < s.length() && Character.isDigit(s.charAt(i))) {
            ++i;
        }
        return i;
    }

    protected int skipNonInteger(String s, int i) {
        while (i < s.length() && !Character.isDigit(s.charAt(i))) {
            ++i;
        }
        return i;
    }

    protected int parseInteger(String s) throws ParseException {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(s + " is not a number");
        }
    }

    protected long parseLong(String s) throws ParseException {
        try {
            return Long.parseLong(s.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(s + " is not a number");
        }
    }

    protected BigDecimal parseDecimal(String s) throws ParseException {
        try {
            s = s.trim();
            return new BigDecimal(s.replace(',', '.'));
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(s + " is not a number");
        }
    }

    protected int trimBlockSize(List<String> block, int min) {
        int toReturn;
        for (toReturn = block.size(); toReturn > min && block.get(toReturn - 1).trim().length() == 0; --toReturn) {
        }
        return toReturn;
    }
}

