/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class SwiftElement
implements Serializable {
    protected static final String CRLF = "\r\n";

    public abstract void writeTo(Writer var1) throws IOException;

    protected static final Date parseJJMMTT(String d) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
            return sdf.parse(d);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    protected static final String formatJJMMTT(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        return sdf.format(d);
    }

    protected static final void writeDecimal(Writer w, BigDecimal d) throws IOException {
        int scale = d.scale();
        String s = d.abs().unscaledValue().toString();
        if (scale > 0) {
            int i;
            for (i = s.length(); scale > 0 && i > 0 && s.charAt(i - 1) == '0'; --scale, --i) {
            }
            s = s.substring(0, i);
        }
        if (scale <= 0) {
            if (s.length() == 0) {
                w.write(48);
            } else {
                w.write(s);
            }
            while (scale < 0) {
                w.write(48);
                ++scale;
            }
            w.write(44);
        } else {
            int i2 = s.length() - scale;
            if (i2 <= 0) {
                w.write(48);
                w.write(44);
                while (++i2 <= 0) {
                    w.write(48);
                }
                w.write(s);
            } else {
                w.write(s, 0, i2);
                w.write(44);
                w.write(s, i2, scale);
            }
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeTo(sw);
        }
        catch (IOException ioe) {
            return super.toString();
        }
        return sw.toString();
    }
}

