/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field86;
import java.util.HashMap;
import java.util.TreeMap;

public class StructuredNLField86
extends Field86 {
    private static final String MANDATE_REFERENCE = "/MARF/";
    private static final String END_TO_END_ID = "/EREF/";
    private static final String BATCH_REFERENCE = "/PREF/";
    private static final String RETURN_REASON = "/RTRN/";
    private static final String BENEFICIARY_NAME = "/BENM//NAME/";
    private static final String BENEFICIARY_ID = "/BENM//ID/";
    private static final String ORDERINGPARTY_NAME = "/ORDP//NAME/";
    private static final String ORDERINGPARTY_ID = "/ORDP//ID/";
    private static final String COUNTERPARTY_ADDRESS = "/ADDR/";
    private static final String REMITTANCE_INFORMATION = "/REMI/";
    private static final String REMITTANCE_INFORMATION_STRUCTURED = "/REMI//CDTRREFTP//CD/SCOR/ISSR/CUR/CDTRREF";
    private static final String CREDITOR_IDENTIFIER = "/CSID/";
    private static final String ULTIMATE_DEBITOR_NAME = "/ULTD//NAME/";
    private static final String ULTIMATE_DEBITOR_ID = "/ULTD//ID/";
    private static final String ULTIMATE_BENEFICIARY_NAME = "/ULTB/NAME//";
    private static final String ULTIMATE_BENEFICIARY_ID = "/ULTB//ID/";
    private static final String PURPOSE = "/PURP/";
    private static final String PURPOSE_CODE = "/CD/";
    private static final String TRANSACTION_CODE = "/TRCD/";
    private static final String[] PREFIXES = new String[]{"/MARF/", "/EREF/", "/PREF/", "/RTRN/", "/BENM//NAME/", "/BENM//ID/", "/ORDP//NAME/", "/ORDP//ID/", "/ADDR/", "/REMI/", "/REMI//CDTRREFTP//CD/SCOR/ISSR/CUR/CDTRREF", "/CSID/", "/ULTD//NAME/", "/ULTD//ID/", "/ULTB/NAME//", "/ULTB//ID/", "/PURP/", "/CD/", "/TRCD/"};
    private static final long serialVersionUID = 1L;
    private final HashMap<String, String> values;

    static StructuredNLField86 tryToParse(String[] rawLines) {
        if (rawLines == null || rawLines.length == 0 || !rawLines[0].startsWith("/")) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rawLines.length; ++i) {
            sb.append(rawLines[i]);
        }
        String complete = sb.toString();
        TreeMap<Integer, String> startingPositions = new TreeMap<Integer, String>();
        for (String prefix : PREFIXES) {
            int pos = complete.indexOf(prefix);
            if (pos < 0) continue;
            startingPositions.put(pos, prefix);
        }
        if (startingPositions.isEmpty()) {
            return null;
        }
        Integer start = 0;
        HashMap<String, String> values = new HashMap<String, String>();
        for (Integer i : startingPositions.keySet()) {
            if (i.equals(start)) continue;
            String key = (String)startingPositions.get(start);
            if (key == null) {
                return null;
            }
            if (i < start + key.length()) continue;
            String value = complete.substring(start + key.length(), i);
            start = i;
            values.put(key, value);
        }
        String key = (String)startingPositions.get(start);
        values.put(key, complete.substring(start + key.length()));
        return new StructuredNLField86(rawLines, values);
    }

    private StructuredNLField86(String[] rawLines, HashMap<String, String> values) {
        super(rawLines);
        this.values = values;
    }

    public String getMandateReference() {
        return this.values.get(MANDATE_REFERENCE);
    }

    public String getEndToEndId() {
        return this.values.get(END_TO_END_ID);
    }

    public String getBatchReference() {
        return this.values.get(BATCH_REFERENCE);
    }

    public String getReturnReason() {
        return this.values.get(RETURN_REASON);
    }

    public String getCounterpartyName() {
        String tmp = this.values.get(BENEFICIARY_NAME);
        if (tmp != null) {
            return tmp;
        }
        return this.values.get(ORDERINGPARTY_NAME);
    }

    public String getCounterpartyId() {
        String tmp = this.values.get(BENEFICIARY_ID);
        if (tmp != null) {
            return tmp;
        }
        return this.values.get(ORDERINGPARTY_ID);
    }

    public String getCounterpartyAddress() {
        return this.values.get(COUNTERPARTY_ADDRESS);
    }

    public String getRemittanceInformation() {
        String tmp = this.values.get(REMITTANCE_INFORMATION);
        if (tmp != null) {
            return tmp;
        }
        return this.values.get(REMITTANCE_INFORMATION_STRUCTURED);
    }

    public String getCreditorIdentifier() {
        return this.values.get(CREDITOR_IDENTIFIER);
    }

    public String getUltimateName() {
        String tmp = this.values.get(ULTIMATE_BENEFICIARY_NAME);
        if (tmp != null) {
            return tmp;
        }
        return this.values.get(ULTIMATE_DEBITOR_NAME);
    }

    public String getUltimateId() {
        String tmp = this.values.get(ULTIMATE_BENEFICIARY_ID);
        if (tmp != null) {
            return tmp;
        }
        return this.values.get(ULTIMATE_DEBITOR_ID);
    }

    public String getPurpose() {
        return this.values.get(PURPOSE);
    }

    public String getPurposeCode() {
        return this.values.get(PURPOSE_CODE);
    }

    public String getTransactionCode() {
        return this.values.get(TRANSACTION_CODE);
    }
}

