/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field86;
import de.businesslogics.format.swift.SepaPurpose;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;

public class StructuredField86
extends Field86 {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(StructuredField86.class.getName());
    private final String gvc;
    private final String bookingText;
    private final String primaNota;
    private final String[] purpose;
    private final String otherBankcode;
    private final String otherAccount;
    private final String[] otherName;
    private final String textKeyAppendix;
    private final String[] myName;
    private final Map<Integer, String> unknownFields;

    private StructuredField86(String[] rawLines, String gvc, String bookingText, String primaNota, String[] purpose, String otherBankcode, String otherAccount, String[] otherName, String textKeyAppendix, Map<Integer, String> unknownFields, String[] myName) {
        super(rawLines);
        this.gvc = gvc;
        this.bookingText = bookingText;
        this.primaNota = primaNota;
        this.purpose = purpose;
        this.otherBankcode = otherBankcode;
        this.otherAccount = otherAccount;
        this.otherName = otherName;
        this.textKeyAppendix = textKeyAppendix;
        this.unknownFields = unknownFields;
        this.myName = myName;
    }

    public String getGeschaeftsvorfallcode() {
        return this.gvc;
    }

    public String getBookingText() {
        return this.bookingText;
    }

    public String getPrimaNota() {
        return this.primaNota;
    }

    public String[] getPurpose() {
        return this.purpose;
    }

    public Map<SepaPurpose, String> getSepaPurpose() {
        if (this.purpose.length == 0) {
            return null;
        }
        String s = this.purpose[0];
        SepaPurpose sp = StructuredField86.nextPurpose(s, 0);
        if (sp == null) {
            return null;
        }
        int pi = sp.ordinal() + 1;
        HashMap<SepaPurpose, String> toReturn = new HashMap<SepaPurpose, String>();
        StringBuilder sb = new StringBuilder(s.substring(5));
        for (int i = 1; i < this.purpose.length; ++i) {
            s = this.purpose[i];
            SepaPurpose p = StructuredField86.nextPurpose(s, pi);
            if (p != null) {
                toReturn.put(sp, sb.toString());
                sb.setLength(0);
                sb.append(s.substring(5));
                sp = p;
                pi = sp.ordinal() + 1;
                continue;
            }
            sb.append(s);
        }
        toReturn.put(sp, sb.toString());
        return toReturn;
    }

    private static SepaPurpose nextPurpose(String s, int pi) {
        if (s.length() < 5 || s.charAt(4) != '+') {
            return null;
        }
        s = s.substring(0, 4);
        SepaPurpose[] sps = SepaPurpose.values();
        while (pi < sps.length) {
            if (sps[pi].name().equals(s)) {
                return sps[pi];
            }
            ++pi;
        }
        return null;
    }

    public String getOtherBankcode() {
        return this.otherBankcode;
    }

    public String getOtherAccount() {
        return this.otherAccount;
    }

    public String[] getOtherName() {
        return this.otherName;
    }

    public String[] getMyName() {
        return this.myName;
    }

    public String getTextKeyAppendix() {
        return this.textKeyAppendix;
    }

    static StructuredField86 tryToParse(String[] rawLines) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < rawLines.length; ++i) {
            sb.append(rawLines[i]);
        }
        if (sb.length() < 3) {
            LOGGER.fine("Geschaeftsvorfallcode missing");
            return null;
        }
        for (i = 0; i < 3; ++i) {
            if (Character.isDigit(sb.charAt(i))) continue;
            LOGGER.fine("Not a valid Geschaeftsvorfallcode");
            return null;
        }
        String gvc = sb.substring(0, 3);
        int pos = 3;
        char sepChar = '?';
        if (sb.length() > 4 && sb.charAt(3) == '~') {
            sepChar = '~';
        }
        if (sb.length() > 4 && sb.charAt(3) == '\'') {
            sepChar = '\'';
        }
        String sepString = Character.toString(sepChar);
        String bookingText = null;
        String primaNota = null;
        String otherBankcode = null;
        String otherAccount = null;
        String textKeyAppendix = null;
        LinkedList<String> purpose = new LinkedList<String>();
        LinkedList<String> otherName = new LinkedList<String>();
        LinkedList<String> myName = new LinkedList<String>();
        HashMap<Integer, String> unknownFields = new HashMap<Integer, String>();
        while (pos < sb.length()) {
            if (sb.length() < pos + 3) {
                LOGGER.fine("Not enough data for new field at position " + pos);
                return null;
            }
            if (sb.charAt(pos) != sepChar || !Character.isDigit(sb.charAt(pos + 1)) || !Character.isDigit(sb.charAt(pos + 2))) {
                LOGGER.fine("Not a valid field key at postion " + pos);
                return null;
            }
            int key = Integer.parseInt(sb.substring(pos + 1, pos + 3));
            int nextPos = sb.indexOf(sepString, pos += 3);
            while (nextPos + 2 < sb.length()) {
                if (nextPos < 0) {
                    nextPos = sb.length();
                    break;
                }
                if (Character.isDigit(sb.charAt(nextPos + 1)) && Character.isDigit(sb.charAt(nextPos + 2))) break;
                nextPos = sb.indexOf(sepString, nextPos + 1);
            }
            if (nextPos + 3 > sb.length()) {
                nextPos = sb.length();
            }
            String value = sb.substring(pos, nextPos);
            if (nextPos == sb.length() && sepString.equals(value)) {
                value = "";
            }
            if (key == 0) {
                bookingText = value;
            } else if (key == 10) {
                primaNota = value;
            } else if (key >= 20 && key <= 29 || key >= 60 && key <= 63) {
                purpose.add(value);
            } else if (key == 30) {
                otherBankcode = value;
            } else if (key == 31) {
                otherAccount = value;
            } else if (key == 32 || key == 33) {
                otherName.add(value);
            } else if (key == 34) {
                textKeyAppendix = value;
            } else if (key == 35 || key == 36 || key == 70 || key == 71) {
                myName.add(value);
            } else {
                LOGGER.warning("Unknown field key " + key);
                unknownFields.put(key, value);
            }
            pos = nextPos;
        }
        String[] otherNameArray = new String[otherName.size()];
        otherName.toArray(otherNameArray);
        String[] purposeArray = new String[purpose.size()];
        purpose.toArray(purposeArray);
        String[] myNameArray = new String[myName.size()];
        myName.toArray(myNameArray);
        return new StructuredField86(rawLines, gvc, bookingText, primaNota, purposeArray, otherBankcode, otherAccount, otherNameArray, textKeyAppendix, unknownFields, myNameArray);
    }

    public static StructuredField86 generate(String gvc, String bookingText, String primaNota, String[] purposeArray, String otherBankcode, String otherAccount, String[] otherNameArray, String textKeyAppendix) {
        return StructuredField86.generate(gvc, bookingText, primaNota, purposeArray, otherBankcode, otherAccount, otherNameArray, textKeyAppendix, null);
    }

    public static StructuredField86 generate(String gvc, String bookingText, String primaNota, String[] purposeArray, String otherBankcode, String otherAccount, String[] otherNameArray, String textKeyAppendix, Map<Integer, String> unknownFields) {
        int i;
        ArrayList<Object> fields = new ArrayList<Object>();
        if (bookingText != null) {
            fields.add("?00" + StructuredField86.escape(bookingText));
        }
        if (primaNota != null) {
            fields.add("?10" + StructuredField86.escape(primaNota));
        }
        if (purposeArray != null) {
            for (i = 0; i < purposeArray.length; ++i) {
                int j = i < 10 ? 20 + i : 50 + i;
                fields.add("?" + j + StructuredField86.escape(purposeArray[i]));
            }
        }
        if (otherBankcode != null) {
            fields.add("?30" + StructuredField86.escape(otherBankcode));
        }
        if (otherAccount != null) {
            fields.add("?31" + StructuredField86.escape(otherAccount));
        }
        if (otherNameArray != null) {
            for (i = 0; i < otherNameArray.length && i < 2; ++i) {
                fields.add("?" + (32 + i) + StructuredField86.escape(otherNameArray[i]));
            }
        }
        if (textKeyAppendix != null) {
            fields.add("?34" + StructuredField86.escape(textKeyAppendix));
        }
        StringBuilder sb = new StringBuilder(512);
        sb.append(gvc);
        Collections.sort(fields);
        for (String string : fields) {
            sb.append(string);
        }
        fields.clear();
        while (sb.length() > 0) {
            int i2 = sb.length();
            if (i2 > 65) {
                i2 = 65;
                while (sb.charAt(i2) == '-' || sb.charAt(i2) == ':') {
                    if (--i2 != 45) continue;
                    i2 = 65;
                    break;
                }
            }
            fields.add(sb.substring(0, i2));
            sb.delete(0, i2);
        }
        String[] rawLines = new String[fields.size()];
        rawLines = fields.toArray(rawLines);
        return new StructuredField86(rawLines, gvc, bookingText, primaNota, purposeArray, otherBankcode, otherAccount, otherNameArray, textKeyAppendix, unknownFields, null);
    }

    private static String escape(String s) {
        return s.replace('?', '.');
    }

    public Map<Integer, String> getUnknownFields() {
        return this.unknownFields;
    }
}

