/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.SwiftElement;
import java.io.IOException;
import java.io.Writer;

public class PartyIdentifier
extends SwiftElement {
    private static final long serialVersionUID = 1L;
    char partyFlag;
    String accountNumber;

    public PartyIdentifier(char partyFlag, String accountNumber) {
        this.partyFlag = partyFlag;
        this.accountNumber = accountNumber;
    }

    public char getPartyFlag() {
        return this.partyFlag;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        if (this.partyFlag != ' ') {
            w.write(47);
            w.write(this.partyFlag);
        }
        if (this.accountNumber != null) {
            w.write(47);
            w.write(this.accountNumber);
        }
    }

    public static PartyIdentifier fromString(String s) {
        if (s.length() < 3) {
            return new PartyIdentifier(s.charAt(1), null);
        }
        if (s.charAt(2) == '/') {
            return new PartyIdentifier(s.charAt(1), s.substring(3));
        }
        return new PartyIdentifier(' ', s.substring(1));
    }
}

