/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.BeginRepeatHandler;
import de.businesslogics.format.swift.ElseHandler;
import de.businesslogics.format.swift.EndRepeatHandler;
import de.businesslogics.format.swift.IfHandler;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.SwiftHandler;
import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class NewSwiftParser {
    private int inLineBreak = 0;
    private int lineNumber = 1;
    private final List<String> block = new ArrayList<String>(4);
    private int maxBlockLength = 0;
    private final List<SwiftHandler> handlers = new ArrayList<SwiftHandler>();
    private int handlerPosition = 0;
    private SwiftHandler currentHandler;
    private final List<Integer> parserStack = new LinkedList<Integer>();
    private final ByteArrayOutputStream currentLine = new ByteArrayOutputStream(80);
    private final List<SwiftHandler> pendingHandlers = new ArrayList<SwiftHandler>();
    private final Charset charset;

    protected NewSwiftParser(Charset charset) {
        if (charset == null) {
            charset = Charset.forName("ISO-8859-15");
        }
        this.charset = charset;
    }

    protected void addOptional(SwiftHandler h) {
        h.mandatory = false;
        this.add(h);
    }

    protected void addMandatory(SwiftHandler h) {
        h.mandatory = true;
        this.add(h);
    }

    protected void addBeginRepeat() {
        this.add(new BeginRepeatHandler());
    }

    protected void addEndRepeat() {
        this.add(new EndRepeatHandler());
    }

    protected void addIf() {
        this.add(new IfHandler());
    }

    protected void addElse() {
        Integer i = this.parserStack.get(this.parserStack.size() - 1);
        SwiftHandler h = this.handlers.get(i);
        if (!(h instanceof IfHandler)) {
            throw new IllegalStateException("Not in if");
        }
        this.handlers.add(new ElseHandler());
        ((IfHandler)h).jumpTo = this.handlers.size();
    }

    protected void addEndIf() {
        Integer i = this.parserStack.remove(this.parserStack.size() - 1);
        SwiftHandler h = this.handlers.get(i);
        if (!(h instanceof IfHandler)) {
            throw new IllegalStateException("Endif not expected here");
        }
        IfHandler ifH = (IfHandler)h;
        if (ifH.jumpTo > 0) {
            h = this.handlers.get(ifH.jumpTo - 1);
            ((ElseHandler)h).endIf = this.handlers.size();
        } else {
            ifH.jumpTo = this.handlers.size();
        }
    }

    private void add(SwiftHandler h) {
        if (h instanceof BeginRepeatHandler) {
            this.parserStack.add(this.handlers.size());
        }
        if (h instanceof EndRepeatHandler) {
            Integer i = this.parserStack.remove(this.parserStack.size() - 1);
            if (!(this.handlers.get(i) instanceof BeginRepeatHandler)) {
                throw new IllegalStateException("End of loop not expected here");
            }
            ((EndRepeatHandler)h).loopBegin = i;
        }
        if (h instanceof IfHandler) {
            this.parserStack.add(this.handlers.size());
        }
        this.handlers.add(h);
    }

    public void parse(InputStream is) throws IOException, ParseException {
        int r;
        byte[] buffer = new byte[4096];
        while ((r = is.read(buffer)) > 0) {
            this.handleBytes(buffer, 0, r);
        }
        is.close();
        this.close();
    }

    public void parseAndClose(InputStream is) throws IOException, ParseException {
        try {
            this.parse(is);
            is = null;
        }
        finally {
            SystemUtils.close(is);
        }
    }

    public void handleBytes(byte[] v, int offset, int length) throws ParseException {
        while (length > 0) {
            byte b = v[offset];
            ++offset;
            --length;
            if (b == 13) {
                if (this.inLineBreak != 0) continue;
                this.inLineBreak = 1;
                this.handleLine();
                ++this.lineNumber;
                continue;
            }
            if (b == 10) {
                if (this.inLineBreak == 0 || this.inLineBreak == 2) {
                    this.handleLine();
                    ++this.lineNumber;
                }
                this.inLineBreak = 2;
                continue;
            }
            this.inLineBreak = 0;
            this.currentLine.write(b & 0xFF);
        }
    }

    public void close() throws ParseException {
        if (this.currentLine.size() > 0) {
            this.handleLine();
        }
        if (!this.block.isEmpty()) {
            this.currentHandler.handle(this.block);
        }
        int jumpTo = Integer.MAX_VALUE;
        while (this.handlerPosition < this.handlers.size()) {
            SwiftHandler handler = this.handlers.get(this.handlerPosition);
            if (handler instanceof EndRepeatHandler) {
                handler.handle(null);
            } else if (handler instanceof IfHandler) {
                jumpTo = ((IfHandler)handler).jumpTo;
            } else {
                if (handler instanceof ElseHandler) {
                    this.handlerPosition = ((ElseHandler)handler).endIf;
                    continue;
                }
                if (handler.mandatory) {
                    if (handler.willHandle("") != null) {
                        this.block.clear();
                        this.block.add("");
                        handler.handle(this.block);
                    } else {
                        if (jumpTo <= this.handlerPosition || jumpTo < 0) {
                            throw new ParseException("Missing mandatory handler " + String.valueOf(handler));
                        }
                        this.handlerPosition = jumpTo;
                        continue;
                    }
                }
            }
            ++this.handlerPosition;
        }
    }

    protected void throwParseException(String message) throws ParseException {
        throw new ParseException("line " + this.lineNumber + ": " + message);
    }

    private void handleLine() throws ParseException {
        this.handleLine(StringUtils.toString(this.currentLine.toByteArray(), this.charset));
        this.currentLine.reset();
    }

    private void handleLine(String s) throws ParseException {
        this.pendingHandlers.clear();
        block0: for (int i = this.handlerPosition; i < this.handlers.size(); ++i) {
            String consumed;
            SwiftHandler newHandler;
            int j;
            SwiftHandler handler = this.handlers.get(i);
            if (handler instanceof IfHandler) {
                IfHandler iHandler = (IfHandler)handler;
                j = i + 1;
                do {
                    if ((consumed = (newHandler = this.handlers.get(j)).willHandle(s)) == null) continue;
                    this.doHandle(s, newHandler);
                    this.handlerPosition = j + 1;
                    if (consumed != s) {
                        this.handleLine(s.substring(consumed.length()));
                    }
                    return;
                } while (!newHandler.isMandatory() && ++j < iHandler.jumpTo);
                i = iHandler.jumpTo;
                handler = this.handlers.get(i);
            }
            if (handler instanceof ElseHandler) {
                i = ((ElseHandler)handler).endIf;
                handler = this.handlers.get(i);
            }
            if (handler instanceof BeginRepeatHandler) {
                this.pendingHandlers.add(handler);
                continue;
            }
            if (handler instanceof EndRepeatHandler) {
                EndRepeatHandler eHandler = (EndRepeatHandler)handler;
                this.pendingHandlers.add(handler);
                for (j = eHandler.loopBegin + 1; j < i; ++j) {
                    newHandler = this.handlers.get(j);
                    consumed = newHandler.willHandle(s);
                    if (consumed != null) {
                        this.pendingHandlers.add(this.handlers.get(eHandler.loopBegin));
                        this.doHandle(s, newHandler);
                        this.handlerPosition = j + 1;
                        if (consumed != s) {
                            this.handleLine(s.substring(consumed.length()));
                        }
                        return;
                    }
                    if (newHandler.isMandatory()) continue block0;
                }
                continue;
            }
            consumed = handler.willHandle(s);
            if (consumed != null) {
                this.doHandle(s, handler);
                this.handlerPosition = i + 1;
                if (!consumed.equals(s)) {
                    this.handleLine(s.substring(consumed.length()));
                }
                return;
            }
            if (handler.isMandatory()) break;
        }
        if (this.block.size() == this.maxBlockLength) {
            throw new ParseException("Unhandled content of " + String.valueOf(this.currentHandler) + " in line " + this.lineNumber + ": " + s);
        }
        this.block.add(s);
    }

    private void doHandle(String line, SwiftHandler newHandler) throws ParseException {
        if (!this.block.isEmpty()) {
            this.currentHandler.handle(this.block);
        }
        for (SwiftHandler ph : this.pendingHandlers) {
            ph.handle(null);
        }
        this.maxBlockLength = newHandler.getMaxBlockLength();
        this.currentHandler = newHandler;
        this.block.clear();
        this.block.add(line);
    }
}

