/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.SwiftElement;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;

public class InstructionCode
extends SwiftElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final HashMap<String, InstructionCode> INSTANCES = new HashMap();
    private static final HashMap<String, InstructionCode> MT101_INSTANCES = new HashMap();
    private final String code;
    private final MT101Category mt101Category;
    private final boolean additionalInfoAllowed;
    public static final InstructionCode CHQB = new InstructionCode("CHQB", MT101Category.FollowingPartyInstruction);
    public static final InstructionCode CMSW = new InstructionCode("CMSW", MT101Category.ReceiverInstruction);
    public static final InstructionCode CMTO = new InstructionCode("CMTO", MT101Category.ReceiverInstruction, true);
    public static final InstructionCode CMZB = new InstructionCode("CMZB", MT101Category.ReceiverInstruction);
    public static final InstructionCode CORT = new InstructionCode("CORT", MT101Category.ReceiverInstruction);
    public static final InstructionCode INTC = new InstructionCode("INTC", MT101Category.ReceiverInstruction);
    public static final InstructionCode NETS = new InstructionCode("NETS", MT101Category.Routing);
    public static final InstructionCode PHON = new InstructionCode("PHON", MT101Category.FollowingPartyInstruction, true);
    public static final InstructionCode REPA = new InstructionCode("REPA", MT101Category.ReceiverInstruction, true);
    public static final InstructionCode RTGS = new InstructionCode("RTGS", MT101Category.Routing);
    public static final InstructionCode URGP = new InstructionCode("URGP", MT101Category.ReceiverInstruction);
    public static final InstructionCode OTHR = new InstructionCode("OTHR", MT101Category.Information, true);
    public static final InstructionCode SDVA = new InstructionCode("SDVA");
    public static final InstructionCode BONL = new InstructionCode("BONL");
    public static final InstructionCode HOLD = new InstructionCode("HOLD");
    public static final InstructionCode PHOB = new InstructionCode("PHOB");
    public static final InstructionCode TELB = new InstructionCode("TELB");
    public static final InstructionCode TELE = new InstructionCode("TELE");
    public static final InstructionCode PHOI = new InstructionCode("PHOI");
    public static final InstructionCode TELI = new InstructionCode("TELI");
    public static final InstructionCode EQUI = new InstructionCode("EQUI", MT101Category.Unknown);

    private InstructionCode(String code) {
        this(code, MT101Category.NotAllowed, false);
    }

    private InstructionCode(String code, MT101Category mt101Category) {
        this(code, mt101Category, false);
    }

    private InstructionCode(String code, MT101Category mt101Category, boolean additionalInfoAllowed) {
        this.code = code;
        this.mt101Category = mt101Category;
        this.additionalInfoAllowed = additionalInfoAllowed;
        INSTANCES.put(code, this);
        if (!MT101Category.NotAllowed.equals((Object)mt101Category)) {
            MT101_INSTANCES.put(code, this);
        }
    }

    public boolean isAdditionalInfoAllowed() {
        return this.additionalInfoAllowed;
    }

    public static Set<String> getAllowedMT101Codes(Collection<String> existingCodes) {
        TreeSet<String> allowedCodes = new TreeSet<String>();
        allowedCodes.addAll(MT101_INSTANCES.keySet());
        if (existingCodes != null && existingCodes.size() > 0) {
            for (String existingCode : existingCodes) {
                String[] forbiddenCodes;
                if (!InstructionCode.OTHR.code.equals(existingCode)) {
                    allowedCodes.remove(existingCode);
                }
                if ((forbiddenCodes = InstructionCode.getForbiddenMT101Codes(existingCode)) == null) continue;
                for (String forbiddenCode : forbiddenCodes) {
                    allowedCodes.remove(forbiddenCode);
                }
            }
        }
        return allowedCodes;
    }

    public static String[] getForbiddenMT101Codes(String existingCode) {
        switch (existingCode) {
            case "CHQB": {
                return new String[]{InstructionCode.CMSW.code, InstructionCode.CMTO.code, InstructionCode.CMZB.code, InstructionCode.CORT.code, InstructionCode.NETS.code, InstructionCode.PHON.code, InstructionCode.REPA.code, InstructionCode.RTGS.code, InstructionCode.URGP.code};
            }
            case "CMSW": {
                return new String[]{InstructionCode.CHQB.code, InstructionCode.CMTO.code, InstructionCode.CMZB.code, InstructionCode.CORT.code, InstructionCode.EQUI.code};
            }
            case "CMTO": {
                return new String[]{InstructionCode.CHQB.code, InstructionCode.CMSW.code, InstructionCode.CMZB.code, InstructionCode.CORT.code, InstructionCode.EQUI.code};
            }
            case "CMZB": {
                return new String[]{InstructionCode.CHQB.code, InstructionCode.CMSW.code, InstructionCode.CMTO.code, InstructionCode.CORT.code, InstructionCode.EQUI.code};
            }
            case "CORT": {
                return new String[]{InstructionCode.CHQB.code, InstructionCode.CMSW.code, InstructionCode.CMTO.code, InstructionCode.CMZB.code, InstructionCode.REPA.code};
            }
            case "EQUI": {
                return new String[]{InstructionCode.CMSW.code, InstructionCode.CMTO.code, InstructionCode.CMZB.code};
            }
            case "NETS": {
                return new String[]{InstructionCode.CHQB.code, InstructionCode.RTGS.code};
            }
            case "RTGS": {
                return new String[]{InstructionCode.CHQB.code, InstructionCode.NETS.code};
            }
            case "REPA": {
                return new String[]{InstructionCode.CHQB.code, InstructionCode.CORT.code};
            }
            case "PHON": 
            case "URGP": {
                return new String[]{InstructionCode.CHQB.code};
            }
        }
        return null;
    }

    public static int compareMT101Codes(InstructionCode ic1, InstructionCode ic2) {
        return ic1.mt101Category.compareTo(ic2.mt101Category);
    }

    public static InstructionCode getInstance(String s) {
        return INSTANCES.get(s);
    }

    private Object readResolve() throws InvalidObjectException {
        InstructionCode toReturn = INSTANCES.get(this.code);
        if (toReturn == null) {
            throw new InvalidObjectException("No such instance: " + this.code);
        }
        return toReturn;
    }

    @Override
    public String toString() {
        return this.code;
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        w.write(this.code);
    }

    public static Set<String> getInstuctionCodes() {
        return INSTANCES.keySet();
    }

    private static enum MT101Category {
        ReceiverInstruction,
        Routing,
        FollowingPartyInstruction,
        Information,
        Unknown,
        NotAllowed;

    }
}

