/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field86;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.StructuredField86;
import de.businesslogics.format.swift.SwiftHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Field86Handler
extends SwiftHandler {
    protected Field86 field86;

    @Override
    public int getMaxBlockLength() {
        return 20;
    }

    @Override
    public void handle(List<String> block) throws ParseException {
        String[] s = new String[block.size()];
        if ((s = block.toArray(s))[0].startsWith(":NS:")) {
            s[0] = s[0].substring(4);
            String gvc = null;
            String bookingText = null;
            String primaNota = null;
            String otherBankcode = null;
            String otherAccount = null;
            String textKeyAppendix = null;
            ArrayList<String> purpose = new ArrayList<String>();
            ArrayList<String> otherName = new ArrayList<String>();
            HashMap<Integer, String> unknownFields = new HashMap<Integer, String>();
            block8: for (String string : s) {
                int i = Integer.parseInt(string.substring(0, 2));
                switch (i) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        purpose.add(string.substring(2));
                        continue block8;
                    }
                    case 15: 
                    case 16: {
                        otherName.add(string.substring(2));
                        continue block8;
                    }
                    case 17: {
                        bookingText = string.substring(2);
                        continue block8;
                    }
                    case 18: {
                        primaNota = string.substring(2);
                        continue block8;
                    }
                    case 33: {
                        otherBankcode = string.substring(2);
                        continue block8;
                    }
                    case 34: {
                        otherAccount = string.substring(2);
                        continue block8;
                    }
                    default: {
                        unknownFields.put(i, string);
                    }
                }
            }
            this.field86 = StructuredField86.generate(gvc, bookingText, primaNota, purpose.toArray(new String[0]), otherBankcode, otherAccount, otherName.toArray(new String[0]), textKeyAppendix, unknownFields);
        } else {
            s[0] = s[0].substring(4);
            this.field86 = Field86.createField(s);
        }
    }

    @Override
    public String willHandle(String firstLine) {
        return firstLine.startsWith(":86:") || firstLine.startsWith(":NS:") ? firstLine : null;
    }
}

