/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.SwiftElement;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Date;

public class Field64
extends SwiftElement {
    private static final long serialVersionUID = 1L;
    private final String valueDate;
    private final BigDecimal balance;
    private final Currency currency;

    public Field64(String valueDate, BigDecimal balance, Currency currency) {
        this.valueDate = valueDate;
        this.balance = balance;
        this.currency = currency;
    }

    public Field64(Date valueDate, BigDecimal balance, Currency currency) {
        this(Field64.formatJJMMTT(valueDate), balance, currency);
    }

    public String getValutaDate() {
        return this.valueDate;
    }

    public Date getValuta() {
        return Field64.parseJJMMTT(this.valueDate);
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        w.write(":64:");
        this.writeAttributes(w);
    }

    protected void writeAttributes(Writer w) throws IOException {
        w.write(this.balance.signum() < 0 ? 68 : 67);
        w.write(this.valueDate);
        w.write(this.currency.getCurrencyCode());
        Field64.writeDecimal(w, this.balance);
        w.write("\r\n");
    }
}

