/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field62F;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.SwiftHandler;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.List;

public abstract class Field62FHandler
extends SwiftHandler {
    protected Field62F field62F;

    @Override
    public int getMaxBlockLength() {
        return 1;
    }

    protected abstract Currency guessCurrency();

    @Override
    public void handle(List<String> block) throws ParseException {
        String s = block.get(0);
        Currency c = null;
        int start = 15;
        try {
            c = this.parseCurrency(s.substring(12, 15));
        }
        catch (IllegalArgumentException arg) {
            c = this.guessCurrency();
            start = this.skipNonInteger(s, 12);
        }
        BigDecimal a = this.parseDecimal(s.substring(start));
        if (s.charAt(5) == 'D') {
            a = a.negate();
        }
        this.field62F = new Field62F(s.substring(6, 12), a, c);
    }

    @Override
    public String willHandle(String firstLine) {
        return firstLine.startsWith(":62F:") ? firstLine : null;
    }
}

