/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field61;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.SwiftHandler;
import java.math.BigDecimal;
import java.util.List;

public class Field61Handler
extends SwiftHandler {
    protected Field61 field61;

    @Override
    public int getMaxBlockLength() {
        return 2;
    }

    @Override
    public void handle(List<String> block) throws ParseException {
        String customerReference;
        boolean negative;
        char c;
        String s = block.get(0);
        String valuta = s.substring(4, 10);
        int i = 10;
        Object booking = null;
        if (Character.isDigit(s.charAt(i))) {
            booking = s.substring(i, i + 4);
            i += 4;
            if (!Character.isDigit(((String)booking).charAt(3))) {
                --i;
                booking = ((String)booking).substring(0, 2) + "0" + ((String)booking).charAt(2);
            }
            if (((String)booking).length() < 4) {
                booking = "0" + (String)booking;
            }
        }
        boolean storno = false;
        if (s.charAt(i) == 'R') {
            ++i;
            storno = true;
        }
        boolean expected = false;
        if (s.charAt(i) == 'E') {
            ++i;
            expected = true;
        }
        if ((c = s.charAt(i)) == 'C') {
            negative = false;
        } else if (c == 'D') {
            negative = true;
        } else {
            throw new ParseException("Credit or debit flag expected in line: " + s);
        }
        char currencyChar = s.charAt(++i);
        if (Character.isLetter(currencyChar)) {
            ++i;
        } else {
            currencyChar = ' ';
        }
        int j = i++;
        while (i < s.length() && (Character.isDigit(c = s.charAt(i)) || c == ',')) {
            ++i;
        }
        BigDecimal amount = this.parseDecimal(s.substring(j, i));
        if (negative ^ storno) {
            amount = amount.negate();
        }
        String bookingKey = s.substring(++i, i + 3);
        String bankReference = null;
        int j2 = s.indexOf("//", i += 3);
        if (j2 > 0) {
            customerReference = s.substring(i, j2);
            bankReference = s.substring(j2 + 2);
        } else {
            customerReference = s.substring(i);
        }
        String additionalInfo = null;
        if (block.size() == 2) {
            additionalInfo = block.get(1);
        }
        this.field61 = new Field61(valuta, (String)booking, storno, expected, currencyChar, amount, bookingKey, customerReference, bankReference, additionalInfo);
    }

    @Override
    public String willHandle(String firstLine) {
        return firstLine.startsWith(":61:") ? firstLine : null;
    }
}

