/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field62F;
import de.businesslogics.format.swift.SwiftElement;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Field61
extends SwiftElement {
    private static final long serialVersionUID = 1L;
    private final String valuta;
    private final String booking;
    private final String bookingKey;
    private final String customerReference;
    private final String bankReference;
    private final String additionalInfo;
    private Date bookingDate;
    private Date valutaDate;
    private final boolean reversal;
    private boolean expected;
    private final char currencyChar;
    private final BigDecimal amount;

    public Field61(String valuta, String booking, boolean reversal, boolean expected, char currencyChar, BigDecimal amount, String bookingKey, String customerReference, String bankReference, String additionalInfo) {
        this.valuta = valuta;
        this.booking = booking;
        this.reversal = reversal;
        this.expected = expected;
        this.currencyChar = currencyChar;
        this.amount = amount;
        this.bookingKey = bookingKey;
        this.customerReference = customerReference;
        this.bankReference = bankReference;
        this.additionalInfo = additionalInfo;
    }

    public String getValutaDate() {
        return this.valuta;
    }

    public Date getValuta() {
        if (this.valutaDate == null) {
            this.valutaDate = Field61.parseJJMMTT(this.valuta);
        }
        return this.valutaDate;
    }

    public String getBookingDate() {
        return this.booking;
    }

    public Date getBooking(Field62F field62F) {
        if (field62F != null) {
            return this.getBookingDate(field62F.getBooking());
        }
        return this.getBookingDate(this.getValuta());
    }

    public Date getBookingDate(Date closingDate) {
        if (this.bookingDate == null) {
            if (this.booking != null) {
                if (closingDate != null) {
                    int year = Integer.parseInt(new SimpleDateFormat("yy").format(closingDate));
                    Date possibleBookingDate = Field61.parseJJMMTT(String.format("%02d", year) + this.booking);
                    int yearBefore = year - 1;
                    this.bookingDate = yearBefore >= 0 && possibleBookingDate.after(closingDate) ? Field61.parseJJMMTT(String.format("%02d", yearBefore) + this.booking) : possibleBookingDate;
                } else {
                    int year = Integer.parseInt(this.valuta.substring(0, 2));
                    int yearBefore = year - 1;
                    int yearAfter = year + 1;
                    Date d1 = Field61.parseJJMMTT(String.format("%02d", year) + this.booking);
                    Date d2 = Field61.parseJJMMTT(String.format("%02d", yearBefore) + this.booking);
                    Date d3 = Field61.parseJJMMTT(String.format("%02d", yearAfter) + this.booking);
                    Date valueDate = this.getValuta();
                    long diff1 = Math.abs(d1.getTime() - valueDate.getTime());
                    long diff2 = Math.abs(d2.getTime() - valueDate.getTime());
                    long diff3 = Math.abs(d3.getTime() - valueDate.getTime());
                    long diff = Math.min(Math.min(diff1, diff2), diff3);
                    this.bookingDate = diff == diff1 ? d1 : (diff == diff2 ? d2 : d3);
                }
            } else {
                this.bookingDate = closingDate;
            }
        }
        return this.bookingDate;
    }

    @Deprecated
    public Currency getCurrency(Currency accountCurrency) {
        if (this.currencyChar == ' ') {
            return accountCurrency;
        }
        return Currency.getInstance(accountCurrency.getCurrencyCode().substring(0, 2) + this.currencyChar);
    }

    public boolean isReversal() {
        return this.reversal;
    }

    public boolean isExpected() {
        return this.expected;
    }

    public void setExpected(boolean expected) {
        this.expected = expected;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getBookingKey() {
        return this.bookingKey;
    }

    public String getCustomerReference() {
        return this.customerReference;
    }

    public String getBankReference() {
        return this.bankReference;
    }

    public String getAdditionalInformation() {
        return this.additionalInfo;
    }

    public String getCreditDebitFlag() {
        if (this.reversal) {
            return this.amount.signum() < 0 ^ this.reversal ? "RD" : "RC";
        }
        return this.amount.signum() < 0 ^ this.reversal ? "D" : "C";
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        w.write(":61:");
        w.write(this.valuta);
        if (this.booking != null) {
            w.write(this.booking);
        }
        if (this.reversal) {
            w.write(82);
        } else if (this.expected) {
            w.write(69);
        }
        w.write(this.amount.signum() < 0 ^ this.reversal ? 68 : 67);
        if (this.currencyChar != ' ') {
            w.write(this.currencyChar);
        }
        Field61.writeDecimal(w, this.amount);
        w.write(78);
        w.write(this.bookingKey);
        w.write(this.customerReference);
        if (this.bankReference != null) {
            w.write("//");
            w.write(this.bankReference);
        }
        w.write("\r\n");
        if (this.additionalInfo != null) {
            w.write(this.additionalInfo);
            w.write("\r\n");
        }
    }
}

