/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.SwiftElement;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;

public class Field60F
extends SwiftElement {
    private static final long serialVersionUID = 1L;
    private final String bookingDate;
    private final BigDecimal balance;
    private final Currency currency;

    public Field60F(String bookingDate, BigDecimal balance, Currency currency) {
        this.bookingDate = bookingDate;
        this.balance = balance;
        this.currency = currency;
    }

    public Field60F(Date bookingDate, BigDecimal balance, Currency currency) {
        this(bookingDate == null ? "000000" : Field60F.formatJJMMTT(bookingDate), balance, currency);
    }

    public String getBookingDate() {
        return this.bookingDate;
    }

    public Date getBooking() {
        if ("000000".equals(this.bookingDate)) {
            return null;
        }
        return Field60F.parseJJMMTT(this.bookingDate);
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getBalanceString(Locale l) {
        return this.formatAmount(this.balance, l);
    }

    public String formatAmount(BigDecimal amount, Locale l) {
        if (this.currency != null) {
            NumberFormat nf = NumberFormat.getCurrencyInstance(l);
            if (nf instanceof DecimalFormat) {
                DecimalFormat df = (DecimalFormat)nf;
                DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
                dfs.setInternationalCurrencySymbol(this.currency.getCurrencyCode());
                df.setDecimalFormatSymbols(dfs);
            }
            nf.setMinimumFractionDigits(this.currency.getDefaultFractionDigits());
            return nf.format(amount.doubleValue());
        }
        NumberFormat nf = NumberFormat.getNumberInstance(l);
        return nf.format(amount.doubleValue());
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        w.write(":60F:");
        this.writeAttributes(w);
    }

    protected void writeAttributes(Writer w) throws IOException {
        w.write(this.balance.signum() < 0 ? 68 : 67);
        w.write(this.bookingDate);
        w.write(this.currency.getCurrencyCode());
        Field60F.writeDecimal(w, this.balance);
        w.write("\r\n");
    }
}

