/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field59;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.SwiftHandler;
import java.util.List;

public abstract class Field59Handler
extends SwiftHandler {
    private int offset;
    protected Field59 field59;

    @Override
    public int getMaxBlockLength() {
        return 4 + this.offset;
    }

    @Override
    public void handle(List<String> block) throws ParseException {
        String[] address = new String[block.size() - this.offset];
        if (address.length == 0) {
            throw new ParseException("Name and address missing");
        }
        for (int i = this.offset; i < block.size(); ++i) {
            String s = block.get(i);
            if (i == 0) {
                s = s.substring(4);
            }
            address[i - this.offset] = s;
        }
        this.field59 = new Field59(address);
        if (this.offset != 0) {
            this.field59.setAccount(block.get(0).substring(5));
        }
    }

    @Override
    public String willHandle(String firstLine) {
        if (firstLine.startsWith(":59:") && firstLine.length() > 4) {
            this.offset = firstLine.charAt(4) == '/' ? 1 : 0;
            return firstLine;
        }
        return null;
    }
}

