/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field59A;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.SwiftHandler;
import java.util.List;

public abstract class Field59AHandler
extends SwiftHandler {
    private boolean account;
    protected Field59A field59A;

    @Override
    public int getMaxBlockLength() {
        return this.account ? 2 : 1;
    }

    @Override
    public void handle(List<String> block) throws ParseException {
        if (this.account) {
            if (block.size() != 2) {
                throw new ParseException("BIC missing");
            }
            this.field59A = new Field59A(block.get(1));
            this.field59A.setAccount(block.get(0).substring(6));
        } else {
            this.field59A = new Field59A(block.get(0).substring(5));
        }
    }

    @Override
    public String willHandle(String firstLine) {
        if (firstLine.startsWith(":59A:") && firstLine.length() > 5) {
            this.account = firstLine.charAt(5) == '/';
            return firstLine;
        }
        return null;
    }
}

