/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field57B;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.PartyIdentifier;
import de.businesslogics.format.swift.SwiftHandler;
import java.util.List;

public abstract class Field57BHandler
extends SwiftHandler {
    private boolean partyIdentifier;
    protected Field57B field57B;

    @Override
    public int getMaxBlockLength() {
        return this.partyIdentifier ? 2 : 1;
    }

    @Override
    public void handle(List<String> block) throws ParseException {
        this.field57B = new Field57B();
        if (this.partyIdentifier) {
            String s = block.get(0);
            this.field57B.setPartyIdentifier(PartyIdentifier.fromString(s.substring(5)));
            if (block.size() == 2) {
                this.field57B.setLocation(block.get(1));
            }
        } else {
            this.field57B.setLocation(block.get(0).substring(5));
        }
    }

    @Override
    public String willHandle(String firstLine) {
        if (firstLine.startsWith(":57B:") && firstLine.length() > 5) {
            this.partyIdentifier = firstLine.charAt(5) == '/';
            return firstLine;
        }
        return null;
    }
}

