/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field53D;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.PartyIdentifier;
import de.businesslogics.format.swift.SwiftHandler;
import java.util.ArrayList;
import java.util.List;

public abstract class Field53DHandler
extends SwiftHandler {
    private boolean partyIdentifier;
    protected Field53D field53D;

    @Override
    public int getMaxBlockLength() {
        return this.partyIdentifier ? 5 : 4;
    }

    @Override
    public void handle(List<String> block) throws ParseException {
        PartyIdentifier pI = null;
        ArrayList<String> address = new ArrayList<String>(4);
        if (this.partyIdentifier) {
            if (block.size() == 1) {
                throw new ParseException("Name and address missing");
            }
            String s = block.get(0);
            pI = PartyIdentifier.fromString(s.substring(5));
        } else {
            address.add(block.get(0).substring(5));
        }
        for (int i = 1; i < block.size(); ++i) {
            address.add(block.get(i));
        }
        this.field53D = new Field53D(address.toArray(new String[address.size()]));
        this.field53D.setPartyIdentifier(pI);
    }

    @Override
    public String willHandle(String firstLine) {
        if (firstLine.startsWith(":53D:") && firstLine.length() > 5) {
            this.partyIdentifier = firstLine.charAt(5) == '/';
            return firstLine;
        }
        return null;
    }
}

