/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field53A;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.PartyIdentifier;
import de.businesslogics.format.swift.SwiftHandler;
import java.util.List;

public abstract class Field53AHandler
extends SwiftHandler {
    private boolean partyIdentifier;
    protected Field53A field53A;

    @Override
    public int getMaxBlockLength() {
        return this.partyIdentifier ? 2 : 1;
    }

    @Override
    public void handle(List<String> block) throws ParseException {
        if (this.partyIdentifier) {
            if (block.size() != 2) {
                throw new ParseException("BIC missing");
            }
            this.field53A = new Field53A(block.get(1));
            String s = block.get(0);
            this.field53A.setPartyIdentifier(PartyIdentifier.fromString(s.substring(5)));
        } else {
            this.field53A = new Field53A(block.get(0).substring(5));
        }
    }

    @Override
    public String willHandle(String firstLine) {
        if (firstLine.startsWith(":53A:") && firstLine.length() > 5) {
            this.partyIdentifier = firstLine.charAt(5) == '/';
            return firstLine;
        }
        return null;
    }
}

