/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field52A;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.PartyIdentifier;
import de.businesslogics.format.swift.SwiftHandler;
import java.util.List;

public abstract class Field52AHandler
extends SwiftHandler {
    private boolean partyIdentifier;
    protected Field52A field52A;

    @Override
    public int getMaxBlockLength() {
        return this.partyIdentifier ? 2 : 1;
    }

    @Override
    public void handle(List<String> block) throws ParseException {
        if (this.partyIdentifier) {
            if (block.size() != 2) {
                throw new ParseException("BIC missing");
            }
            this.field52A = new Field52A(block.get(1));
            String s = block.get(0);
            this.field52A.setPartyIdentifier(PartyIdentifier.fromString(s.substring(5)));
        } else {
            this.field52A = new Field52A(block.get(0).substring(5));
        }
    }

    @Override
    public String willHandle(String firstLine) {
        if (firstLine.startsWith(":52A:") && firstLine.length() > 5) {
            this.partyIdentifier = firstLine.charAt(5) == '/';
            return firstLine;
        }
        return null;
    }
}

