/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field50K;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.SwiftHandler;
import java.util.List;

public abstract class Field50KHandler
extends SwiftHandler {
    private int offset;
    protected Field50K field50K;

    @Override
    public int getMaxBlockLength() {
        return 4 + this.offset;
    }

    @Override
    public void handle(List<String> block) throws ParseException {
        String[] address = new String[block.size() - this.offset];
        if (address.length == 0) {
            throw new ParseException("Name and address missing");
        }
        for (int i = this.offset; i < block.size(); ++i) {
            String s = block.get(i);
            if (i == 0) {
                s = s.substring(5);
            }
            address[i - this.offset] = s;
        }
        this.field50K = new Field50K(address);
        if (this.offset != 0) {
            this.field50K.setAccount(block.get(0).substring(6));
        }
    }

    @Override
    public String willHandle(String firstLine) {
        if (firstLine.startsWith(":50K:") && firstLine.length() > 5) {
            this.offset = firstLine.charAt(5) == '/' ? 1 : 0;
            return firstLine;
        }
        return null;
    }
}

