/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field50G;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.SwiftHandler;
import java.util.List;

public abstract class Field50GHandler
extends SwiftHandler {
    protected Field50G field50G;

    @Override
    public int getMaxBlockLength() {
        return 2;
    }

    @Override
    public void handle(List<String> block) throws ParseException {
        if (block.size() < 2) {
            throw new ParseException("BEI missing");
        }
        String bic = block.get(1);
        if (!BIC_PATTERN.matcher(bic).matches()) {
            throw new ParseException("Invalid BEI");
        }
        this.field50G = new Field50G(block.get(0).substring(6).trim(), bic);
    }

    @Override
    public String willHandle(String firstLine) {
        return firstLine.startsWith(":50G:/") && firstLine.length() > 6 ? firstLine : null;
    }
}

