/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field50F;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.SwiftHandler;
import java.util.List;

public abstract class Field50FHandler
extends SwiftHandler {
    protected Field50F field50F;

    @Override
    public int getMaxBlockLength() {
        return 5;
    }

    @Override
    public void handle(List<String> block) throws ParseException {
        String[] address = new String[block.size() - 1];
        if (address.length == 0) {
            throw new ParseException("Name and address missing");
        }
        for (int i = 1; i < block.size(); ++i) {
            address[i - 1] = block.get(i);
        }
        this.field50F = new Field50F(block.get(0).substring(5), address);
    }

    @Override
    public String willHandle(String firstLine) {
        return firstLine.startsWith(":50F:") && firstLine.length() > 5 ? firstLine : null;
    }
}

