/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.OrderingCustomer;
import java.io.IOException;
import java.io.Writer;

public class Field50F
extends OrderingCustomer {
    private static final long serialVersionUID = 1L;
    String[] address;

    public Field50F(String account, String[] address) {
        super(account);
        this.address = address;
    }

    public String[] getAddress() {
        return this.address;
    }

    public String getPartyIdentifierCode() {
        String a = this.getAccount();
        if (a == null || a.length() < 5 || a.charAt(4) != '/') {
            return null;
        }
        return a.substring(0, 4);
    }

    public String getPartyIdentifierValue() {
        String a = this.getAccount();
        if (a == null || a.length() < 5 || a.charAt(4) != '/') {
            return null;
        }
        return a.substring(5);
    }

    @Override
    public String getAccount() {
        String a = super.getAccount();
        if (a == null || a.length() == 0 || a.charAt(0) != '/') {
            return null;
        }
        return a.substring(1);
    }

    @Override
    public void setAccount(String account) {
        super.setAccount(account == null ? null : "/" + account);
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        w.write(":50F:");
        w.write(this.account);
        w.write("\r\n");
        for (int i = 0; i < this.address.length; ++i) {
            w.write(this.address[i]);
            w.write("\r\n");
        }
    }

    public String[] getParsedName() {
        return this.getLines(1);
    }

    public String[] getParsedAddress() {
        return this.getLines(2);
    }

    public String getCountry() {
        String[] ss = this.getLines(3);
        if (ss == null) {
            return null;
        }
        String s = ss[0];
        if (s.length() == 2) {
            return s;
        }
        if (s.length() > 3 && s.charAt(2) == '/') {
            return s.substring(0, 2);
        }
        return null;
    }

    public String[] getTown() {
        String[] toReturn = this.getLines(3);
        if (toReturn == null) {
            return null;
        }
        String s = toReturn[0];
        if (s.length() > 2 && s.charAt(2) == '/') {
            toReturn[0] = s.substring(3);
        }
        return toReturn;
    }

    private String[] getLines(int i) {
        int end;
        int begin;
        for (begin = 0; begin < this.address.length; ++begin) {
            String s = this.address[begin];
            if (s == null || s.length() < 2 || s.charAt(1) != '/') {
                return null;
            }
            int j = s.charAt(0) - 48;
            if (j > i) {
                return null;
            }
            if (j == i) break;
        }
        if (begin >= this.address.length) {
            return null;
        }
        for (end = this.address.length - 1; end >= begin; --end) {
            String s = this.address[end];
            if (s == null || s.length() < 2 || s.charAt(1) != '/') {
                return null;
            }
            int j = s.charAt(0) - 48;
            if (j == i) break;
        }
        String[] toReturn = new String[end - begin + 1];
        i = 0;
        while (begin <= end) {
            toReturn[i] = this.address[begin].substring(2);
            ++i;
            ++begin;
        }
        return toReturn;
    }
}

