/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field34F;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.SwiftHandler;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.List;

public class Field34FHandler
extends SwiftHandler {
    protected Field34F field34F;

    @Override
    public int getMaxBlockLength() {
        return 1;
    }

    @Override
    public void handle(List<String> block) throws ParseException {
        String s = block.get(0);
        Currency currency = this.parseCurrency(s.substring(5, 8));
        int i = 8;
        boolean negative = true;
        if (s.charAt(8) == 'C') {
            negative = false;
            i = 9;
        } else if (s.charAt(8) == 'D') {
            negative = true;
            i = 9;
        }
        BigDecimal amount = this.parseDecimal(s.substring(i));
        if (negative) {
            amount = amount.negate();
        }
        this.field34F = new Field34F(amount, currency);
    }

    @Override
    public String willHandle(String firstLine) {
        return firstLine.startsWith(":34F:") ? firstLine : null;
    }
}

