/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.SwiftElement;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Date;

public class Field32A
extends SwiftElement {
    private static final long serialVersionUID = 1L;
    private String valueDate;
    private Date valueDateAsDate;
    private final Currency currency;
    private final BigDecimal amount;

    public Field32A(String valueDate, Currency currency, BigDecimal amount) {
        this.amount = amount;
        this.currency = currency;
        this.valueDate = valueDate;
    }

    public String getValueDate() {
        return this.valueDate;
    }

    public Date getValueDateAsDate() {
        if (this.valueDateAsDate == null) {
            this.valueDateAsDate = Field32A.parseJJMMTT(this.valueDate);
        }
        return this.valueDateAsDate;
    }

    public void setValueDate(Date valueDate) {
        this.valueDate = Field32A.formatJJMMTT(valueDate);
        this.valueDateAsDate = valueDate;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        w.write(":32A:");
        w.write(this.valueDate);
        w.write(this.currency.getCurrencyCode());
        Field32A.writeDecimal(w, this.amount);
        w.write("\r\n");
    }
}

