/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.SwiftElement;
import java.io.IOException;
import java.io.Writer;

public class Field28C
extends SwiftElement {
    private static final long serialVersionUID = 1L;
    private final int number;
    private final int sheet;

    public Field28C(int number, int sheet) {
        if (number < 0 || sheet < 0) {
            throw new IllegalArgumentException("Number and page must not be negative");
        }
        this.number = number;
        this.sheet = sheet;
    }

    public int getNumber() {
        return this.number;
    }

    public int getSheet() {
        return this.sheet;
    }

    @Override
    public String toString() {
        if (this.sheet > 0) {
            return String.valueOf(this.number) + "/" + String.valueOf(this.sheet);
        }
        return String.valueOf(this.number);
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        w.write(":28C:");
        w.write(Integer.toString(this.number));
        if (this.sheet > 0) {
            w.write(47);
            w.write(Integer.toString(this.sheet));
        }
        w.write("\r\n");
    }

    public static Field28C getInstance(String in) {
        int number = 0;
        int page = 0;
        int pos = in.indexOf(47);
        if (pos > 0) {
            number = Integer.valueOf(in.substring(0, pos));
            page = Integer.valueOf(in.substring(pos + 1));
        } else {
            number = Integer.valueOf(in);
        }
        return new Field28C(number, page);
    }
}

