/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.SwiftElement;
import java.io.IOException;
import java.io.Writer;

public class Field25
extends SwiftElement {
    private static final long serialVersionUID = 1L;
    String value;

    public Field25(String iban) {
        if (iban != null) {
            iban = iban.trim();
        }
        this.value = iban;
    }

    public Field25(String bankcode, String account) {
        if (bankcode != null) {
            bankcode = bankcode.trim();
        }
        if (account != null) {
            account = account.trim();
        }
        this.value = bankcode + "/" + account;
    }

    public String getPlainValue() {
        return this.value;
    }

    public String getBankcode() {
        int i = this.value.indexOf(47);
        return i > 0 ? this.value.substring(0, i) : null;
    }

    public String getAccount() {
        int i = this.value.indexOf(47);
        if (i < 1) {
            return this.value;
        }
        String toReturn = this.value.substring(i + 1);
        if (toReturn.length() < 4) {
            return toReturn;
        }
        for (i = 1; i < 4; ++i) {
            if (Character.isLetter(toReturn.charAt(toReturn.length() - i))) continue;
            return toReturn;
        }
        return toReturn.substring(0, toReturn.length() - 3);
    }

    public boolean isBIC() {
        return Character.isLetter(this.value.charAt(0));
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        w.write(":25:");
        w.write(this.value);
        w.write("\r\n");
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Field25)) {
            return false;
        }
        return this.value.equals(((Field25)obj).value);
    }
}

