/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field23E;
import de.businesslogics.format.swift.InstructionCode;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.SwiftHandler;
import java.util.List;

public abstract class Field23EHandler
extends SwiftHandler {
    protected Field23E field23E;

    @Override
    public void handle(List<String> block) throws ParseException {
        String l = block.get(0);
        String s = l.substring(5, 9);
        InstructionCode instructionCode = InstructionCode.getInstance(s);
        if (instructionCode == null) {
            throw new ParseException("Unknown instruction code" + s);
        }
        this.field23E = new Field23E(instructionCode);
        s = l.trim();
        if (s.length() > 9) {
            if (s.charAt(9) != '/') {
                throw new ParseException("Missing separator");
            }
            this.field23E.setAdditionalInformation(s.substring(10));
        }
    }

    @Override
    public String willHandle(String firstLine) {
        return firstLine.startsWith(":23E:") && firstLine.length() >= 9 ? firstLine : null;
    }
}

