/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.swift;

import de.businesslogics.format.swift.Field13;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Field13D
extends Field13 {
    private static final long serialVersionUID = 1L;
    private final TimeZone timeZone;

    public Field13D(String timestamp, String timeZone) {
        super(timestamp);
        this.timeZone = TimeZone.getTimeZone("GMT" + timeZone);
    }

    public Field13D(Date d) {
        super(new SimpleDateFormat("yyMMddHHmm").format(d));
        this.timeZone = TimeZone.getTimeZone("GMT" + Field13D.formatOffset(TimeZone.getDefault().getOffset(d.getTime())));
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        w.write(":13D:");
        w.write(this.timestamp);
        w.write(Field13D.formatOffset(this.timeZone.getRawOffset()));
        w.write("\r\n");
    }

    private static String formatOffset(int milliseconds) {
        StringBuilder sb = new StringBuilder(5);
        if (milliseconds >= 0) {
            sb.append('+');
        } else {
            sb.append('-');
            milliseconds = -milliseconds;
        }
        int hours = milliseconds / 3600000;
        int minutes = (milliseconds - 3600000 * hours) / 60000;
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours);
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes);
        return sb.toString();
    }
}

