/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.pdf;

import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.format.sepa.GeneralSEPAReportExtractor;
import de.businesslogics.format.sepa.RejectedSEPALogicalFile;
import de.businesslogics.format.sepa.RejectedSEPAOrder;
import de.businesslogics.format.sepa.RejectedSEPAPayment;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.StatusCode;
import de.businesslogics.format.sepa.StatusReason;
import de.businesslogics.format.sepa.StatusTransactionInfo;
import de.businesslogics.format.sepa.pdf.Messages;
import de.businesslogics.io.NoCloseInputStream;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;

public class StatusReportGenerator {
    private static final String CRJ = "CRJ";
    private static final String CRZ = "CRZ";
    private static final String CDR = "CDR";
    private static final String CDZ = "CDZ";
    private static final String CIR = "CIR";
    private static final String CIZ = "CIZ";
    private static final String CIP = "CIP";
    private static final String AXS = "AXS";
    private static final String VPZ = "VPZ";
    private static final float SPACING = 20.0f;
    private List<RejectedSEPAOrder> rejectedOrders;
    private final Locale locale;
    private final Messages messages;
    private boolean printOnlyRejected = false;

    public void setPrintOnlyRejected(boolean printOnlyRejected) {
        this.printOnlyRejected = printOnlyRejected;
    }

    public StatusReportGenerator(List<RejectedSEPAOrder> rejectedOrders, Locale locale) {
        this.rejectedOrders = rejectedOrders;
        this.locale = locale;
        this.messages = new Messages(locale);
    }

    public void setRejectedOrders(List<RejectedSEPAOrder> list) {
        this.rejectedOrders = list;
    }

    public static ReportType getReportType(String reportOrderType) {
        if (CDZ.equals(reportOrderType) || CDR.equals(reportOrderType)) {
            return ReportType.DEBIT;
        }
        if (CIZ.equals(reportOrderType) || CIR.equals(reportOrderType)) {
            return ReportType.INST;
        }
        if (CRJ.equals(reportOrderType) || CRZ.equals(reportOrderType)) {
            return ReportType.CREDIT;
        }
        if (AXS.equals(reportOrderType)) {
            return ReportType.FOREIGN;
        }
        if (VPZ.equals(reportOrderType)) {
            return ReportType.VOP;
        }
        return null;
    }

    private StatusCode.StatusCodeContext getStatusCodeContext(String orderType, ReportType externalReportType) {
        if (CIP.equals(orderType) || ReportType.INST.equals((Object)externalReportType)) {
            return StatusCode.StatusCodeContext.SCT_INST;
        }
        return StatusCode.StatusCodeContext.SEPA;
    }

    public void addToDocument(ReportType externalReportType, String bankname, BLDocument doc) throws PDFException {
        boolean isVopReport = ReportType.VOP.equals((Object)externalReportType);
        int countRejectedOrders = this.rejectedOrders.size();
        for (int i = 0; i < countRejectedOrders; ++i) {
            int countLogicalFiles;
            RejectedSEPAOrder rejectedOrder = this.rejectedOrders.get(i);
            List<RejectedSEPALogicalFile> logicalFiles = rejectedOrder.getRejectedLogicalFiles();
            int n = countLogicalFiles = logicalFiles == null ? 0 : logicalFiles.size();
            if (i > 0) {
                doc.setPageSize(countLogicalFiles > 0 ? BLDocument.PageLayout.A4_LANDSCAPE : BLDocument.PageLayout.A4);
                doc.newPage();
            }
            doc.addHeadline(this.getTitle(rejectedOrder, externalReportType, bankname), BLFont.FONT_BIG_BOLD, Alignment.ALIGN_CENTER, 20.0f);
            BLFont descriptionFont = BLFont.FONT_NORMAL;
            String groupStatusCode = rejectedOrder.getStatusCode();
            if (countLogicalFiles == 0) {
                doc.addTextln(this.getOrderStateDescription(rejectedOrder, externalReportType), descriptionFont);
                BLTable<?> orderDataTable = this.getOrderDataTable(rejectedOrder, bankname);
                doc.addTable(orderDataTable);
                this.addReasonCodeTable(doc, rejectedOrder.getStatusReasons(), groupStatusCode);
                doc.addTextln(this.getReportCreationInfo(rejectedOrder.getReportCreationDate(), bankname), descriptionFont);
                return;
            }
            String bundleKey = isVopReport ? "StatusReport.description.vopInfo1" : "StatusReport.description.reportCreationInfo1";
            doc.addTextln(this.messages.getString(bundleKey), descriptionFont);
            BLTable<?> orderDataTable = this.getOrderDataTable(rejectedOrder, bankname);
            doc.addTable(orderDataTable);
            bundleKey = isVopReport ? "StatusReport.description.vopInfo2" : "StatusReport.description.reportCreationInfo2";
            doc.addTextln(MessageFormat.format(this.messages.getString(bundleKey), DateFormat.getDateInstance().format(rejectedOrder.getReportCreationDate()), DateFormat.getTimeInstance().format(rejectedOrder.getReportCreationDate()), bankname), descriptionFont);
            doc.addVSpace(20.0f);
            boolean hasRejectionCodesOnGroupLevel = this.addReasonCodeTable(doc, rejectedOrder.getStatusReasons(), groupStatusCode);
            if (countLogicalFiles <= 0) continue;
            ArrayList<RejectedSEPALogicalFile> logicalFilesWithPayments = new ArrayList<RejectedSEPALogicalFile>();
            ArrayList<RejectedSEPALogicalFile> logicalFilesWithoutPayments = new ArrayList<RejectedSEPALogicalFile>();
            for (RejectedSEPALogicalFile logicalFile : logicalFiles) {
                List<RejectedSEPAPayment> payments = logicalFile.getRejectedPayments();
                if (payments != null && payments.size() > 0) {
                    logicalFile.setUniqueTransactionStatusCode(this.getUniqueTransactionStatusCode(payments));
                    logicalFilesWithPayments.add(logicalFile);
                    continue;
                }
                logicalFilesWithoutPayments.add(logicalFile);
            }
            HashSet<String> allRejectionCodes = new HashSet<String>();
            if (logicalFilesWithPayments.size() > 0) {
                statusCodeContext = this.getStatusCodeContext(rejectedOrder.getOrderType(), externalReportType);
                for (RejectedSEPALogicalFile logicalFile : logicalFilesWithPayments) {
                    List<RejectedSEPAPayment> payments;
                    if (logicalFile.getStatusCodePaymentsMap().size() > 0 && !isVopReport) {
                        if (logicalFile.getStatusTransactionInfos().size() > 0) {
                            this.printStatusTransactionInfoTable(doc, logicalFile, statusCodeContext, externalReportType);
                        }
                        for (Map.Entry<String, List<RejectedSEPAPayment>> entry : logicalFile.getStatusCodePaymentsMap().entrySet()) {
                            String statusCode = entry.getKey();
                            if (this.printOnlyRejected && !"RJCT".equals(statusCode)) continue;
                            this.printPaymentsTable(doc, externalReportType, hasRejectionCodesOnGroupLevel, allRejectionCodes, logicalFile.getLogicalFileId(), statusCode, entry.getValue());
                            if (hasRejectionCodesOnGroupLevel || allRejectionCodes.isEmpty()) continue;
                            this.printRejectionCodeTable(doc, allRejectionCodes);
                            allRejectionCodes.clear();
                        }
                    }
                    if ((payments = logicalFile.getRejectedPaymentsWithoutIndividualStatusCode()).size() <= 0) continue;
                    String statusCode = logicalFile.getStatusCode();
                    if (statusCode == null) {
                        statusCode = logicalFile.getUniqueTransactionStatusCode();
                    }
                    this.printPaymentsTable(doc, externalReportType, hasRejectionCodesOnGroupLevel, allRejectionCodes, logicalFile.getLogicalFileId(), statusCode, payments);
                }
                if (isVopReport) {
                    if (this.hasStatusTransactionInfos(logicalFilesWithPayments)) {
                        this.printStatusTransactionInfoTable(doc, logicalFilesWithPayments, statusCodeContext, externalReportType, rejectedOrder);
                    }
                    for (Map.Entry<String, List<RejectedSEPAPayment>> entry : this.getStatusCodePaymentsMap(logicalFiles).entrySet()) {
                        String statusCode = (String)entry.getKey();
                        if (statusCode.equals("RCVC")) continue;
                        this.printPaymentsTable(doc, externalReportType, hasRejectionCodesOnGroupLevel, allRejectionCodes, null, statusCode, (List)entry.getValue());
                        if (hasRejectionCodesOnGroupLevel || allRejectionCodes.isEmpty()) continue;
                        this.printRejectionCodeTable(doc, allRejectionCodes);
                        allRejectionCodes.clear();
                    }
                }
            } else if (isVopReport) {
                statusCodeContext = this.getStatusCodeContext(rejectedOrder.getOrderType(), externalReportType);
                if (this.hasStatusTransactionInfos(logicalFiles)) {
                    this.printStatusTransactionInfoTable(doc, logicalFiles, statusCodeContext, externalReportType, rejectedOrder);
                }
            }
            if (logicalFilesWithoutPayments.size() > 0) {
                if (hasRejectionCodesOnGroupLevel) {
                    Map.Entry<String, List<RejectedSEPAPayment>> entry;
                    String s = this.getLogicalFileTableHeadline(hasRejectionCodesOnGroupLevel);
                    doc.addHeadline(s, BLFont.FONT_NORMAL, Alignment.ALIGN_CENTER, 20.0f);
                    BLTable<?> t = this.createLogicalFileTable(hasRejectionCodesOnGroupLevel, externalReportType);
                    entry = logicalFilesWithoutPayments.iterator();
                    while (entry.hasNext()) {
                        RejectedSEPALogicalFile logicalFile = (RejectedSEPALogicalFile)entry.next();
                        this.addRejectedLogicalFile(t, logicalFile, allRejectionCodes, hasRejectionCodesOnGroupLevel, externalReportType);
                    }
                    if (t != null) {
                        doc.addTable(t);
                    }
                } else {
                    for (RejectedSEPALogicalFile logicalFile : logicalFilesWithoutPayments) {
                        if (logicalFile.getStatusCode().equals("RCVC")) continue;
                        String s = this.getLogicalFileTableHeadline(logicalFile, externalReportType);
                        doc.addHeadline(s, BLFont.FONT_NORMAL, Alignment.ALIGN_CENTER, 20.0f);
                        BLTable<?> t = this.createLogicalFileTable(false, externalReportType);
                        this.addRejectedLogicalFile(t, logicalFile, allRejectionCodes, externalReportType);
                        doc.addTable(t);
                    }
                }
            }
            if (hasRejectionCodesOnGroupLevel || allRejectionCodes.isEmpty()) continue;
            this.printRejectionCodeTable(doc, allRejectionCodes);
        }
    }

    private Map<String, List<RejectedSEPAPayment>> getStatusCodePaymentsMap(List<RejectedSEPALogicalFile> logicalFiles) {
        LinkedHashMap<String, List<RejectedSEPAPayment>> toReturn = new LinkedHashMap<String, List<RejectedSEPAPayment>>();
        for (RejectedSEPALogicalFile logicalFile : logicalFiles) {
            for (String statusCode : logicalFile.getStatusCodePaymentsMap().keySet()) {
                List payments = toReturn.getOrDefault(statusCode, new ArrayList());
                payments.addAll((Collection)logicalFile.getStatusCodePaymentsMap().get(statusCode));
                toReturn.put(statusCode, payments);
            }
        }
        return toReturn;
    }

    private boolean hasStatusTransactionInfos(List<RejectedSEPALogicalFile> logicalFilesWithPayments) {
        for (RejectedSEPALogicalFile logicalFile : logicalFilesWithPayments) {
            if (logicalFile.getStatusTransactionInfos().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private void printStatusTransactionInfoTable(BLDocument doc, RejectedSEPALogicalFile logicalFile, StatusCode.StatusCodeContext statusCodeContext, ReportType externalReportType) throws PDFException {
        doc.addHeadline(MessageFormat.format(this.messages.getString("StatusReport.logicalFile.stateOverview"), logicalFile.getLogicalFileId()), BLFont.FONT_NORMAL, Alignment.ALIGN_CENTER, 20.0f);
        BLTable<?> rejectedTable = this.getStatusTransactionInfoTable(logicalFile, statusCodeContext, externalReportType);
        if (rejectedTable != null) {
            doc.addTable(rejectedTable);
        }
    }

    private void printStatusTransactionInfoTable(BLDocument doc, List<RejectedSEPALogicalFile> logicalFiles, StatusCode.StatusCodeContext statusCodeContext, ReportType externalReportType, RejectedSEPAOrder rejectedOrder) throws PDFException {
        doc.addHeadline(this.messages.getString("StatusReport.vop.stateOverview"), BLFont.FONT_NORMAL, Alignment.ALIGN_CENTER, 20.0f);
        BLTable<?> rejectedTable = this.getStatusTransactionInfoTable(logicalFiles, statusCodeContext, externalReportType, rejectedOrder);
        if (rejectedTable != null) {
            doc.addTable(rejectedTable);
        }
    }

    private void printRejectionCodeTable(BLDocument doc, Set<String> allRejectionCodes) throws PDFException {
        doc.addHeadline(this.messages.getString("GeneralTexts.descriptionReasonCodes"), BLFont.FONT_NORMAL, Alignment.ALIGN_CENTER, 20.0f);
        BLTable<?> rejectedTable = this.getRejectionCodeTable(allRejectionCodes);
        if (rejectedTable != null) {
            doc.addTable(rejectedTable);
        }
    }

    private void printPaymentsTable(BLDocument doc, ReportType reportType, boolean hasRejectionCodesOnGroupLevel, Set<String> allRejectionCodes, String logicalFileId, String statusCode, List<RejectedSEPAPayment> payments) throws PDFException {
        String headline = this.getHeadline(reportType, hasRejectionCodesOnGroupLevel, logicalFileId, statusCode, payments);
        doc.addHeadline(headline, BLFont.FONT_NORMAL, Alignment.ALIGN_CENTER, 20.0f);
        BLTable<?> t = this.createPaymentTable(reportType, !hasRejectionCodesOnGroupLevel && this.hasReasons(statusCode), statusCode.equals("RVMC"));
        HashSet<CallSite> addedRecipients = new HashSet<CallSite>();
        boolean hasReasons = this.hasReasons(statusCode);
        for (RejectedSEPAPayment rejectedPayment : payments) {
            if (ReportType.VOP.equals((Object)reportType) && !addedRecipients.add((CallSite)((Object)(rejectedPayment.getPayment().getRecipient() + this.getRecipientAccount(rejectedPayment.getPayment()) + (hasReasons ? StatusReportGenerator.getStatusReasonInfo(rejectedPayment.getStatusReasons(), allRejectionCodes) : ""))))) continue;
            this.addRejectedPayment(t, rejectedPayment, allRejectionCodes, hasReasons, reportType);
        }
        if (t != null) {
            doc.addTable(t);
        }
    }

    private String getHeadline(ReportType reportType, boolean hasRejectionCodesOnGroupLevel, String logicalFileId, String statusCode, List<RejectedSEPAPayment> payments) {
        Object headline = "";
        String origName = this.getUniqueOriginatorName(payments);
        String origIBAN = this.getUniqueOriginatorIBAN(payments);
        if (origName != null && origIBAN != null) {
            String message = ReportType.DEBIT.equals((Object)reportType) ? this.messages.getString("StatusReport.logicalFile.originatorInfo.debit") : this.messages.getString("StatusReport.logicalFile.originatorInfo.credit");
            headline = " (" + MessageFormat.format(message, origName, origIBAN) + ")";
        }
        headline = statusCode != null && !"RJCT".equals(statusCode) ? this.getPaymentTableHeadline(reportType, logicalFileId, statusCode, (String)headline) : this.getRejectedPaymentTableHeadline(reportType, logicalFileId, hasRejectionCodesOnGroupLevel, (String)headline);
        return headline;
    }

    private String getUniqueOriginatorName(List<RejectedSEPAPayment> payments) {
        String toReturn = null;
        for (RejectedSEPAPayment payment : payments) {
            String s = payment.getPayment().getOriginator();
            if (s == null || s.trim().length() <= 0) continue;
            if (toReturn != null) {
                if (toReturn.equals(s)) continue;
                return null;
            }
            toReturn = s;
        }
        return toReturn;
    }

    private String getUniqueOriginatorIBAN(List<RejectedSEPAPayment> payments) {
        String toReturn = null;
        for (RejectedSEPAPayment payment : payments) {
            String s = payment.getPayment().getOriginatorIban();
            if (s == null || s.trim().length() <= 0) continue;
            if (toReturn != null) {
                if (toReturn.equals(s)) continue;
                return null;
            }
            toReturn = s;
        }
        return toReturn;
    }

    private String getUniqueTransactionStatusCode(List<RejectedSEPAPayment> payments) {
        String uniqueTransactionStatusCode = null;
        for (RejectedSEPAPayment payment : payments) {
            String transactionStatusCode = payment.getStatusCode();
            if (transactionStatusCode != null && transactionStatusCode.trim().length() > 0) {
                if (uniqueTransactionStatusCode != null) {
                    if (uniqueTransactionStatusCode.equals(transactionStatusCode)) continue;
                    return null;
                }
                uniqueTransactionStatusCode = transactionStatusCode.trim();
                continue;
            }
            return null;
        }
        return uniqueTransactionStatusCode;
    }

    private String getTitle(RejectedSEPAOrder rejectedOrder, ReportType externalReportType, String bankname) {
        String orderInfo = this.getOrderInfo(rejectedOrder);
        if (ReportType.DEBIT.equals((Object)externalReportType)) {
            return MessageFormat.format(this.messages.getString("StatusReport.title.debitOrder"), orderInfo, bankname);
        }
        if (ReportType.INST.equals((Object)externalReportType)) {
            return MessageFormat.format(this.messages.getString("StatusReport.title.instantPaymentOrder"), orderInfo, bankname);
        }
        if (ReportType.FOREIGN.equals((Object)externalReportType)) {
            return MessageFormat.format(this.messages.getString("StatusReport.title.foreignPaymentOrder"), orderInfo, bankname);
        }
        if (ReportType.VOP.equals((Object)externalReportType)) {
            String orderType = this.getOriginalOrderType(rejectedOrder);
            return MessageFormat.format(this.messages.getString("StatusReport.title.vopOrder"), orderType, orderInfo, bankname);
        }
        return MessageFormat.format(this.messages.getString("StatusReport.title.creditOrder"), orderInfo, bankname);
    }

    private String getOriginalOrderType(RejectedSEPAOrder rejectedOrder) {
        String orderType = rejectedOrder.getOrderType() != null && (rejectedOrder.getOrderType().equals("CIV") || rejectedOrder.getOrderType().equals(BTFTranslator.getBTFFromSendOrderType("CIV"))) ? this.messages.getString("GeneralTexts.instantPaymentOrder") : this.messages.getString("GeneralTexts.creditOrder");
        return orderType;
    }

    private String getOrderInfo(RejectedSEPAOrder rejectedOrder) {
        String orderNumber = rejectedOrder.getOrderNumber();
        if (orderNumber == null) {
            return "";
        }
        return orderNumber;
    }

    private String getOrderStateDescription(RejectedSEPAOrder rejectedOrder, ReportType externalReportType) {
        String groupStatusCode = rejectedOrder.getStatusCode();
        String orderType = rejectedOrder.getOrderType();
        StatusCode.StatusCodeContext statusCodeContext = this.getStatusCodeContext(orderType, externalReportType);
        StatusCode.StatusCodeLevel statusCodelevel = StatusCode.StatusCodeLevel.Group;
        return MessageFormat.format(this.messages.getString("StatusReport.description.orderState"), groupStatusCode, StatusCode.getLongDescription(groupStatusCode, statusCodeContext, statusCodelevel, this.locale));
    }

    private BLTable<?> getOrderDataTable(RejectedSEPAOrder rejectedOrder, String bankname) throws PDFException {
        String orderType = rejectedOrder.getOrderType();
        String orderNumber = rejectedOrder.getOrderNumber();
        BLTable<?> t = PDFCreator.getInstance().createTable(2);
        t.setWidths(new int[]{1, 3});
        t.setSpacingBefore(20.0f);
        t.setSpacingAfter(20.0f);
        t.setPadding(3.0f);
        t.setBorder(BLBorder.NO_BORDER);
        t.setHorizontalAlignment(Alignment.ALIGN_LEFT);
        t.addCell(this.messages.getString("GeneralTexts.bank"));
        t.addCell(bankname);
        if (orderType != null) {
            t.addCell(this.messages.getString("GeneralTexts.orderType"));
            t.addCell(orderType);
        }
        if (orderNumber != null) {
            t.addCell(this.messages.getString("GeneralTexts.orderNumber"));
            t.addCell(orderNumber);
        }
        t.addCell(this.messages.getString("GeneralTexts.messageId"));
        t.addCell(rejectedOrder.getOriginalMessageId());
        if (rejectedOrder.getCountTransactions() > 0) {
            t.addCell(this.messages.getString("GeneralTexts.countPayments"));
            t.addCell(String.valueOf(rejectedOrder.getCountTransactions()));
        }
        if (rejectedOrder.getTotalAmount() != null) {
            t.addCell(this.messages.getString("GeneralTexts.totalAmount"));
            t.addCell(PaymentUtils.formatAmount(rejectedOrder.getTotalAmount(), rejectedOrder.getCurrency(), this.locale));
        }
        return t;
    }

    private String getReportCreationInfo(Date creationDate, String bankname) {
        return MessageFormat.format(this.messages.getString("StatusReport.description.reportCreationInfo"), DateFormat.getDateInstance().format(creationDate), DateFormat.getTimeInstance().format(creationDate), bankname);
    }

    private BLTable<?> createLogicalFileTable(boolean isRejectedOnGroupLevel, ReportType externalReportType) throws PDFException {
        int columns = ReportType.VOP.equals((Object)externalReportType) ? 2 : 3;
        columns = isRejectedOnGroupLevel ? columns : columns + 1;
        BLTable<?> t = PDFCreator.getInstance().createTable(columns);
        t.setSpacingBefore(20.0f);
        t.setSpacingAfter(20.0f);
        t.setWidth(96.0f);
        if (!isRejectedOnGroupLevel) {
            if (columns == 3) {
                t.setWidths(new int[]{20, 20, 40});
            } else {
                t.setWidths(new int[]{20, 20, 20, 40});
            }
        }
        t.setPadding(3.0f);
        t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
        t.addCell(this.messages.getString("GeneralTexts.collectiveReference"));
        t.addCell(this.messages.getString("GeneralTexts.countPayments"));
        if (!ReportType.VOP.equals((Object)externalReportType)) {
            t.addCell(this.messages.getString("GeneralTexts.totalAmount"));
        }
        if (!isRejectedOnGroupLevel) {
            t.addCell(this.messages.getString("GeneralTexts.reasonCodes"));
        }
        t.setHeaderRows(1);
        return t;
    }

    private String getLogicalFileTableHeadline(RejectedSEPALogicalFile logicalFile, ReportType externalReportType) {
        String logicalFileStatusCode = logicalFile.getStatusCode();
        StatusCode.StatusCodeContext context = ReportType.INST.equals((Object)externalReportType) ? StatusCode.StatusCodeContext.SCT_INST : StatusCode.StatusCodeContext.SEPA;
        String messageKey = ReportType.DEBIT.equals((Object)externalReportType) ? this.messages.getString("StatusReport.description.collectiveDebitState") : this.messages.getString("StatusReport.description.collectiveTransferState");
        return MessageFormat.format(messageKey, logicalFileStatusCode, StatusCode.getLongDescription(logicalFileStatusCode, context, StatusCode.StatusCodeLevel.LogicalFile, this.locale));
    }

    private String getLogicalFileTableHeadline(boolean isRejectedOnGroupLevel) {
        if (isRejectedOnGroupLevel) {
            return this.messages.getString("StatusReport.order.containsLogicalFiles");
        }
        return this.messages.getString("StatusReport.order.rejectedLogicalFiles");
    }

    private void addRejectedLogicalFile(BLTable<?> t, RejectedSEPALogicalFile logicalFile, Set<String> allStatusReasonCodes, boolean isRejectedOnGroupLevel, ReportType externalReportType) throws PDFException {
        t.addCell(logicalFile.getLogicalFileId());
        int countTransactions = logicalFile.getCountTransactions();
        String s = countTransactions > 0 ? String.valueOf(countTransactions) : "";
        t.addCell(s);
        if (!ReportType.VOP.equals((Object)externalReportType)) {
            t.addCell(PaymentUtils.formatAmount(logicalFile.getTotalAmount(), logicalFile.getCurrency(), this.locale));
        }
        if (!isRejectedOnGroupLevel) {
            t.addCell(StatusReportGenerator.getStatusReasonInfo(logicalFile.getStatusReasons(), allStatusReasonCodes));
        }
    }

    private void addRejectedLogicalFile(BLTable<?> t, RejectedSEPALogicalFile logicalFile, Set<String> allStatusReasonCodes, ReportType externalReportType) throws PDFException {
        t.addCell(logicalFile.getLogicalFileId());
        int countTransactions = logicalFile.getCountTransactions();
        String s = countTransactions > 0 ? String.valueOf(countTransactions) : "";
        t.addCell(s);
        if (!ReportType.VOP.equals((Object)externalReportType)) {
            t.addCell(PaymentUtils.formatAmount(logicalFile.getTotalAmount(), logicalFile.getCurrency(), this.locale));
        }
        t.addCell(StatusReportGenerator.getStatusReasonInfo(logicalFile.getStatusReasons(), allStatusReasonCodes));
    }

    private static String getStatusReasonInfo(List<StatusReason> statusReasons, Set<String> allStatusReasonCodes) {
        if (statusReasons == null || statusReasons.size() == 0) {
            return "";
        }
        boolean isFirstReason = true;
        StringBuilder sb = new StringBuilder();
        for (StatusReason statusReason : statusReasons) {
            String statusReasonCode = statusReason.getStatusReasonCode();
            String additionalInfo = StringUtils.getStringFromStringList(statusReason.getAdditionalInfos(), "\n");
            if (statusReasonCode != null) {
                if (!isFirstReason) {
                    sb.append("\n");
                }
                sb.append(statusReasonCode);
                allStatusReasonCodes.add(statusReasonCode);
                if (additionalInfo.length() > 0) {
                    sb.append("\n(");
                    sb.append(additionalInfo);
                    sb.append(")");
                }
            } else {
                if (!isFirstReason) {
                    sb.append("\n");
                }
                if (additionalInfo.length() > 0) {
                    sb.append(additionalInfo);
                }
            }
            isFirstReason = false;
        }
        return sb.toString();
    }

    private BLTable<?> createPaymentTable(ReportType reportType, boolean hasReasons, boolean isVopCloseMatch) throws PDFException {
        int columns = ReportType.VOP.equals((Object)reportType) ? 2 : 5;
        columns = hasReasons ? columns + 1 : columns;
        BLTable<?> t = PDFCreator.getInstance().createTable(columns);
        t.setWidth(ReportType.VOP.equals((Object)reportType) ? 60.0f : 96.0f);
        t.setPadding(3.0f);
        t.setSpacingBefore(20.0f);
        t.setSpacingAfter(20.0f);
        t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
        t.addCell(ReportType.DEBIT.equals((Object)reportType) ? this.messages.getString("GeneralTexts.payer") : this.messages.getString("GeneralTexts.recipient"));
        t.addCell(this.messages.getString("GeneralTexts.account"));
        if (!ReportType.VOP.equals((Object)reportType)) {
            t.addCell(this.messages.getString("GeneralTexts.amount"), Alignment.ALIGN_RIGHT, null);
            t.addCell(this.messages.getString("GeneralTexts.purpose"));
            t.addCell(this.messages.getString("GeneralTexts.reference"));
        }
        if (hasReasons) {
            if (columns >= 6) {
                t.setWidths(new int[]{20, 15, 15, 20, 15, 15});
            }
            t.addCell(isVopCloseMatch ? this.messages.getString("GeneralTexts.actualName") : this.messages.getString("GeneralTexts.reasonCodes"));
        }
        t.setHeaderRows(1);
        return t;
    }

    private String getRejectedPaymentTableHeadline(ReportType reportType, String logicalFileId, boolean isRejectedOnGroupLevel, String head) {
        if (isRejectedOnGroupLevel) {
            String msg = ReportType.DEBIT.equals((Object)reportType) ? this.messages.getString("StatusReport.order.containsDebits") : (ReportType.INST.equals((Object)reportType) ? this.messages.getString("StatusReport.order.containsInstantPayments") : this.messages.getString("StatusReport.order.containsCredits"));
            return MessageFormat.format(msg, head);
        }
        if (logicalFileId == null || logicalFileId.trim().length() == 0) {
            String msg = ReportType.DEBIT.equals((Object)reportType) ? this.messages.getString("StatusReport.order.rejectedDebits") : (ReportType.INST.equals((Object)reportType) ? this.messages.getString("StatusReport.order.rejectedInstantPayments") : this.messages.getString("StatusReport.order.rejectedCredits"));
            return MessageFormat.format(msg, head);
        }
        String messageKey = ReportType.DEBIT.equals((Object)reportType) ? this.messages.getString("StatusReport.logicalFile.rejectedDebits") : (ReportType.INST.equals((Object)reportType) ? this.messages.getString("StatusReport.logicalFile.rejectedInstantPayments") : this.messages.getString("StatusReport.logicalFile.rejectedCredits"));
        return MessageFormat.format(messageKey, logicalFileId, head);
    }

    private String getPaymentTableHeadline(ReportType reportType, String logicalFileId, String commonStatusCode, String head) {
        String messageKey = ReportType.DEBIT.equals((Object)reportType) ? this.messages.getString("StatusReport.logicalFile.stateDebits") : (ReportType.INST.equals((Object)reportType) ? this.messages.getString("StatusReport.logicalFile.stateInstantPayments") : (ReportType.VOP.equals((Object)reportType) ? this.messages.getString("StatusReport.vop.stateRecipients") : this.messages.getString("StatusReport.logicalFile.stateCredits")));
        String statusCodeDescription = ReportType.VOP == reportType ? StatusCode.getSimpleDescription(commonStatusCode, ReportType.INST.equals((Object)reportType) ? StatusCode.StatusCodeContext.SCT_INST : StatusCode.StatusCodeContext.SEPA, StatusCode.StatusCodeLevel.LogicalFile, this.locale) : StatusCode.getLongDescription(commonStatusCode, ReportType.INST.equals((Object)reportType) ? StatusCode.StatusCodeContext.SCT_INST : StatusCode.StatusCodeContext.SEPA, StatusCode.StatusCodeLevel.LogicalFile, this.locale);
        return MessageFormat.format(messageKey, logicalFileId, commonStatusCode, statusCodeDescription, head);
    }

    private void addRejectedPayment(BLTable<?> t, RejectedSEPAPayment rejectedPayment, Set<String> allStatusReasonCodes, boolean hasReasons, ReportType reportType) throws PDFException {
        SEPAPaymentData p = rejectedPayment.getPayment();
        t.addCell(p.getRecipient());
        t.addCell(this.getRecipientAccount(p));
        if (!ReportType.VOP.equals((Object)reportType)) {
            t.addCell(PaymentUtils.formatAmount(p.getAmount(), p.getCurrency(), this.locale), Alignment.ALIGN_RIGHT, null);
            t.addCell(p.getPurpose());
            t.addCell(p.getEndToEndId());
        }
        if (hasReasons) {
            t.addCell(StatusReportGenerator.getStatusReasonInfo(rejectedPayment.getStatusReasons(), allStatusReasonCodes));
        }
    }

    private String getRecipientAccount(SEPAPaymentData p) {
        StringBuilder recipientAccount = new StringBuilder();
        String recipientBic = p.getRecipientBic();
        if (recipientBic != null && recipientBic.trim().length() > 0) {
            recipientAccount.append(recipientBic.trim());
            recipientAccount.append('/');
        }
        recipientAccount.append(p.getRecipientIban());
        return recipientAccount.toString();
    }

    private BLTable<?> getStatusTransactionInfoTable(RejectedSEPALogicalFile logicalFile, StatusCode.StatusCodeContext statusCodeContext, ReportType reportType) throws PDFException {
        ArrayList<RejectedSEPALogicalFile> logicalFiles = new ArrayList<RejectedSEPALogicalFile>();
        logicalFiles.add(logicalFile);
        return this.getStatusTransactionInfoTable(logicalFiles, statusCodeContext, reportType, null);
    }

    private BLTable<?> getStatusTransactionInfoTable(List<RejectedSEPALogicalFile> logicalFiles, StatusCode.StatusCodeContext statusCodeContext, ReportType reportType, RejectedSEPAOrder rejectedOrder) throws PDFException {
        int width = ReportType.VOP.equals((Object)reportType) ? 80 : 60;
        BLTable<?> t = PDFCreator.getInstance().createTable(3, Alignment.ALIGN_CENTER);
        t.setWidth(width);
        if (!ReportType.VOP.equals((Object)reportType)) {
            t.setWidths(new int[]{40, 30, 30});
        } else {
            t.setWidths(new int[]{40, 30, 80});
        }
        t.setSpacingBefore(20.0f);
        t.setSpacingAfter(20.0f);
        t.setPadding(3.0f);
        t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
        t.addCell(this.messages.getString(ReportType.VOP.equals((Object)reportType) ? "GeneralTexts.result" : "GeneralTexts.state"));
        t.addCell(this.messages.getString("GeneralTexts.countPayments"), Alignment.ALIGN_RIGHT, null);
        if (ReportType.VOP.equals((Object)reportType)) {
            t.addCell(this.messages.getString("StatusReport.vop.recommendedMeasures"), Alignment.ALIGN_LEFT, null);
        } else {
            t.addCell(this.messages.getString("GeneralTexts.sum"), Alignment.ALIGN_RIGHT, null);
        }
        t.setHeaderRows(1);
        for (StatusTransactionInfo statusTransactionInfo : this.getStatusTransactionInfos(logicalFiles, reportType, rejectedOrder)) {
            String statusCode = statusTransactionInfo.getStatusCode();
            String description = StatusCode.getShortDescription(statusCode, statusCodeContext, StatusCode.StatusCodeLevel.Transaction, this.locale);
            if (description != null && !description.equals(statusCode)) {
                t.addCell(description + " (" + statusCode + ")", BLFont.FONT_NORMAL);
            } else {
                t.addCell(statusCode, BLFont.FONT_NORMAL);
            }
            t.addCell(NumberFormat.getInstance(this.locale).format(statusTransactionInfo.getCountTransactions()), BLFont.FONT_NORMAL, Alignment.ALIGN_RIGHT, null);
            if (reportType != ReportType.VOP && logicalFiles.size() == 1) {
                RejectedSEPALogicalFile logicalFile = logicalFiles.get(0);
                boolean calculatedSum = false;
                BigDecimal sum = statusTransactionInfo.getTotalAmount();
                if (sum == null) {
                    sum = logicalFile.getTotalAmount(statusCode);
                    calculatedSum = true;
                }
                if (sum != null) {
                    Currency c = statusTransactionInfo.getCurrency();
                    if (c == null) {
                        c = logicalFile.getCurrency(statusCode);
                    }
                    if (c != null) {
                        t.addCell(PaymentUtils.formatAmount(sum, c, this.locale), BLFont.FONT_NORMAL, Alignment.ALIGN_RIGHT, null);
                        continue;
                    }
                    t.addCell(PaymentUtils.formatAmount(sum, null, 2, this.locale), BLFont.FONT_NORMAL, Alignment.ALIGN_RIGHT, null);
                    continue;
                }
                t.addCell("", BLFont.FONT_NORMAL);
                continue;
            }
            if (reportType != ReportType.VOP) {
                t.addCell("", BLFont.FONT_NORMAL);
                continue;
            }
            t.addCell(rejectedOrder.getVopLegalInfo(statusCode), BLFont.FONT_NORMAL, Alignment.ALIGN_LEFT, null);
        }
        return t;
    }

    private List<StatusTransactionInfo> getStatusTransactionInfos(List<RejectedSEPALogicalFile> logicalFiles, ReportType reportType, RejectedSEPAOrder rejectedOrder) {
        if (ReportType.VOP == reportType) {
            return rejectedOrder.getGroupStatusTransactionInfos();
        }
        ArrayList<StatusTransactionInfo> toReturn = new ArrayList<StatusTransactionInfo>();
        for (RejectedSEPALogicalFile logicalFile : logicalFiles) {
            for (StatusTransactionInfo info : logicalFile.getStatusTransactionInfos()) {
                if (toReturn.contains(info)) continue;
                toReturn.add(info);
            }
        }
        return toReturn;
    }

    private BLTable<?> getRejectionCodeTable(Collection<String> rejectionCodes) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(2, Alignment.ALIGN_CENTER);
        t.setWidth(60.0f);
        t.setWidths(new int[]{20, 80});
        t.setSpacingBefore(20.0f);
        t.setSpacingAfter(20.0f);
        t.setPadding(3.0f);
        t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
        t.addCell(this.messages.getString("GeneralTexts.reasonCode"));
        t.addCell(this.messages.getString("GeneralTexts.description"));
        t.setHeaderRows(1);
        for (String code : rejectionCodes) {
            t.addCell(code, BLFont.FONT_NORMAL);
            t.addCell(RejectedSEPAOrder.getDescription(code, this.locale));
        }
        return t;
    }

    private boolean addReasonCodeTable(BLDocument doc, List<StatusReason> statusReasons, String groupStatusCode) throws PDFException {
        int countStatusReasons;
        int n = countStatusReasons = statusReasons != null ? statusReasons.size() : 0;
        if (countStatusReasons > 0 && "RJCT".equals(groupStatusCode)) {
            String messageKey = countStatusReasons == 1 ? "StatusReport.description.orderRejectionReason" : "StatusReport.description.orderRejectionReasons";
            doc.addTextln(this.messages.getString(messageKey));
            BLTable<?> rejectionCodeTable = this.getRejectionCodeTableWithAddtlInfo(statusReasons);
            if (rejectionCodeTable != null) {
                doc.addTable(rejectionCodeTable);
            }
            return true;
        }
        return false;
    }

    private BLTable<?> getRejectionCodeTableWithAddtlInfo(Collection<StatusReason> statusReasons) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(2, Alignment.ALIGN_CENTER);
        t.setWidth(60.0f);
        t.setWidths(new int[]{20, 80});
        t.setSpacingBefore(20.0f);
        t.setSpacingAfter(20.0f);
        t.setPadding(3.0f);
        t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
        t.addCell(this.messages.getString("GeneralTexts.reasonCode"));
        t.addCell(this.messages.getString("GeneralTexts.description"));
        t.setHeaderRows(1);
        for (StatusReason statusReason : statusReasons) {
            String additionalInfo;
            String description;
            StringBuilder sb = new StringBuilder();
            String code = statusReason.getStatusReasonCode();
            if (code != null && (description = RejectedSEPAOrder.getDescription(code, this.locale)) != null && !code.equals(description)) {
                sb.append(description);
            }
            if ((additionalInfo = StringUtils.getStringFromStringList(statusReason.getAdditionalInfos(), ", ")).length() > 0) {
                if (sb.length() > 0) {
                    sb.append("\n(");
                    sb.append(additionalInfo);
                    sb.append(")");
                } else {
                    sb.append(additionalInfo);
                }
            }
            t.addCell(code != null ? code : "", BLFont.FONT_NORMAL);
            t.addCell(sb.toString());
        }
        return t;
    }

    public BLDocument.PageLayout getPageSize() {
        List<RejectedSEPALogicalFile> logicalFiles;
        if (this.rejectedOrders != null && this.rejectedOrders.size() > 0 && (logicalFiles = this.rejectedOrders.get(0).getRejectedLogicalFiles()) != null && logicalFiles.size() > 0) {
            return BLDocument.PageLayout.A4_LANDSCAPE;
        }
        return BLDocument.PageLayout.A4;
    }

    private boolean hasReasons(String statusCode) {
        return !statusCode.equals("RVNM") && !statusCode.equals("RCVC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        block30: {
            if (args.length < 2) {
                System.out.println("Usage as a command line:");
                System.out.println("java -jar sepaconverter.jar CRJ|CRZ|CDR|CDZ|CIR|CIZ <in-file> <out-file> [bankname]");
                System.out.println("or");
                System.out.println("java -jar sepaconverter.jar CRJ|CRZ|CDR|CDZ|CIR|CIZ <in-file> [out-dir [bankname]]");
                System.out.println();
                System.out.println("If out-dir is given, all files from CRZ, CIZ and CDZ are converted into a single PDF");
                System.out.println("files stored with the same file as used in the input-zip-file. If out-dir is not");
                System.out.println("given, the current directory is used.");
                System.out.println();
                System.out.println("CRJ/CRZ or CDR/CDZ or CIR/CIZ define the title of the PDF (credit/debit/instant credit).");
                System.out.println();
                System.out.println("The optional bankname is printed in the title of the PDF.");
                System.out.println("If missing, we use the input-filename as bankname");
                System.exit(-1);
            }
            reportOrderType = args[0];
            reportType = StatusReportGenerator.getReportType(reportOrderType);
            g = null;
            in = new File(args[1]);
            zip = null;
            entry = null;
            toClose = null;
            try {
                if ("CRZ".equals(reportOrderType) || "CDZ".equals(reportOrderType) || "CIZ".equals(reportOrderType)) {
                    zip = new ZipInputStream(new FileInputStream(args[1]));
                    entry = zip.getNextEntry();
                    try {
                        if (entry == null) ** GOTO lbl41
                        g = new StatusReportGenerator(GeneralSEPAReportExtractor.getRejectedOrders(new NoCloseInputStream(zip)), Locale.getDefault());
                    }
                    finally {
                        zip.closeEntry();
                    }
                } else {
                    inputstream = new FileInputStream(in);
                    try {
                        g = new StatusReportGenerator(GeneralSEPAReportExtractor.getRejectedOrders(inputstream), Locale.getDefault());
                    }
                    finally {
                        inputstream.close();
                    }
                }
                outDir = new File(".");
                outFile = null;
                if (args.length > 2) {
                    outDir = new File(args[2]);
                }
                if (!outDir.isDirectory()) {
                    outFile = outDir;
                    outDir = null;
                } else if (zip == null) {
                    System.out.println("out-dir can only be given by CRZ or CDZ!");
                    System.exit(-2);
                } else {
                    outFile = new File(outDir, new File(entry.getName()).getName() + ".pdf");
                }
                document = PDFCreator.getInstance().createDocument(g.getPageSize());
                document.addMetaInformation("SEPA StatusReport", "Business-Logics GmbH", "SEPA StatusReport Generator");
                toClose = new FileOutputStream(outFile);
                document.open(toClose);
                bankname = in.getName();
                if (args.length > 3) {
                    bankname = args[3];
                }
                g.addToDocument(reportType, bankname, document);
                if (zip != null) {
                    entry = zip.getNextEntry();
                    while (entry != null) {
                        if (outDir != null) {
                            document.close();
                            if (toClose != null) {
                                toClose.close();
                                toClose = null;
                            }
                            outFile = new File(outDir, new File(entry.getName()).getName() + ".pdf");
                            document = PDFCreator.getInstance().createDocument(g.getPageSize());
                            document.addMetaInformation("SEPA StatusReport", "Business-Logics GmbH", "SEPA StatusReport Generator");
                            toClose = new FileOutputStream(outFile);
                            document.open(toClose);
                        }
                        try {
                            g.rejectedOrders = GeneralSEPAReportExtractor.getRejectedOrders(new NoCloseInputStream(zip));
                        }
                        finally {
                            zip.closeEntry();
                        }
                        g.addToDocument(reportType, bankname, document);
                        entry = zip.getNextEntry();
                    }
                    zip.close();
                    zip = null;
                }
                document.close();
                if (toClose == null) break block30;
                toClose.close();
                toClose = null;
            }
            catch (Throwable var13_16) {
                SystemUtils.close(toClose);
                if (zip != null) {
                    zip.close();
                }
                throw var13_16;
            }
        }
        SystemUtils.close(toClose);
        if (zip != null) {
            zip.close();
        }
    }

    public static enum ReportType {
        CREDIT,
        DEBIT,
        INST,
        FOREIGN,
        VOP;

    }
}

