/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.pdf;

import de.businesslogics.format.camt029.Camt029LogicalFile;
import de.businesslogics.format.camt029.Camt029LogicalFileReasonCode;
import de.businesslogics.format.camt029.Camt029Notification;
import de.businesslogics.format.camt029.Camt029StatusCode;
import de.businesslogics.format.camt029.Camt029Transaction;
import de.businesslogics.format.camt029.Camt029TransactionReasonCode;
import de.businesslogics.format.sepa.OrderData;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.StatusReason;
import de.businesslogics.format.sepa.pdf.Messages;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class Camt029ReportGenerator {
    private static final float SPACING = 20.0f;
    private final Camt029Notification notification;
    private final OrderData orderData;
    private final Locale locale;
    private final Messages messages;

    public Camt029ReportGenerator(Camt029Notification notification, OrderData orderData, Locale locale) {
        this.notification = notification;
        this.orderData = orderData;
        this.locale = locale;
        this.messages = new Messages(locale);
    }

    public void addToDocument(String bankname, BLDocument doc) throws Exception {
        List<Camt029Transaction> transactions;
        doc.addHeadline(this.getTitle(bankname, this.orderData), BLFont.FONT_BIG_BOLD, Alignment.ALIGN_CENTER, 20.0f);
        BLTable<?> headerTable = this.getHeaderTable(this.notification);
        doc.addTable(headerTable);
        String status = this.notification.getStatus();
        List<Camt029LogicalFile> logicalFiles = this.notification.getLogicalFiles();
        if (logicalFiles != null && logicalFiles.size() > 0) {
            int countLogicalFiles = logicalFiles.size();
            if (countLogicalFiles == 1) {
                Camt029LogicalFile logicalFile = logicalFiles.get(0);
                StringBuilder sb = new StringBuilder();
                if (Camt029StatusCode.CNCL.name().equals(status)) {
                    sb.append(MessageFormat.format(this.messages.getString("Camt029Report.logicalFile.success"), logicalFile.getPmtInfId()));
                } else if (Camt029StatusCode.RJCR.name().equals(status)) {
                    sb.append(MessageFormat.format(this.messages.getString("Camt029Report.logicalFile.rejected"), logicalFile.getPmtInfId()));
                } else if (Camt029StatusCode.PDCR.name().equals(status)) {
                    sb.append(MessageFormat.format(this.messages.getString("Camt029Report.logicalFile.PDCR"), logicalFile.getPmtInfId()));
                } else if (Camt029StatusCode.UWFW.name().equals(status)) {
                    sb.append(MessageFormat.format(this.messages.getString("Camt029Report.logicalFile.UWFW"), logicalFile.getPmtInfId()));
                } else if (Camt029StatusCode.CWFW.name().equals(status)) {
                    sb.append(MessageFormat.format(this.messages.getString("Camt029Report.logicalFile.CWFW"), logicalFile.getPmtInfId()));
                } else {
                    sb.append(MessageFormat.format(this.messages.getString("Camt029Report.logicalFile.otherState"), logicalFile.getPmtInfId(), status));
                }
                StatusReason statusReason = logicalFile.getStatusReasonInfo();
                if (statusReason != null) {
                    sb.append("\n");
                    sb.append(MessageFormat.format(this.messages.getString("Camt029Report.reason"), Camt029LogicalFileReasonCode.getDescription(statusReason.getStatusReasonCode(), this.locale)));
                }
                doc.addTextln(sb.toString());
            } else {
                if (Camt029StatusCode.CNCL.name().equals(status)) {
                    doc.addTextln(this.messages.getString("Camt029Report.logicalFiles.success"));
                } else if (Camt029StatusCode.RJCR.name().equals(status)) {
                    doc.addTextln(this.messages.getString("Camt029Report.logicalFiles.rejected"));
                } else if (Camt029StatusCode.PDCR.name().equals(status)) {
                    doc.addTextln(this.messages.getString("Camt029Report.logicalFiles.PDCR"));
                } else if (Camt029StatusCode.UWFW.name().equals(status)) {
                    doc.addTextln(this.messages.getString("Camt029Report.logicalFiles.UWFW"));
                } else if (Camt029StatusCode.CWFW.name().equals(status)) {
                    doc.addTextln(this.messages.getString("Camt029Report.logicalFiles.CWFW"));
                } else {
                    doc.addTextln(MessageFormat.format(this.messages.getString("Camt029Report.logicalFiles.otherState"), status));
                }
                BLTable<?> table = this.createLogicalFileTable();
                for (Camt029LogicalFile logicalFile : logicalFiles) {
                    this.addLogicalFile(table, logicalFile);
                }
                doc.addTable(table);
            }
        }
        if ((transactions = this.notification.getTransactions()) != null && transactions.size() > 0) {
            boolean cancellationSuccessful = Camt029StatusCode.CNCL.name().equals(status);
            if (cancellationSuccessful) {
                doc.addTextln(this.messages.getString("Camt029Report.transactions.success"));
            } else if (Camt029StatusCode.RJCR.name().equals(status)) {
                doc.addTextln(this.messages.getString("Camt029Report.transactions.rejected"));
            } else if (Camt029StatusCode.PDCR.name().equals(status)) {
                doc.addTextln(this.messages.getString("Camt029Report.transactions.PDCR"));
            } else if (Camt029StatusCode.UWFW.name().equals(status)) {
                doc.addTextln(this.messages.getString("Camt029Report.transactions.UWFW"));
            } else if (Camt029StatusCode.CWFW.name().equals(status)) {
                doc.addTextln(this.messages.getString("Camt029Report.transactions.CWFW"));
            } else {
                doc.addTextln(MessageFormat.format(this.messages.getString("Camt029Report.transactions.otherState"), status));
            }
            boolean isDebit = this.orderData != null ? this.orderData.isDebitOrder() : false;
            BLTable<?> table = this.createTransactionTable(isDebit, cancellationSuccessful);
            ArrayList<String> reasonCodes = new ArrayList<String>();
            for (Camt029Transaction transaction : transactions) {
                this.addTransaction(table, cancellationSuccessful, transaction, reasonCodes);
            }
            doc.addTable(table);
            if (reasonCodes.size() > 0) {
                doc.addHeadline(this.messages.getString("GeneralTexts.descriptionReasonCodes"), BLFont.FONT_NORMAL, Alignment.ALIGN_CENTER, 20.0f);
                BLTable<?> rejectedTable = this.getReasonCodeTable(reasonCodes);
                if (rejectedTable != null) {
                    doc.addTable(rejectedTable);
                }
            }
        }
    }

    private String getTitle(String bankname, OrderData orderData) {
        if (orderData != null) {
            return MessageFormat.format(this.messages.getString("Camt029Report.title2"), bankname, orderData.getOrderInfo());
        }
        return MessageFormat.format(this.messages.getString("Camt029Report.title"), bankname);
    }

    private String getReason(StatusReason statusReason) {
        if (statusReason != null) {
            return StringUtils.checkNullAndTrim(statusReason.getStatusReasonCode());
        }
        return "";
    }

    public BLDocument.PageLayout getPageSize() {
        if (this.notification != null && this.notification.getTransactions().size() > 0) {
            return BLDocument.PageLayout.A4_LANDSCAPE;
        }
        return BLDocument.PageLayout.A4;
    }

    private BLTable<?> getHeaderTable(Camt029Notification notification) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(2);
        t.setWidths(new int[]{1, 3});
        t.setSpacingBefore(20.0f);
        t.setSpacingAfter(20.0f);
        t.setPadding(3.0f);
        t.setBorder(BLBorder.NO_BORDER);
        t.setHorizontalAlignment(Alignment.ALIGN_LEFT);
        t.addCell(this.messages.getString("GeneralTexts.messageId"));
        t.addCell(notification.getAssignmentId());
        if (notification.getAssigner() != null) {
            t.addCell(this.messages.getString("GeneralTexts.bank"));
            t.addCell(notification.getAssigner());
        }
        if (notification.getAssignee() != null) {
            t.addCell(this.messages.getString("GeneralTexts.customer"));
            t.addCell(notification.getAssignee());
        }
        t.addCell(this.messages.getString("GeneralTexts.creationTime"));
        Date creationDate = notification.getCreationDate();
        t.addCell(DateFormat.getDateInstance().format(creationDate) + " " + DateFormat.getTimeInstance().format(creationDate));
        return t;
    }

    private BLTable<?> createLogicalFileTable() throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(2);
        t.setSpacingBefore(20.0f);
        t.setSpacingAfter(20.0f);
        t.setWidth(96.0f);
        t.setPadding(3.0f);
        t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
        t.addCell(this.messages.getString("GeneralTexts.collectiveReference"));
        t.addCell(this.messages.getString("GeneralTexts.reasonCode"));
        t.setHeaderRows(1);
        return t;
    }

    private void addLogicalFile(BLTable<?> t, Camt029LogicalFile logicalFile) throws PDFException {
        t.addCell(logicalFile.getPmtInfId());
        t.addCell(this.getReason(logicalFile.getStatusReasonInfo()));
    }

    private BLTable<?> createTransactionTable(boolean isDebit, boolean cancellationSuccessful) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(cancellationSuccessful ? 6 : 7);
        t.setWidth(96.0f);
        t.setPadding(3.0f);
        t.setSpacingBefore(20.0f);
        t.setSpacingAfter(20.0f);
        t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
        t.addCell(isDebit ? this.messages.getString("GeneralTexts.payer") : this.messages.getString("GeneralTexts.recipient"));
        t.addCell(this.messages.getString("GeneralTexts.account"));
        t.addCell(this.messages.getString("GeneralTexts.amount"));
        t.addCell(this.messages.getString("GeneralTexts.purpose"));
        t.addCell(this.messages.getString("GeneralTexts.executionDate"));
        t.addCell(this.messages.getString("GeneralTexts.reference"));
        if (cancellationSuccessful) {
            t.setWidths(new int[]{18, 18, 15, 19, 15, 15});
        } else {
            t.addCell(this.messages.getString("GeneralTexts.reasonCode"));
            t.setWidths(new int[]{15, 15, 15, 15, 15, 15, 10});
        }
        t.setHeaderRows(1);
        return t;
    }

    private void addTransaction(BLTable<?> t, boolean cancellationSuccessful, Camt029Transaction transaction, List<String> reasonCodes) throws PDFException {
        SEPAPaymentData paymentData = transaction.getPaymentData();
        t.addCell(StringUtils.checkNullAndTrim(paymentData.getRecipient()));
        String recipientIban = StringUtils.checkNullAndTrim(paymentData.getRecipientIban());
        if (recipientIban.length() > 0) {
            String recipientBic = StringUtils.checkNullAndTrim(paymentData.getRecipientBic());
            if (recipientBic.length() > 0) {
                t.addCell(recipientBic + "/" + recipientIban);
            } else {
                t.addCell(recipientIban);
            }
        }
        t.addCell(PaymentUtils.formatAmount(paymentData.getAmount(), paymentData.getCurrency(), this.locale));
        t.addCell(StringUtils.checkNullAndTrim(paymentData.getPurpose()));
        if (paymentData.getExecutionDate() != null) {
            t.addCell(DateFormat.getDateInstance().format(paymentData.getExecutionDate()));
        } else {
            t.addCell("");
        }
        String endToEndId = StringUtils.checkNullAndTrim(paymentData.getEndToEndId());
        if (endToEndId.length() > 0) {
            t.addCell(endToEndId);
        } else {
            t.addCell(StringUtils.checkNullAndTrim(transaction.getEndToEndId()));
        }
        if (!cancellationSuccessful) {
            String reason = this.getReason(transaction.getStatusReasonInfo());
            t.addCell(reason);
            if (reason.length() > 0) {
                reasonCodes.add(reason);
            }
        }
    }

    private BLTable<?> getReasonCodeTable(Collection<String> reasonCodes) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(2, Alignment.ALIGN_CENTER);
        t.setWidth(60.0f);
        t.setWidths(new int[]{20, 80});
        t.setSpacingBefore(20.0f);
        t.setSpacingAfter(20.0f);
        t.setPadding(3.0f);
        t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
        t.addCell(this.messages.getString("GeneralTexts.reasonCode"));
        t.addCell(this.messages.getString("GeneralTexts.description"));
        t.setHeaderRows(1);
        for (String code : reasonCodes) {
            t.addCell(code, BLFont.FONT_NORMAL);
            t.addCell(Camt029TransactionReasonCode.getDescription(code, this.locale), Alignment.ALIGN_CENTER, null);
        }
        return t;
    }
}

