/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.pain00800201;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.sepa.CashAccountSDD1;
import de.businesslogics.format.sepa.PaymentMethod2Code;
import de.businesslogics.format.sepa.PaymentTypeInformationSDD;
import de.businesslogics.format.sepa.RestrictedIdentification1;
import de.businesslogics.format.sepa.pain00800201.BranchAndFinancialInstitutionIdentificationSDD1;
import de.businesslogics.format.sepa.pain00800201.ChargeBearerTypeSDDCode;
import de.businesslogics.format.sepa.pain00800201.DirectDebitTransactionInformationSDD;
import de.businesslogics.format.sepa.pain00800201.Pain00800201Listener;
import de.businesslogics.format.sepa.pain00800201.PartyIdentificationSDD1;
import de.businesslogics.format.sepa.pain00800201.PartyIdentificationSDD2;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class PaymentInstructionInformationSDD
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private RestrictedIdentification1 pmtInfId;
    private PaymentTypeInformationSDD pmtTpInf;
    private XMLDate reqdColltnDt;
    private PartyIdentificationSDD2 cdtr;
    private CashAccountSDD1 cdtrAcct;
    private BranchAndFinancialInstitutionIdentificationSDD1 cdtrAgt;
    private PartyIdentificationSDD1 ultmtCdtr;
    private ChargeBearerTypeSDDCode chrgBr;
    private List<DirectDebitTransactionInformationSDD> drctDbtTxInfs;

    private PaymentInstructionInformationSDD() {
    }

    public PaymentInstructionInformationSDD(RestrictedIdentification1 pmtInfId, PaymentTypeInformationSDD pmtTpInf, XMLDate reqdColltnDt, PartyIdentificationSDD2 cdtr, CashAccountSDD1 cdtrAcct, BranchAndFinancialInstitutionIdentificationSDD1 cdtrAgt, List<DirectDebitTransactionInformationSDD> drctDbtTxInfs) {
        this.pmtInfId = pmtInfId;
        this.pmtTpInf = pmtTpInf;
        this.reqdColltnDt = reqdColltnDt;
        this.cdtr = cdtr;
        this.cdtrAcct = cdtrAcct;
        this.cdtrAgt = cdtrAgt;
        this.drctDbtTxInfs = drctDbtTxInfs;
    }

    public XMLDate getReqdColltnDt() {
        return this.reqdColltnDt;
    }

    public PaymentTypeInformationSDD getPmtTpInf() {
        return this.pmtTpInf;
    }

    public PartyIdentificationSDD2 getCdtr() {
        return this.cdtr;
    }

    public CashAccountSDD1 getCdtrAcct() {
        return this.cdtrAcct;
    }

    public BranchAndFinancialInstitutionIdentificationSDD1 getCdtrAgt() {
        return this.cdtrAgt;
    }

    public ChargeBearerTypeSDDCode getChrgBr() {
        return this.chrgBr;
    }

    public void setChrgBr(ChargeBearerTypeSDDCode chrgBr) {
        this.chrgBr = chrgBr;
    }

    public RestrictedIdentification1 getPmtInfId() {
        return this.pmtInfId;
    }

    public void setPmtInfId(RestrictedIdentification1 pmtInfId) {
        this.pmtInfId = pmtInfId;
    }

    public List<DirectDebitTransactionInformationSDD> getDrctDbtTxInfs() {
        return this.drctDbtTxInfs;
    }

    public PartyIdentificationSDD1 getUltmtCdtr() {
        return this.ultmtCdtr;
    }

    public void setUltmtCdtr(PartyIdentificationSDD1 ultmtCdtr) {
        this.ultmtCdtr = ultmtCdtr;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.pmtInfId != null) {
            this.pmtInfId.printOut("PmtInfId", ps);
        }
        PaymentMethod2Code.DD.printOut("PmtMtd", ps);
        ps.printOut("PmtTpInf", this.pmtTpInf);
        this.reqdColltnDt.printOut("ReqdColltnDt", ps);
        this.cdtr.printOut("Cdtr", ps);
        this.cdtrAcct.printOut("CdtrAcct", ps);
        this.cdtrAgt.printOut("CdtrAgt", ps);
        if (this.ultmtCdtr != null) {
            this.ultmtCdtr.printOut("UltmtCdtr", ps);
        }
        if (this.chrgBr != null) {
            ps.printOut("ChrgBr", this.chrgBr);
        }
        for (DirectDebitTransactionInformationSDD drctDbtTxInf : this.drctDbtTxInfs) {
            drctDbtTxInf.printOut("DrctDbtTxInf", ps);
        }
    }

    static class Parser
    extends ElementParser {
        final PaymentInstructionInformationSDD toReturn = new PaymentInstructionInformationSDD();
        final Pain00800201Listener listener;
        final String parentUri;

        public Parser(String uri, Pain00800201Listener listener) {
            super(0);
            this.listener = listener;
            if (listener == null) {
                this.toReturn.drctDbtTxInfs = new ArrayList<DirectDebitTransactionInformationSDD>();
            }
            this.parentUri = uri;
        }

        @Override
        protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
            if (this.parentUri.equals(uri)) {
                if ("PmtInfId".equals(localName) && this.allowChild(0)) {
                    return new RestrictedIdentification1.Parser();
                }
                if ("PmtMtd".equals(localName) && this.allowChild(-1, 1)) {
                    return PaymentMethod2Code.DD.createParser();
                }
                if ("PmtTpInf".equals(localName) && this.allowChild(2)) {
                    return new PaymentTypeInformationSDD.Parser(uri);
                }
                if ("ReqdColltnDt".equals(localName) && this.allowChild(3)) {
                    return new XMLDate().createParser();
                }
                if ("Cdtr".equals(localName) && this.allowChild(4)) {
                    return new PartyIdentificationSDD2.Parser(uri);
                }
                if ("CdtrAcct".equals(localName) && this.allowChild(5)) {
                    return new CashAccountSDD1.Parser(uri);
                }
                if ("CdtrAgt".equals(localName) && this.allowChild(6)) {
                    return new BranchAndFinancialInstitutionIdentificationSDD1.Parser(uri);
                }
                if ("UltmtCdtr".equals(localName) && this.allowChild(7)) {
                    return new PartyIdentificationSDD1.Parser(uri);
                }
                if ("ChrgBr".equals(localName) && this.allowChild(6, 8)) {
                    return ChargeBearerTypeSDDCode.SLEV.createParser();
                }
                if ("DrctDbtTxInf".equals(localName) && (this.currentChild == 9 || this.allowChild(6, 9))) {
                    return new DirectDebitTransactionInformationSDD.Parser(uri);
                }
            }
            return null;
        }

        @Override
        protected void endChild(EbicsElement element) {
            switch (this.currentChild) {
                case 0: {
                    this.toReturn.pmtInfId = (RestrictedIdentification1)element;
                    break;
                }
                case 2: {
                    this.toReturn.pmtTpInf = (PaymentTypeInformationSDD)element;
                    break;
                }
                case 3: {
                    this.toReturn.reqdColltnDt = (XMLDate)element;
                    break;
                }
                case 4: {
                    this.toReturn.cdtr = (PartyIdentificationSDD2)element;
                    break;
                }
                case 5: {
                    this.toReturn.cdtrAcct = (CashAccountSDD1)element;
                    break;
                }
                case 6: {
                    this.toReturn.cdtrAgt = (BranchAndFinancialInstitutionIdentificationSDD1)element;
                    break;
                }
                case 7: {
                    this.toReturn.ultmtCdtr = (PartyIdentificationSDD1)element;
                    break;
                }
                case 8: {
                    this.toReturn.chrgBr = (ChargeBearerTypeSDDCode)element;
                    break;
                }
                case 9: {
                    if (this.listener != null) {
                        this.listener.handleTransaction((DirectDebitTransactionInformationSDD)element);
                        break;
                    }
                    this.toReturn.drctDbtTxInfs.add((DirectDebitTransactionInformationSDD)element);
                }
            }
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.checkLastMandatory(9);
            return this.toReturn;
        }
    }
}

