/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.pain00800201;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsElementListener;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.iso20022.pain00800101.CurrencyAndAmount;
import de.businesslogics.format.iso20022.pain00800101.DirectDebitTransactionInformation1;
import de.businesslogics.format.iso20022.pain00800101.Document;
import de.businesslogics.format.iso20022.pain00800101.GroupHeader1;
import de.businesslogics.format.iso20022.pain00800101.PaymentInstructionInformation2;
import de.businesslogics.format.iso20022.pain00800102.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.iso20022.pain00800102.DirectDebitTransactionInformation9;
import de.businesslogics.format.iso20022.pain00800102.GroupHeader39;
import de.businesslogics.format.iso20022.pain00800102.OrganisationIdentification4;
import de.businesslogics.format.iso20022.pain00800102.Party6Choice;
import de.businesslogics.format.iso20022.pain00800102.PartyIdentification32;
import de.businesslogics.format.iso20022.pain00800102.PaymentInstructionInformation4;
import de.businesslogics.format.iso20022.pain00800108.DirectDebitTransactionInformation23;
import de.businesslogics.format.iso20022.pain00800108.GroupHeader83;
import de.businesslogics.format.iso20022.pain00800108.OrganisationIdentification29;
import de.businesslogics.format.iso20022.pain00800108.Party38Choice;
import de.businesslogics.format.iso20022.pain00800108.PartyIdentification135;
import de.businesslogics.format.iso20022.pain00800108.PaymentInstruction29;
import de.businesslogics.format.ptk2.XmlDisplayMessage;
import de.businesslogics.format.sepa.AccountNumberInfo;
import de.businesslogics.format.sepa.GroupHeaderSDD;
import de.businesslogics.format.sepa.SEPADebitExtractorV2Iso;
import de.businesslogics.format.sepa.SEPADebitExtractorV3Iso;
import de.businesslogics.format.sepa.SEPADebitExtractorV8Iso;
import de.businesslogics.format.sepa.pain00800201.DirectDebitTransactionInformationSDD;
import de.businesslogics.format.sepa.pain00800201.Pain00800201Document;
import de.businesslogics.format.sepa.pain00800201.Pain00800201Listener;
import de.businesslogics.format.sepa.pain00800201.Pain00800201PmtInfTicket;
import de.businesslogics.format.sepa.pain00800201.PaymentInstructionInformationSDD;
import de.businesslogics.format.sepa.pain00800202.CustomerDirectDebitInitiationV02;
import de.businesslogics.format.sepa.pain00800202.GenericOrganisationIdentification1;
import de.businesslogics.format.sepa.pain00800202.OrganisationIdentificationSEPAChoice;
import de.businesslogics.format.sepa.pain00800202.PartyIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00800202.PartySEPAChoice;
import de.businesslogics.format.sepa.pain00800302.BICIdentifier;
import de.businesslogics.format.sepa.pain00800302.PartySEPAChoice;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class Pain00800201Ticket
implements XmlDisplayMessage {
    private static final long serialVersionUID = 1L;
    private List<Pain00800201PmtInfTicket> singleTickets = new ArrayList<Pain00800201PmtInfTicket>();
    private String messageIdentification;
    private Date creationDateTime;
    private BigDecimal controlSum;
    private long numberOfTxs;
    private boolean isDebitTypeUnique = true;
    private String debitType;
    private String nameSpace;
    private String initiatorName;
    private String initiatorId;

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getInitiatorName() {
        return this.initiatorName;
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }

    public String getMessageIdentification() {
        return this.messageIdentification;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    public List<Pain00800201PmtInfTicket> getSingleTickets() {
        return this.singleTickets;
    }

    @Override
    public EbicsHandler startParsing() {
        return this.startParsing(false);
    }

    public EbicsHandler startParsing(boolean bundesBank) {
        return this.startParsing(bundesBank, false);
    }

    public EbicsHandler startParsing(boolean bundesBank, boolean allowIsoFormats) {
        return this.startParsing(bundesBank, allowIsoFormats, false);
    }

    public EbicsHandler startParsing(boolean bundesBank, boolean allowIsoFormats, boolean allowATFormats) {
        SwissArmyKnife sak = new SwissArmyKnife();
        sak.bundesBank = bundesBank;
        RootChoiceParser parser = new RootChoiceParser();
        parser.addParser(new Pain00800201Document.Parser(sak));
        parser.addPossibleRoot(de.businesslogics.format.sepa.pain00800202.Document.class);
        parser.addPossibleRoot(de.businesslogics.format.sepa.pain00800302.Document.class);
        if (allowIsoFormats) {
            parser.addPossibleRoot(Document.class);
            parser.addPossibleRoot(de.businesslogics.format.iso20022.pain00800102.Document.class);
            parser.addPossibleRoot(de.businesslogics.format.iso20022.pain00800108.Document.class);
        }
        if (allowATFormats) {
            parser.addPossibleRoot("ISO:pain.008.001.02:APC:STUZZA:payments:003", "Document", de.businesslogics.format.iso20022.pain00800102.Document.class);
            parser.addPossibleRoot("ISO:pain.008.001.02:APC:STUZZA:payments:004", "Document", de.businesslogics.format.iso20022.pain00800102.Document.class);
        }
        EbicsHandler ebicsHandler = new EbicsHandler(parser);
        ebicsHandler.setListener(sak);
        return ebicsHandler;
    }

    @Override
    public void appendText(Locale locale, StringBuilder buffer) {
        ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.format.sepa.Sepa", locale);
        this.appendMost(bundle, locale, buffer);
        buffer.append(bundle.getString("MAIN_SEPARATOR"));
    }

    public void appendMost(ResourceBundle bundle, Locale locale, StringBuilder buffer) {
        buffer.append(bundle.getString("MAIN_SEPARATOR"));
        buffer.append("\r\n");
        buffer.append(bundle.getString("LASTSCHRIFTEN"));
        if (this.debitType != null) {
            buffer.append("  (");
            buffer.append(this.debitType);
            buffer.append(")");
        }
        buffer.append("\r\n");
        buffer.append(bundle.getString("FILE_ID"));
        buffer.append(this.messageIdentification);
        buffer.append("\r\n");
        buffer.append(bundle.getString("TIMESTAMP"));
        buffer.append(new SimpleDateFormat(bundle.getString("TIMESTAMP_FORMAT")).format(this.creationDateTime));
        buffer.append("\r\n");
        if (this.initiatorName != null) {
            buffer.append(bundle.getString("INITIATOR_NAME"));
            buffer.append(this.initiatorName);
            buffer.append("\r\n");
        }
        if (this.initiatorId != null) {
            buffer.append(bundle.getString("INITIATOR_ID"));
            buffer.append(this.initiatorId);
            buffer.append("\r\n");
        }
        if (Boolean.getBoolean("de.businesslogics.format.sepa.WithGroupTotal")) {
            buffer.append(bundle.getString("MINOR_SEPARATOR"));
            buffer.append("\r\n");
            buffer.append(bundle.getString("TOTAL_ANZAHL"));
            buffer.append(this.getTotalNumberOfPayments());
            buffer.append("\r\n");
            buffer.append(bundle.getString("TOTOAL_AMOUNT"));
            DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(locale));
            buffer.append(df.format(this.getTotalAmount()));
            buffer.append("\r\n");
        }
        for (Pain00800201PmtInfTicket t : this.singleTickets) {
            t.appendMost(bundle, locale, buffer);
        }
    }

    public BigDecimal getTotalAmount() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Pain00800201PmtInfTicket t : this.singleTickets) {
            totalAmount = totalAmount.add(t.getCtrlSum());
        }
        return totalAmount;
    }

    public long getTotalNumberOfPayments() {
        long totalNumber = 0L;
        for (Pain00800201PmtInfTicket t : this.singleTickets) {
            totalNumber += (long)t.getNumberOfPayments();
        }
        return totalNumber;
    }

    public BigDecimal getControlSum() {
        return this.controlSum;
    }

    public long getNumberOfTxs() {
        return this.numberOfTxs;
    }

    public boolean isDebitTypeUnique() {
        return this.isDebitTypeUnique;
    }

    public String getDebitType() {
        return this.debitType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendText(Locale.getDefault(), sb);
        return sb.toString();
    }

    private void checkDebitType(String value) {
        if (this.debitType == null) {
            this.debitType = value;
        } else if (this.isDebitTypeUnique && !this.debitType.equals(value)) {
            this.isDebitTypeUnique = false;
        }
    }

    public class SwissArmyKnife
    implements Pain00800201Listener,
    EbicsElementListener {
        private boolean bundesBank;
        private Pain00800201PmtInfTicket currentTicket;
        private List<?> list1ToClear;
        private List<?> list2ToClear;

        @Override
        public void endGroupHeaderSDD(GroupHeaderSDD toReturn) {
        }

        @Override
        public void endDocument(Pain00800201Document document) {
            GroupHeaderSDD grpHdr = document.getPain00800101().getGrpHdr();
            Pain00800201Ticket.this.messageIdentification = grpHdr.getMsgId().getValue();
            Pain00800201Ticket.this.creationDateTime = grpHdr.getCreDtTm();
            Pain00800201Ticket.this.controlSum = grpHdr.getCtrlSum();
            Pain00800201Ticket.this.numberOfTxs = grpHdr.getNbOfTxs();
            if (grpHdr.getInitgPty() != null) {
                Pain00800201Ticket.this.initiatorName = grpHdr.getInitgPty().getNm();
            }
        }

        @Override
        public void handleTransaction(DirectDebitTransactionInformationSDD ddt) {
            this.currentTicket.handleTransaction(ddt);
        }

        @Override
        public void startDocument(Pain00800201Document document) {
        }

        @Override
        public void endPaymentInstructionInformation(PaymentInstructionInformationSDD pmtInf) {
            this.currentTicket.endPaymentInstructionInformation(pmtInf);
            Pain00800201Ticket.this.singleTickets.add(this.currentTicket);
            Pain00800201Ticket.this.checkDebitType(pmtInf.getPmtTpInf().getLclInstrm().getCd().getValue());
        }

        @Override
        public void startPaymentInstructionInformation(PaymentInstructionInformationSDD pmtInf) {
            this.currentTicket = new Pain00800201PmtInfTicket();
            this.currentTicket.startPaymentInstructionInformation();
        }

        @Override
        public void endElement(EbicsElement element) {
            if (element instanceof de.businesslogics.format.sepa.pain00800202.PaymentInstructionInformationSDD) {
                GenericOrganisationIdentification1 goic;
                OrganisationIdentificationSEPAChoice oic;
                PartySEPAChoice pc;
                PartyIdentificationSEPA1 p;
                String currency;
                de.businesslogics.format.sepa.pain00800202.PaymentInstructionInformationSDD sdd = (de.businesslogics.format.sepa.pain00800202.PaymentInstructionInformationSDD)element;
                BigDecimal ctrlSum = null;
                if (sdd.getCtrlSum() != null) {
                    ctrlSum = sdd.getCtrlSum().getValue();
                }
                int nbOfTxs = -1;
                if (sdd.getNbOfTxs() != null) {
                    try {
                        nbOfTxs = Integer.parseInt(sdd.getNbOfTxs().getValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Pain00800201Ticket.this.checkDebitType(sdd.getPmtTpInf().getLclInstrm().getCd().getValue());
                String bic = sdd.getCdtrAgt().getFinInstnId().getBIC().getValue();
                String iban = sdd.getCdtrAcct().getId().getIBAN().getValue();
                String string = currency = sdd.getCdtrAcct().getCcy() != null ? sdd.getCdtrAcct().getCcy().getValue() : null;
                if (this.bundesBank && (p = sdd.getUltmtCdtr()) != null && (pc = p.getId()) != null && (oic = pc.getChoice1().getOrgId()) != null && (goic = oic.getChoice1().getOthr()) != null) {
                    iban = goic.getId().getValue();
                    bic = null;
                }
                this.currentTicket.endPaymentInstructionInformation(sdd.getPmtInfId().getValue(), bic, iban, currency, sdd.getCdtr().getNm().getValue(), sdd.getReqdColltnDt().getDate(), ctrlSum, nbOfTxs);
                Pain00800201Ticket.this.singleTickets.add(this.currentTicket);
                this.list2ToClear = null;
            } else if (element instanceof de.businesslogics.format.sepa.pain00800202.DirectDebitTransactionInformationSDD) {
                de.businesslogics.format.sepa.pain00800202.DirectDebitTransactionInformationSDD sdd = (de.businesslogics.format.sepa.pain00800202.DirectDebitTransactionInformationSDD)element;
                this.currentTicket.handleTransaction(sdd.getInstdAmt().getValue());
                this.list2ToClear.clear();
            } else if (element instanceof de.businesslogics.format.sepa.pain00800202.Document) {
                GenericOrganisationIdentification1 gid;
                PartySEPAChoice.PartySEPAChoice_C1 id;
                Pain00800201Ticket.this.nameSpace = element.namespace();
                de.businesslogics.format.sepa.pain00800202.GroupHeaderSDD grpHdr = ((de.businesslogics.format.sepa.pain00800202.Document)element).getCstmrDrctDbtInitn().getGrpHdr();
                Pain00800201Ticket.this.messageIdentification = grpHdr.getMsgId().getValue();
                Pain00800201Ticket.this.creationDateTime = grpHdr.getCreDtTm().getDate();
                if (grpHdr.getCtrlSum() != null) {
                    Pain00800201Ticket.this.controlSum = grpHdr.getCtrlSum().getValue();
                }
                try {
                    Pain00800201Ticket.this.numberOfTxs = Integer.parseInt(grpHdr.getNbOfTxs().getValue());
                }
                catch (Exception e) {
                    Pain00800201Ticket.this.numberOfTxs = -1L;
                }
                if (grpHdr.getInitgPty().getNm() != null) {
                    Pain00800201Ticket.this.initiatorName = grpHdr.getInitgPty().getNm().getValue();
                }
                if (grpHdr.getInitgPty().getId() != null && (id = grpHdr.getInitgPty().getId().getChoice1()).getOrgId() != null && (gid = id.getOrgId().getChoice1().getOthr()) != null) {
                    Pain00800201Ticket.this.initiatorId = gid.getId().getValue();
                }
            } else if (element instanceof de.businesslogics.format.sepa.pain00800302.PaymentInstructionInformationSDD) {
                de.businesslogics.format.sepa.pain00800302.GenericOrganisationIdentification1 goic;
                de.businesslogics.format.sepa.pain00800302.OrganisationIdentificationSEPAChoice oic;
                de.businesslogics.format.sepa.pain00800302.PartySEPAChoice pc;
                de.businesslogics.format.sepa.pain00800302.PartyIdentificationSEPA1 p;
                String currency;
                de.businesslogics.format.sepa.pain00800302.PaymentInstructionInformationSDD sdd = (de.businesslogics.format.sepa.pain00800302.PaymentInstructionInformationSDD)element;
                BigDecimal ctrlSum = null;
                if (sdd.getCtrlSum() != null) {
                    ctrlSum = sdd.getCtrlSum().getValue();
                }
                int nbOfTxs = -1;
                if (sdd.getNbOfTxs() != null) {
                    try {
                        nbOfTxs = Integer.parseInt(sdd.getNbOfTxs().getValue());
                    }
                    catch (Exception bic) {
                        // empty catch block
                    }
                }
                Pain00800201Ticket.this.checkDebitType(sdd.getPmtTpInf().getLclInstrm().getCd().getValue());
                String sddBic = null;
                BICIdentifier bic = sdd.getCdtrAgt().getFinInstnId().getChoice1().getBIC();
                if (bic != null) {
                    sddBic = bic.getValue();
                }
                String iban = sdd.getCdtrAcct().getId().getIBAN().getValue();
                String string = currency = sdd.getCdtrAcct().getCcy() != null ? sdd.getCdtrAcct().getCcy().getValue() : null;
                if (this.bundesBank && (p = sdd.getUltmtCdtr()) != null && (pc = p.getId()) != null && (oic = pc.getChoice1().getOrgId()) != null && (goic = oic.getChoice1().getOthr()) != null) {
                    iban = goic.getId().getValue();
                    sddBic = null;
                }
                this.currentTicket.endPaymentInstructionInformation(sdd.getPmtInfId().getValue(), sddBic, iban, currency, sdd.getCdtr().getNm().getValue(), sdd.getReqdColltnDt().getDate(), ctrlSum, nbOfTxs);
                Pain00800201Ticket.this.singleTickets.add(this.currentTicket);
                this.list2ToClear = null;
            } else if (element instanceof de.businesslogics.format.sepa.pain00800302.DirectDebitTransactionInformationSDD) {
                de.businesslogics.format.sepa.pain00800302.DirectDebitTransactionInformationSDD sdd = (de.businesslogics.format.sepa.pain00800302.DirectDebitTransactionInformationSDD)element;
                this.currentTicket.handleTransaction(sdd.getInstdAmt().getValue());
                this.list2ToClear.clear();
            } else if (element instanceof de.businesslogics.format.sepa.pain00800302.Document) {
                de.businesslogics.format.sepa.pain00800302.GenericOrganisationIdentification1 gid;
                PartySEPAChoice.PartySEPAChoice_C1 id;
                Pain00800201Ticket.this.nameSpace = element.namespace();
                de.businesslogics.format.sepa.pain00800302.GroupHeaderSDD grpHdr = ((de.businesslogics.format.sepa.pain00800302.Document)element).getCstmrDrctDbtInitn().getGrpHdr();
                Pain00800201Ticket.this.messageIdentification = grpHdr.getMsgId().getValue();
                Pain00800201Ticket.this.creationDateTime = grpHdr.getCreDtTm().getDate();
                if (grpHdr.getCtrlSum() != null) {
                    Pain00800201Ticket.this.controlSum = grpHdr.getCtrlSum().getValue();
                }
                try {
                    Pain00800201Ticket.this.numberOfTxs = Integer.parseInt(grpHdr.getNbOfTxs().getValue());
                }
                catch (Exception e) {
                    Pain00800201Ticket.this.numberOfTxs = -1L;
                }
                if (grpHdr.getInitgPty().getNm() != null) {
                    Pain00800201Ticket.this.initiatorName = grpHdr.getInitgPty().getNm().getValue();
                }
                if (grpHdr.getInitgPty().getId() != null && (id = grpHdr.getInitgPty().getId().getChoice1()).getOrgId() != null && (gid = id.getOrgId().getChoice1().getOthr()) != null) {
                    Pain00800201Ticket.this.initiatorId = gid.getId().getValue();
                }
            } else if (element instanceof PaymentInstructionInformation2) {
                this.evaluateLogicalFile((PaymentInstructionInformation2)element);
            } else if (element instanceof DirectDebitTransactionInformation1) {
                this.evaluateTransaction((DirectDebitTransactionInformation1)element);
            } else if (element instanceof Document) {
                Pain00800201Ticket.this.nameSpace = element.namespace();
                GroupHeader1 grpHdr = ((Document)element).getPain_008_001_01().getGrpHdr();
                this.evaluateGroupHeader(grpHdr);
            } else if (element instanceof PaymentInstructionInformation4) {
                this.evaluateLogicalFile((PaymentInstructionInformation4)element);
            } else if (element instanceof DirectDebitTransactionInformation9) {
                this.evaluateTransaction((DirectDebitTransactionInformation9)element);
            } else if (element instanceof de.businesslogics.format.iso20022.pain00800102.Document) {
                Pain00800201Ticket.this.nameSpace = element.namespace();
                GroupHeader39 grpHdr = ((de.businesslogics.format.iso20022.pain00800102.Document)element).getCstmrDrctDbtInitn().getGrpHdr();
                this.evaluateGroupHeader(grpHdr);
            } else if (element instanceof PaymentInstruction29) {
                this.evaluateLogicalFile((PaymentInstruction29)element);
            } else if (element instanceof DirectDebitTransactionInformation23) {
                this.evaluateTransaction((DirectDebitTransactionInformation23)element);
            } else if (element instanceof de.businesslogics.format.iso20022.pain00800108.Document) {
                Pain00800201Ticket.this.nameSpace = element.namespace();
                GroupHeader83 grpHdr = ((de.businesslogics.format.iso20022.pain00800108.Document)element).getCstmrDrctDbtInitn().getGrpHdr();
                this.evaluateGroupHeader(grpHdr);
            }
        }

        @Override
        public void startElement(String uri, String localName, EbicsElement element) {
            if (element instanceof CustomerDirectDebitInitiationV02) {
                CustomerDirectDebitInitiationV02 v02 = (CustomerDirectDebitInitiationV02)element;
                this.list1ToClear = v02.getPmtInfs();
            } else if (element instanceof de.businesslogics.format.sepa.pain00800202.PaymentInstructionInformationSDD) {
                de.businesslogics.format.sepa.pain00800202.PaymentInstructionInformationSDD sdd = (de.businesslogics.format.sepa.pain00800202.PaymentInstructionInformationSDD)element;
                this.list2ToClear = sdd.getDrctDbtTxInfs();
                this.currentTicket = new Pain00800201PmtInfTicket();
                this.currentTicket.startPaymentInstructionInformation();
                this.list1ToClear.clear();
            } else if (element instanceof de.businesslogics.format.sepa.pain00800302.CustomerDirectDebitInitiationV02) {
                de.businesslogics.format.sepa.pain00800302.CustomerDirectDebitInitiationV02 v02 = (de.businesslogics.format.sepa.pain00800302.CustomerDirectDebitInitiationV02)element;
                this.list1ToClear = v02.getPmtInfs();
            } else if (element instanceof de.businesslogics.format.sepa.pain00800302.PaymentInstructionInformationSDD) {
                de.businesslogics.format.sepa.pain00800302.PaymentInstructionInformationSDD sdd = (de.businesslogics.format.sepa.pain00800302.PaymentInstructionInformationSDD)element;
                this.list2ToClear = sdd.getDrctDbtTxInfs();
                this.currentTicket = new Pain00800201PmtInfTicket();
                this.currentTicket.startPaymentInstructionInformation();
                this.list1ToClear.clear();
            } else if (element instanceof PaymentInstructionInformation2) {
                PaymentInstructionInformation2 sdd = (PaymentInstructionInformation2)element;
                this.list2ToClear = sdd.getDrctDbtTxInfs();
                this.currentTicket = new Pain00800201PmtInfTicket();
                this.currentTicket.startPaymentInstructionInformation();
            } else if (element instanceof PaymentInstructionInformation4) {
                PaymentInstructionInformation4 sdd = (PaymentInstructionInformation4)element;
                this.list2ToClear = sdd.getDrctDbtTxInfs();
                this.currentTicket = new Pain00800201PmtInfTicket();
                this.currentTicket.startPaymentInstructionInformation();
            } else if (element instanceof PaymentInstruction29) {
                PaymentInstruction29 sdd = (PaymentInstruction29)element;
                this.list2ToClear = sdd.getDrctDbtTxInfs();
                this.currentTicket = new Pain00800201PmtInfTicket();
                this.currentTicket.startPaymentInstructionInformation();
            }
        }

        private void evaluateTransaction(DirectDebitTransactionInformation1 t) {
            CurrencyAndAmount ccyAndAmt = t.getInstdAmt();
            this.currentTicket.handleTransaction(ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()));
            this.list2ToClear.clear();
        }

        private void evaluateTransaction(DirectDebitTransactionInformation9 t) {
            ActiveOrHistoricCurrencyAndAmount ccyAndAmt = t.getInstdAmt();
            this.currentTicket.handleTransaction(ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()));
            this.list2ToClear.clear();
        }

        private void evaluateTransaction(DirectDebitTransactionInformation23 t) {
            de.businesslogics.format.iso20022.pain00800108.ActiveOrHistoricCurrencyAndAmount ccyAndAmt = t.getInstdAmt();
            this.currentTicket.handleTransaction(ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()));
            this.list2ToClear.clear();
        }

        private void evaluateLogicalFile(PaymentInstructionInformation2 lf) {
            String pmtInfId = SimpleStringElement.getNonNullValue(lf.getPmtInfId());
            String bankCode = SEPADebitExtractorV2Iso.getBankIdentifier(lf.getCdtrAgt().getFinInstnId().getChoice1());
            String accNumber = SEPADebitExtractorV2Iso.getAccountIdentifier(lf.getCdtrAcct().getId().getChoice1());
            String accCurrency = lf.getCdtrAcct().getCcy() != null ? lf.getCdtrAcct().getCcy().getValue() : null;
            String origName = SimpleStringElement.getNonNullValue(lf.getCdtr().getNm());
            String debitType = SEPADebitExtractorV2Iso.getDebitType(lf.getPmtTpInf());
            if (debitType != null && debitType.trim().length() > 0) {
                Pain00800201Ticket.this.checkDebitType(debitType.trim());
            }
            this.currentTicket.endPaymentInstructionInformation(pmtInfId, bankCode, accNumber, accCurrency, origName, lf.getReqdColltnDt().getDate(), null, -1);
            Pain00800201Ticket.this.singleTickets.add(this.currentTicket);
            this.list2ToClear = null;
        }

        private void evaluateLogicalFile(PaymentInstructionInformation4 lf) {
            OrganisationIdentification4 oic;
            Party6Choice pc;
            PartyIdentification32 p;
            String pmtInfId = SimpleStringElement.getNonNullValue(lf.getPmtInfId());
            String bankCode = SEPADebitExtractorV3Iso.getBankIdentifier(lf.getCdtrAgt().getFinInstnId());
            AccountNumberInfo accountNumberInfo = SEPADebitExtractorV3Iso.getAccountNumberInfo(lf.getCdtrAcct().getId().getChoice1());
            String accNumber = accountNumberInfo != null ? accountNumberInfo.getAccountNumber() : null;
            String accCurrency = lf.getCdtrAcct().getCcy() != null ? lf.getCdtrAcct().getCcy().getValue() : null;
            String origName = SimpleStringElement.getNonNullValue(lf.getCdtr().getNm());
            String debitType = SEPADebitExtractorV3Iso.getDebitType(lf.getPmtTpInf());
            if (debitType != null && debitType.trim().length() > 0) {
                Pain00800201Ticket.this.checkDebitType(debitType.trim());
            }
            BigDecimal ctrlSum = null;
            if (lf.getCtrlSum() != null) {
                ctrlSum = lf.getCtrlSum().getValue();
            }
            int nbOfTxs = -1;
            if (lf.getNbOfTxs() != null) {
                try {
                    nbOfTxs = Integer.parseInt(lf.getNbOfTxs().getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.bundesBank && (p = lf.getUltmtCdtr()) != null && (pc = p.getId()) != null && (oic = pc.getChoice1().getOrgId()) != null && oic.getOthrs().size() > 0) {
                de.businesslogics.format.iso20022.pain00800102.GenericOrganisationIdentification1 goic = oic.getOthrs().get(0);
                accNumber = goic.getId().getValue();
                bankCode = null;
            }
            this.currentTicket.endPaymentInstructionInformation(pmtInfId, bankCode, accNumber, accCurrency, origName, lf.getReqdColltnDt().getDate(), ctrlSum, nbOfTxs);
            Pain00800201Ticket.this.singleTickets.add(this.currentTicket);
            this.list2ToClear = null;
        }

        private void evaluateLogicalFile(PaymentInstruction29 lf) {
            OrganisationIdentification29 oic;
            Party38Choice pc;
            PartyIdentification135 p;
            String pmtInfId = SimpleStringElement.getNonNullValue(lf.getPmtInfId());
            String bankCode = SEPADebitExtractorV8Iso.getBankIdentifier(lf.getCdtrAgt().getFinInstnId());
            AccountNumberInfo accountNumberInfo = SEPADebitExtractorV8Iso.getAccountNumberInfo(lf.getCdtrAcct().getId().getChoice1());
            String accNumber = accountNumberInfo != null ? accountNumberInfo.getAccountNumber() : null;
            String accCurrency = lf.getCdtrAcct().getCcy() != null ? lf.getCdtrAcct().getCcy().getValue() : null;
            String origName = SimpleStringElement.getNonNullValue(lf.getCdtr().getNm());
            String debitType = SEPADebitExtractorV8Iso.getDebitType(lf.getPmtTpInf());
            if (debitType != null && debitType.trim().length() > 0) {
                Pain00800201Ticket.this.checkDebitType(debitType.trim());
            }
            BigDecimal ctrlSum = null;
            if (lf.getCtrlSum() != null) {
                ctrlSum = lf.getCtrlSum().getValue();
            }
            int nbOfTxs = -1;
            if (lf.getNbOfTxs() != null) {
                try {
                    nbOfTxs = Integer.parseInt(lf.getNbOfTxs().getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.bundesBank && (p = lf.getUltmtCdtr()) != null && (pc = p.getId()) != null && (oic = pc.getChoice1().getOrgId()) != null && oic.getOthrs().size() > 0) {
                de.businesslogics.format.iso20022.pain00800108.GenericOrganisationIdentification1 goic = oic.getOthrs().get(0);
                accNumber = goic.getId().getValue();
                bankCode = null;
            }
            this.currentTicket.endPaymentInstructionInformation(pmtInfId, bankCode, accNumber, accCurrency, origName, lf.getReqdColltnDt().getDate(), ctrlSum, nbOfTxs);
            Pain00800201Ticket.this.singleTickets.add(this.currentTicket);
            this.list2ToClear = null;
        }

        private void evaluateGroupHeader(GroupHeader1 grpHdr) {
            Pain00800201Ticket.this.messageIdentification = grpHdr.getMsgId().getValue();
            Pain00800201Ticket.this.creationDateTime = grpHdr.getCreDtTm().getDate();
            if (grpHdr.getCtrlSum() != null) {
                Pain00800201Ticket.this.controlSum = grpHdr.getCtrlSum().getValue();
            }
            try {
                Pain00800201Ticket.this.numberOfTxs = Integer.parseInt(grpHdr.getNbOfTxs().getValue());
            }
            catch (Exception e) {
                Pain00800201Ticket.this.numberOfTxs = -1L;
            }
        }

        private void evaluateGroupHeader(GroupHeader39 grpHdr) {
            Pain00800201Ticket.this.messageIdentification = grpHdr.getMsgId().getValue();
            Pain00800201Ticket.this.creationDateTime = grpHdr.getCreDtTm().getDate();
            if (grpHdr.getCtrlSum() != null) {
                Pain00800201Ticket.this.controlSum = grpHdr.getCtrlSum().getValue();
            }
            try {
                Pain00800201Ticket.this.numberOfTxs = Integer.parseInt(grpHdr.getNbOfTxs().getValue());
            }
            catch (Exception e) {
                Pain00800201Ticket.this.numberOfTxs = -1L;
            }
        }

        private void evaluateGroupHeader(GroupHeader83 grpHdr) {
            Pain00800201Ticket.this.messageIdentification = grpHdr.getMsgId().getValue();
            Pain00800201Ticket.this.creationDateTime = grpHdr.getCreDtTm().getDate();
            if (grpHdr.getCtrlSum() != null) {
                Pain00800201Ticket.this.controlSum = grpHdr.getCtrlSum().getValue();
            }
            try {
                Pain00800201Ticket.this.numberOfTxs = Integer.parseInt(grpHdr.getNbOfTxs().getValue());
            }
            catch (Exception e) {
                Pain00800201Ticket.this.numberOfTxs = -1L;
            }
        }
    }
}

