/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.pain00800201;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.sepa.CurrencyCode;
import de.businesslogics.format.sepa.pain00800201.DirectDebitTransactionInformationSDD;
import de.businesslogics.format.sepa.pain00800201.PaymentInstructionInformationSDD;
import de.businesslogics.util.Currency;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class Pain00800201PmtInfTicket
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String paymentInformationIdentification;
    private String creditorBIC;
    private String creditorAccount;
    private String creditorAccountCurrency;
    private String creditorName;
    private YYMMDD requestedCollectionDate;
    private BigDecimal ctrlSum;
    private int numberOfPayments;
    private Currency currency = null;
    private boolean hasUniqueCurrency = true;
    private BigDecimal givenCtrlSum;
    private int givenNumberOfPayments;

    public void startPaymentInstructionInformation() {
        this.ctrlSum = BigDecimal.ZERO;
        this.numberOfPayments = 0;
    }

    public void endPaymentInstructionInformation(PaymentInstructionInformationSDD pmtInf) {
        if (pmtInf.getPmtInfId() != null) {
            this.paymentInformationIdentification = pmtInf.getPmtInfId().getValue();
        }
        this.creditorBIC = pmtInf.getCdtrAgt().getFinInstnId().getBic();
        this.creditorAccount = pmtInf.getCdtrAcct().getId().getIban();
        CurrencyCode cc = pmtInf.getCdtrAcct().getCcy();
        this.creditorAccountCurrency = cc != null ? cc.getValue() : null;
        this.creditorName = pmtInf.getCdtr().getNm();
        this.requestedCollectionDate = pmtInf.getReqdColltnDt().getDate();
    }

    public void endPaymentInstructionInformation(String paymentInformationIdentification, String creditorBIC, String creditorAccount, String creditorAccountCurrency, String creditorName, YYMMDD requestedCollectionDate) {
        this.endPaymentInstructionInformation(paymentInformationIdentification, creditorBIC, creditorAccount, creditorAccountCurrency, creditorName, requestedCollectionDate, null, -1);
    }

    public void endPaymentInstructionInformation(String paymentInformationIdentification, String creditorBIC, String creditorAccount, String creditorAccountCurrency, String creditorName, YYMMDD requestedCollectionDate, BigDecimal givenCtrlSum, int givenNumberOfPayments) {
        this.paymentInformationIdentification = paymentInformationIdentification;
        this.creditorBIC = creditorBIC;
        this.creditorAccount = creditorAccount;
        this.creditorAccountCurrency = creditorAccountCurrency;
        this.creditorName = creditorName;
        this.requestedCollectionDate = requestedCollectionDate;
        this.givenCtrlSum = givenCtrlSum;
        this.givenNumberOfPayments = givenNumberOfPayments;
    }

    public BigDecimal getCtrlSum() {
        return this.ctrlSum;
    }

    public String getCreditorAccount() {
        return this.creditorAccount;
    }

    public String getCreditorBIC() {
        return this.creditorBIC;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public int getNumberOfPayments() {
        return this.numberOfPayments;
    }

    public BigDecimal getGivenCtrlSum() {
        return this.givenCtrlSum;
    }

    public int getGivenNumberOfPayments() {
        return this.givenNumberOfPayments;
    }

    public void handleTransaction(DirectDebitTransactionInformationSDD crdt) {
        this.handleTransaction(crdt.getInstdAmt().getAmount());
    }

    public void handleTransaction(BigDecimal amount) {
        this.ctrlSum = this.ctrlSum.add(amount);
        ++this.numberOfPayments;
    }

    public void handleTransaction(BigDecimal amount, Currency c) {
        this.handleTransaction(amount);
        if (this.currency == null) {
            this.currency = c;
        }
        if (this.currency != null && !this.currency.equals(c)) {
            this.hasUniqueCurrency = false;
        }
    }

    public void appendText(Locale locale, StringBuilder buffer) {
        ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.format.sepa.Sepa", locale);
        this.appendMost(bundle, locale, buffer);
        buffer.append(bundle.getString("MAIN_SEPARATOR"));
    }

    protected void appendMost(ResourceBundle bundle, Locale locale, StringBuilder buffer) {
        Object s;
        buffer.append(bundle.getString("MINOR_SEPARATOR"));
        buffer.append("\r\n");
        if (this.paymentInformationIdentification != null) {
            buffer.append(bundle.getString("SAMMLERREFERENZ"));
            buffer.append(this.paymentInformationIdentification);
            buffer.append("\r\n");
        }
        if (this.creditorBIC != null) {
            buffer.append(bundle.getString("BANK_CODE"));
            buffer.append(this.creditorBIC);
            buffer.append("\r\n");
        }
        buffer.append(bundle.getString("KONTONUMMER"));
        buffer.append(this.creditorAccount);
        buffer.append("\r\n");
        if (this.creditorAccountCurrency != null) {
            buffer.append(bundle.getString("KONTOWAEHRUNG"));
            buffer.append(this.creditorAccountCurrency);
            buffer.append("\r\n");
        }
        if (((String)(s = bundle.getString("AUFTRAGGEBERDATEN") + this.creditorName)).length() > 72) {
            s = ((String)s).substring(0, 72);
        }
        buffer.append((String)s);
        buffer.append("\r\n");
        buffer.append(bundle.getString("ANZAHL_DER_ZAHLUNGSSAETZE"));
        buffer.append(this.numberOfPayments);
        buffer.append("\r\n");
        if (this.hasUniqueCurrency) {
            if (this.currency != null && !this.currency.getCurrencyCode().equals("EUR")) {
                buffer.append(MessageFormat.format(bundle.getString("SUMME_DER_BETRAEGE_AW"), this.currency.getCurrencyCode()));
            } else {
                buffer.append(bundle.getString("SUMME_DER_BETRAEGE"));
            }
        } else {
            buffer.append(bundle.getString("SUMME_DER_BETRAEGE_OW"));
        }
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(locale));
        buffer.append(df.format(this.ctrlSum));
        buffer.append("\r\n");
        buffer.append(bundle.getString("FAELLIGKEITSDATUM"));
        buffer.append(new SimpleDateFormat(bundle.getString("DATE_FORMAT")).format(this.requestedCollectionDate));
        buffer.append("\r\n");
    }

    public String getPaymentInformationIdentification() {
        return this.paymentInformationIdentification;
    }

    public YYMMDD getRequestedCollectionDate() {
        return this.requestedCollectionDate;
    }

    public boolean hasUniqueCurrency() {
        return this.hasUniqueCurrency;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getCreditorAccountCurrency() {
        return this.creditorAccountCurrency;
    }
}

