/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.csv;

import de.businesslogics.format.AddressData;
import de.businesslogics.format.csv.BaseCSVFormatParser;
import de.businesslogics.format.csv.CSVConverterException;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPAPaymentCategory;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAPurposeCode;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.format.sepa.csv.Format2;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class SepaCSVFormatParser
extends BaseCSVFormatParser {
    public static final String SEPARATOR = "|";
    private final boolean createInternationalPayments;
    private final boolean createSwissDomesticPayments;
    private final boolean createInstantPayments;
    private final boolean invertBatchBooking;
    private final Boolean defaultBatchBooking;
    private final int leadTimeForDirectDebits;
    private final Boolean alwaysCreateStructuredAddress;
    private final GeneralSEPAWriter.Version sepaVersion;

    public SepaCSVFormatParser(Format2 format) {
        super(format);
        this.sepaVersion = format.getSepaVersion();
        this.createInternationalPayments = format.createInternationalPayments();
        this.createSwissDomesticPayments = format.createSwissDomesticPayments();
        this.createInstantPayments = format.isCreateInstantPayments();
        this.invertBatchBooking = format.isInvertBatchBooking();
        this.defaultBatchBooking = format.isDefaultBatchBooking();
        this.leadTimeForDirectDebits = format.getLeadTimeforDirectDebits();
        this.alwaysCreateStructuredAddress = null;
    }

    public SepaCSVFormatParser(Format2 format, boolean createStructuredAddress) {
        super(format);
        this.sepaVersion = format.getSepaVersion();
        this.createInternationalPayments = format.createInternationalPayments();
        this.createSwissDomesticPayments = format.createSwissDomesticPayments();
        this.createInstantPayments = format.isCreateInstantPayments();
        this.invertBatchBooking = format.isInvertBatchBooking();
        this.defaultBatchBooking = format.isDefaultBatchBooking();
        this.leadTimeForDirectDebits = format.getLeadTimeforDirectDebits();
        this.alwaysCreateStructuredAddress = createStructuredAddress;
    }

    protected int minimumColumns(Format2 f) {
        return f.minimumColumns();
    }

    @Override
    protected String validateRow(String[] row) {
        String error = this.checkAmount(row, this.format.getColumn(Format2.Fields.AMOUNT));
        if (error != null) {
            return error;
        }
        error = this.checkString(row, this.format.getColumn(Format2.Fields.ORIGINATOR_IBAN), RegularExpressions.IBAN);
        if (error != null) {
            return error;
        }
        if (this.createInternationalPayments) {
            error = this.checkString(row, this.format.getColumn(Format2.Fields.ORIGINATOR_BIC), RegularExpressions.BIC);
            if (error != null) {
                return error;
            }
        } else {
            error = this.checkString(row, this.format.getColumn(Format2.Fields.RECIPIENT_IBAN), RegularExpressions.IBAN);
            if (error != null) {
                return error;
            }
            if (this.format.isBicMandatory()) {
                error = this.checkString(row, this.format.getColumn(Format2.Fields.ORIGINATOR_BIC), RegularExpressions.BIC);
                if (error != null) {
                    return error;
                }
                error = this.checkString(row, this.format.getColumn(Format2.Fields.RECIPIENT_BIC), RegularExpressions.BIC);
                if (error != null) {
                    return error;
                }
            }
        }
        if ((error = this.checkString(row, this.format.getColumn(Format2.Fields.CREDITOR_ID), RegularExpressions.SEPA_CREDITOR_ID)) != null) {
            return error;
        }
        error = this.checkDate(row, this.format.getColumn(Format2.Fields.DATE));
        if (error != null) {
            return error;
        }
        error = this.checkDate(row, this.format.getColumn(Format2.Fields.MANDATE_SIGNATURE));
        if (error != null) {
            return error;
        }
        if (!this.format.isDifferingCurrencyAllowed() && !this.createInternationalPayments) {
            if (this.format.getColumn(Format2.Fields.CURRENCY) != null && (error = this.checkString(row, this.format.getColumn(Format2.Fields.CURRENCY), RegularExpressions.EUR)) != null) {
                return error;
            }
            if (this.format.getColumn(Format2.Fields.ACCOUNT_CURRENCY) != null && (error = this.checkString(row, this.format.getColumn(Format2.Fields.ACCOUNT_CURRENCY), RegularExpressions.EUR)) != null) {
                return error;
            }
        }
        return null;
    }

    @Override
    protected String getValidString(String s, int maxFieldLength) {
        return SEPAUtil.getSEPAString(s, maxFieldLength, GeneralSEPAWriter.DEFAULT_VERSION);
    }

    public SEPAPaymentData getPaymentData(String[] row, int line) throws CSVConverterException {
        boolean createStructuredAddress;
        String purposeReference;
        BigDecimal amount;
        SEPAPaymentData data = new SEPAPaymentData();
        data.setOriginator(this.getString(row, line, this.format.getColumn(Format2.Fields.ORIGINATOR_NAME), true));
        data.setUltimateOriginator(this.getString(row, line, this.format.getColumn(Format2.Fields.ULTIMATE_ORIGINATOR), false));
        String originatorIban = this.getString(row, line, this.format.getColumn(Format2.Fields.ORIGINATOR_IBAN), true);
        data.setOriginatorIban(originatorIban);
        data.setOriginatorBic(this.getString(row, line, this.format.getColumn(Format2.Fields.ORIGINATOR_BIC), false));
        data.setAccountCurrency(this.getCurrency(row, line, this.format.getColumn(Format2.Fields.ACCOUNT_CURRENCY), false));
        data.setRecipient(this.getString(row, line, this.format.getColumn(Format2.Fields.RECIPIENT_NAME), true));
        data.setUltimateRecipient(this.getString(row, line, this.format.getColumn(Format2.Fields.ULTIMATE_RECIPIENT), false));
        boolean checkPattern = !this.createInternationalPayments;
        String recipientIban = this.getString(row, line, this.format.getColumn(Format2.Fields.RECIPIENT_IBAN), true, checkPattern);
        data.setRecipientIban(recipientIban);
        data.setRecipientBic(this.getString(row, line, this.format.getColumn(Format2.Fields.RECIPIENT_BIC), false, checkPattern));
        if (this.createInternationalPayments) {
            data.setRecipientClearingSystemId(this.getString(row, line, this.format.getColumn(Format2.Fields.CLEARING_SYSTEM_ID), false));
        }
        if ((amount = this.getAmount(row, line, this.format.getColumn(Format2.Fields.AMOUNT))).scale() > 2) {
            amount = amount.setScale(2, RoundingMode.HALF_UP);
        }
        data.setAmount(amount);
        data.setCurrency(this.getCurrency(row, line, this.format.getColumn(Format2.Fields.CURRENCY), false));
        data.setExecutionDate(this.getDate(row, line, this.format.getColumn(Format2.Fields.DATE), false));
        if (data.getExecutionDate() == null) {
            data.setExecutionDate(SEPAUtil.getEarliestExecutionDate(this.sepaVersion, this.format.isCreditFormat(), data.getDebitType(), data.getSequenceType(), this.leadTimeForDirectDebits));
        }
        if ((purposeReference = this.getString(row, line, this.format.getColumn(Format2.Fields.PURPOSE_REFERENCE), false)) != null && !purposeReference.isEmpty()) {
            String purpose;
            data.setHasStructuredPurpose(true);
            if (RegularExpressions.SWISS_REFERENCE_NUMBER.getPattern().matcher(purposeReference).matches()) {
                data.setPurposeReferenceTypePrtry("QRR");
            } else {
                data.setPurposeReferenceTypeCode("SCOR");
            }
            data.setPurposeReference(purposeReference);
            if (this.createSwissDomesticPayments && (purpose = this.getString(row, line, this.format.getColumn(Format2.Fields.PURPOSE), false)) != null && !purpose.isEmpty()) {
                data.getStructuredPurposeLines().add(purpose);
            }
        } else {
            data.setPurpose(this.getString(row, line, this.format.getColumn(Format2.Fields.PURPOSE), false));
        }
        data.setEndToEndId(this.getString(row, line, this.format.getColumn(Format2.Fields.END_TO_END), false));
        data.setPurposeCode(this.checkValue(row, line, this.format.getColumn(Format2.Fields.PURPOSE_CODE), false, SEPAPurposeCode.getPurposeCodes(true)));
        data.setPaymentCategory(this.checkValue(row, line, this.format.getColumn(Format2.Fields.CATEGORY_PURPOSE), false, SEPAPaymentCategory.getPaymentCategories(true)));
        if (this.createInternationalPayments) {
            data.setChargeBearer(this.getString(row, line, this.format.getColumn(Format2.Fields.CHARGE_BEARER), false));
        }
        if (this.format.isCreditFormat()) {
            String srvcLvl;
            boolean mandatory;
            data.setInstructionPriority(this.getString(row, line, this.format.getColumn(Format2.Fields.INSTRUCTION_PRIORITY), false));
            boolean bl = mandatory = !this.createSwissDomesticPayments && !this.createInternationalPayments;
            if (GeneralSEPAWriter.Version.V30Ch.equals((Object)this.sepaVersion)) {
                mandatory = false;
            }
            if ("NONE".equals(srvcLvl = this.getString(row, line, this.format.getColumn(Format2.Fields.CREDIT_TYPE), mandatory))) {
                data.setServiceLevel(null);
            } else {
                data.setServiceLevel(srvcLvl);
            }
        }
        if (this.createInternationalPayments) {
            data.setDisplayAsSingleBooking(true);
        } else if (this.invertBatchBooking) {
            if (this.defaultBatchBooking != null) {
                data.setDisplayAsSingleBooking(this.defaultBatchBooking == false);
            } else {
                data.setDisplayAsSingleBooking(!this.getBoolean(row, this.format.getColumn(Format2.Fields.SINGLE_BOOKING), true));
            }
        } else if (this.defaultBatchBooking != null) {
            data.setDisplayAsSingleBooking(this.defaultBatchBooking == false);
        } else {
            data.setDisplayAsSingleBooking(this.getBoolean(row, this.format.getColumn(Format2.Fields.SINGLE_BOOKING), false));
        }
        data.setInstructionId(this.getString(row, line, this.format.getColumn(Format2.Fields.INSTRUCTION_ID), false));
        boolean bl = createStructuredAddress = this.alwaysCreateStructuredAddress != null ? this.alwaysCreateStructuredAddress.booleanValue() : this.sepaVersion.requiresStructuredAddress();
        if (!this.format.isCreditFormat()) {
            data.setDebitType(this.getString(row, line, this.format.getColumn(Format2.Fields.DEBIT_TYPE), true));
            data.setCreditorId(this.getString(row, line, this.format.getColumn(Format2.Fields.CREDITOR_ID), true));
            data.setMandateId(this.getString(row, line, this.format.getColumn(Format2.Fields.MANDATE_ID), true));
            data.setMandateSignDate(this.getDate(row, line, this.format.getColumn(Format2.Fields.MANDATE_SIGNATURE), true));
            data.setSequenceType(this.getString(row, line, this.format.getColumn(Format2.Fields.SEQUENCE_TYPE), true));
            String debtorStreet = this.getString(row, line, this.format.getColumn(Format2.Fields.RECIPIENT_STREET), false);
            String debtorTown = this.getString(row, line, this.format.getColumn(Format2.Fields.RECIPIENT_TOWN), false);
            String debtorCountryCode = this.getCountryCode(row, line, this.format.getColumn(Format2.Fields.RECIPIENT_COUNTRY), false);
            if (debtorCountryCode == null && !RegularExpressions.COUNTRY_CODE.matches(debtorCountryCode = IbanUtil.getCountryCode(recipientIban))) {
                debtorCountryCode = null;
            }
            data.setRecipientAddressData(this.getCompleteAddress(debtorStreet, debtorTown, debtorCountryCode, createStructuredAddress));
        } else {
            String bankName;
            String origStreet = this.getString(row, line, this.format.getColumn(Format2.Fields.ORIGINATOR_STREET), false);
            String origTown = this.getString(row, line, this.format.getColumn(Format2.Fields.ORIGINATOR_TOWN), false);
            String origCountryCode = this.getCountryCode(row, line, this.format.getColumn(Format2.Fields.ORIGINATOR_COUNTRY), false);
            if (origCountryCode == null && !RegularExpressions.COUNTRY_CODE.matches(origCountryCode = IbanUtil.getCountryCode(originatorIban))) {
                origCountryCode = null;
            }
            if (this.createInternationalPayments) {
                data.setOriginatorAddressData(this.getAddress(origStreet, origTown, origCountryCode, createStructuredAddress));
            } else {
                data.setOriginatorAddressData(this.getCompleteAddress(origStreet, origTown, origCountryCode, createStructuredAddress));
            }
            String recipientStreet = this.getString(row, line, this.format.getColumn(Format2.Fields.RECIPIENT_STREET), false);
            String recipientTown = this.getString(row, line, this.format.getColumn(Format2.Fields.RECIPIENT_TOWN), false);
            String recipientCountryCode = this.getCountryCode(row, line, this.format.getColumn(Format2.Fields.RECIPIENT_COUNTRY), this.createInternationalPayments);
            data.setRecipientAddressData(this.getAddress(recipientStreet, recipientTown, recipientCountryCode, createStructuredAddress));
            if (this.createInternationalPayments && (bankName = StringUtils.checkNullAndTrim(this.getString(row, line, this.format.getColumn(Format2.Fields.BANK_NAME), false))).length() > 0) {
                data.setRecipientBankName(bankName);
                String bankStreet = this.getString(row, line, this.format.getColumn(Format2.Fields.BANK_STREET), false);
                String bankTown = this.getString(row, line, this.format.getColumn(Format2.Fields.BANK_TOWN), false);
                String bankCountryCode = this.getCountryCode(row, line, this.format.getColumn(Format2.Fields.BANK_COUNTRY), false);
                data.setRecipientBankAddressData(this.getAddress(bankStreet, bankTown, bankCountryCode, createStructuredAddress));
            }
        }
        if (this.createInstantPayments) {
            data.setLocalInstrument(SEPALocalInstrument.INST.name());
        }
        return data;
    }

    private AddressData getAddress(String street, String town, String countryCode, boolean structured) {
        if ((countryCode = StringUtils.checkNullAndTrim(countryCode)).length() > 0) {
            if (structured) {
                return AddressData.getStructuredAddress(street, town, countryCode);
            }
            AddressData address = new AddressData();
            address.setCountry(countryCode);
            street = StringUtils.checkNullAndTrim(street);
            town = StringUtils.checkNullAndTrim(town);
            if (town.length() > 0) {
                address.getAddressLines().add(town);
            }
            if (street.length() > 0) {
                address.getAddressLines().add(street);
            }
            return address;
        }
        return null;
    }

    private AddressData getCompleteAddress(String street, String town, String countryCode, boolean structured) {
        if (structured) {
            return this.getAddress(street, town, countryCode, structured);
        }
        street = StringUtils.checkNullAndTrim(street);
        town = StringUtils.checkNullAndTrim(town);
        countryCode = StringUtils.checkNullAndTrim(countryCode);
        if (street.length() > 0 && town.length() > 0 && countryCode.length() > 0) {
            AddressData address = new AddressData();
            address.getAddressLines().add(street);
            address.getAddressLines().add(town);
            address.setCountry(countryCode);
            return address;
        }
        return null;
    }
}

