/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.csv;

import de.businesslogics.format.csv.Column;
import de.businesslogics.format.csv.FormatI;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.csv.ColumnHandler;
import de.businesslogics.format.sepa.csv.FieldI;
import de.businesslogics.validation.RegularExpressions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;

public class Format2
implements FormatI {
    private static final String FORMATS = "formats";
    private static final String LANGUAGE = "language";
    public static final String SEPARATOR = "|";
    protected NumberFormat numberFormat = null;
    public static Format2 DEFAULT_CREDIT = new Format2(Fields.ORIGINATOR_NAME, Fields.CATEGORY_PURPOSE, Fields.DATE, Fields.ORIGINATOR_IBAN, Fields.ORIGINATOR_BIC, Fields.END_TO_END, Fields.AMOUNT, Fields.ULTIMATE_ORIGINATOR, Fields.RECIPIENT_BIC, Fields.RECIPIENT_NAME, Fields.RECIPIENT_IBAN, Fields.ULTIMATE_RECIPIENT, Fields.PURPOSE, Fields.SINGLE_BOOKING, Fields.PURPOSE_CODE, Fields.ORIGINATOR_STREET, Fields.ORIGINATOR_TOWN, Fields.ORIGINATOR_COUNTRY, Fields.PURPOSE_REFERENCE, Fields.RECIPIENT_STREET, Fields.RECIPIENT_TOWN, Fields.RECIPIENT_COUNTRY).add(Fields.CREDIT_TYPE, new Column("SEPA", Fields.CREDIT_TYPE.name(), Fields.CREDIT_TYPE.maxLength, Fields.CREDIT_TYPE.pattern));
    public static Format2 DEFAULT_PAIN_001_INTERNATIONAL = new Format2(Fields.ORIGINATOR_NAME, Fields.ORIGINATOR_STREET, Fields.ORIGINATOR_TOWN, Fields.ORIGINATOR_COUNTRY, Fields.ORIGINATOR_IBAN, Fields.ORIGINATOR_BIC, Fields.ACCOUNT_CURRENCY, Fields.RECIPIENT_NAME, Fields.RECIPIENT_STREET, Fields.RECIPIENT_TOWN, Fields.RECIPIENT_COUNTRY, Fields.RECIPIENT_IBAN, Fields.RECIPIENT_BIC, Fields.CLEARING_SYSTEM_ID, Fields.BANK_NAME, Fields.BANK_STREET, Fields.BANK_TOWN, Fields.BANK_COUNTRY, Fields.AMOUNT, Fields.CURRENCY, Fields.DATE, Fields.PURPOSE, Fields.END_TO_END, Fields.CATEGORY_PURPOSE, Fields.PURPOSE_CODE, Fields.CHARGE_BEARER, Fields.INSTRUCTION_PRIORITY, Fields.CREDIT_TYPE);
    public static Format2 DEFAULT_DEBIT = new Format2(Fields.ORIGINATOR_NAME, Fields.CATEGORY_PURPOSE, Fields.SEQUENCE_TYPE, Fields.DATE, Fields.ORIGINATOR_IBAN, Fields.ORIGINATOR_BIC, Fields.END_TO_END, Fields.AMOUNT, Fields.MANDATE_ID, Fields.MANDATE_SIGNATURE, Fields.CREDITOR_ID, Fields.ULTIMATE_ORIGINATOR, Fields.RECIPIENT_BIC, Fields.RECIPIENT_NAME, Fields.RECIPIENT_IBAN, Fields.ULTIMATE_RECIPIENT, Fields.PURPOSE, Fields.SINGLE_BOOKING, Fields.PURPOSE_CODE, Fields.RECIPIENT_STREET, Fields.RECIPIENT_TOWN, Fields.RECIPIENT_COUNTRY, Fields.PURPOSE_REFERENCE).add(Fields.DEBIT_TYPE, new Column("CORE", Fields.DEBIT_TYPE.name(), Fields.DEBIT_TYPE.maxLength, Fields.DEBIT_TYPE.pattern));
    private boolean invertBatchBooking = false;
    private GeneralSEPAWriter.Version sepaVersion;
    private final Map<Fields, Column> mapping = new HashMap<Fields, Column>();
    private int minimum = -1;
    private boolean createInternationalPayments = false;
    private int leadTimeforDirectDebits = 1;
    private boolean createSwissDomesticPayments = false;
    private boolean createInstantPayments = false;
    private Boolean defaultBatchBooking = null;

    @Override
    public boolean isBicMandatory() {
        if (this.createInternationalPayments) {
            return false;
        }
        switch (this.sepaVersion) {
            case V24: 
            case V25: 
            case V24Iso: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDifferingCurrencyAllowed() {
        switch (this.sepaVersion) {
            case V24Iso: 
            case V25Iso: 
            case V30Ch: 
            case Iso00100109: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSCTInstAllowed() {
        switch (this.sepaVersion) {
            case V25Iso: 
            case Iso00100109: 
            case Iso00100108: 
            case V30: {
                return true;
            }
        }
        return false;
    }

    public GeneralSEPAWriter.Version getSepaVersion() {
        return this.sepaVersion;
    }

    public void setSepaVersion(GeneralSEPAWriter.Version sepaVersion) {
        this.sepaVersion = sepaVersion;
    }

    @Override
    public Column getColumn(FieldI field) {
        return this.mapping.get(field);
    }

    public boolean createInternationalPayments() {
        return this.createInternationalPayments;
    }

    public void setCreateInternationalPayments(boolean createInternationalPayments) {
        this.createInternationalPayments = createInternationalPayments;
    }

    public int getLeadTimeforDirectDebits() {
        return this.leadTimeforDirectDebits;
    }

    public void setLeadTimeforDirectDebits(int leadTimeforDirectDebits) {
        this.leadTimeforDirectDebits = leadTimeforDirectDebits;
    }

    public boolean createSwissDomesticPayments() {
        return this.createSwissDomesticPayments;
    }

    public void setCreateSwissDomesticPayments(boolean createSwissDomesticPayments) {
        this.createSwissDomesticPayments = createSwissDomesticPayments;
    }

    public void setCreateInstantPayments(boolean createInstantPayments) {
        this.createInstantPayments = createInstantPayments;
    }

    public boolean isCreateInstantPayments() {
        return this.createInstantPayments;
    }

    public void setCreditType(String creditType) {
        Column column = new Column(creditType, Fields.CREDIT_TYPE.name(), Fields.CREDIT_TYPE.maxLength, Fields.CREDIT_TYPE.pattern);
        this.add(Fields.CREDIT_TYPE, column);
    }

    public void setDebitType(String debitType) {
        Column column = new Column(debitType, Fields.DEBIT_TYPE.name(), Fields.DEBIT_TYPE.maxLength, Fields.DEBIT_TYPE.pattern);
        this.add(Fields.DEBIT_TYPE, column);
    }

    private Format2 add(Fields field, Column column) {
        this.mapping.put(field, column);
        return this;
    }

    private Format2(Fields ... fields) {
        for (int i = 0; i < fields.length; ++i) {
            Fields field = fields[i];
            this.mapping.put(field, new Column(i, field.name(), field.maxLength, field.pattern));
        }
    }

    @Override
    public String getAmountString(String s) {
        if (s == null) {
            return "";
        }
        if (this.numberFormat != null) {
            try {
                Number n = this.numberFormat.parse(s);
                return n.toString();
            }
            catch (ParseException pe) {
                return "";
            }
        }
        if (s.contains(",")) {
            s = s.replace(',', '.');
        }
        return s;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Fields f : Fields.values()) {
            Column c = this.mapping.get(f);
            if (c != null) {
                if (b.length() > 0) {
                    b.append(SEPARATOR);
                }
                if (c.getValue() != null) {
                    b.append("=");
                    b.append(c.getValue());
                    continue;
                }
                b.append(c.getColumnIndex());
                continue;
            }
            b.append(SEPARATOR);
        }
        return b.toString();
    }

    @Override
    public int minimumColumns() {
        if (this.minimum < 0) {
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.ORIGINATOR_NAME).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.ORIGINATOR_IBAN).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.AMOUNT).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.RECIPIENT_NAME).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get(Fields.RECIPIENT_IBAN).getColumnIndex());
            Column c = this.mapping.get(Fields.CREDIT_TYPE);
            if (c != null) {
                this.minimum = Math.max(this.minimum, c.getColumnIndex());
            }
            if ((c = this.mapping.get(Fields.MANDATE_ID)) != null) {
                this.minimum = Math.max(this.minimum, c.getColumnIndex());
            }
            if ((c = this.mapping.get(Fields.MANDATE_SIGNATURE)) != null) {
                this.minimum = Math.max(this.minimum, c.getColumnIndex());
            }
            if ((c = this.mapping.get(Fields.CREDITOR_ID)) != null) {
                this.minimum = Math.max(this.minimum, c.getColumnIndex());
            }
        }
        return this.minimum;
    }

    @Override
    public boolean isCreditFormat() {
        Column column = this.mapping.get(Fields.CREDIT_TYPE);
        return column != null;
    }

    public Format2(String definition, String language, ColumnHandler h) {
        String[] columns;
        if (language != null) {
            this.numberFormat = NumberFormat.getInstance(new Locale(language));
        }
        if ((columns = definition.split("\\|")) == null || columns.length <= 1) {
            columns = definition.split(",");
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].length() <= 0) continue;
            Fields f = Fields.values()[i];
            if (columns[i].startsWith("=")) {
                this.mapping.put(f, new Column(columns[i].substring(1), f.name(), f.maxLength, f.pattern));
                continue;
            }
            try {
                this.mapping.put(f, new Column(Integer.parseInt(columns[i]), f.name(), f.maxLength, f.pattern));
                continue;
            }
            catch (NumberFormatException nf) {
                if (h == null) continue;
                this.mapping.put(f, new Column(h.convertColStringToIndex(columns[i]), f.name(), f.maxLength, f.pattern));
            }
        }
    }

    public boolean isInvertBatchBooking() {
        return this.invertBatchBooking;
    }

    public void setInvertBatchBooking(boolean invertBatchBooking) {
        this.invertBatchBooking = invertBatchBooking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Format2> parseFile(File in, ColumnHandler h) throws IOException {
        String[] toReturn = new ArrayList();
        try (FileInputStream fi = null;){
            Properties p = new Properties();
            fi = new FileInputStream(in);
            p.load(fi);
            String formats = p.getProperty(FORMATS);
            String language = p.getProperty(LANGUAGE);
            if (formats != null) {
                String[] fo = formats.split(",");
                if (fo != null && fo.length > 0) {
                    for (String f : fo) {
                        toReturn.add(new Format2(f.trim(), language, null));
                    }
                }
                String[] stringArray = toReturn;
                return stringArray;
            }
        }
        Format2 current = null;
        try (Scanner s = new Scanner(in);){
            while (s.hasNextLine()) {
                String line = s.nextLine();
                if (line == null || line.trim().isEmpty()) continue;
                if (line.startsWith("[")) {
                    current = new Format2(new Fields[0]);
                    toReturn.add(current);
                    continue;
                }
                if (line.startsWith("#")) continue;
                int div = line.indexOf(61);
                String key = div > 0 ? line.substring(0, div).trim() : line;
                String value = div > 0 ? line.substring(div + 1) : null;
                Fields f = Fields.valueOf(key);
                if (value != null && value.startsWith("=")) {
                    current.mapping.put(f, new Column(value.substring(1), f.name(), f.maxLength, f.pattern));
                    continue;
                }
                int c = Integer.parseInt(value);
                current.mapping.put(f, new Column(c, f.name(), f.maxLength, f.pattern));
            }
        }
        return toReturn;
    }

    public Boolean isDefaultBatchBooking() {
        return this.defaultBatchBooking;
    }

    public void setDefaultBatchBooking(Boolean defaultBatchBooking) {
        this.defaultBatchBooking = defaultBatchBooking;
    }

    public static enum Fields implements Serializable,
    FieldI
    {
        ORIGINATOR_NAME(70),
        ORIGINATOR_IBAN(RegularExpressions.IBAN),
        AMOUNT(-1),
        RECIPIENT_NAME(70),
        RECIPIENT_IBAN(RegularExpressions.IBAN),
        ORIGINATOR_BIC(RegularExpressions.BIC),
        ULTIMATE_ORIGINATOR(70),
        RECIPIENT_BIC(RegularExpressions.BIC),
        ULTIMATE_RECIPIENT(70),
        DATE(-1),
        CATEGORY_PURPOSE(4),
        END_TO_END(35),
        PURPOSE(140),
        SINGLE_BOOKING(-1),
        CREDIT_TYPE(4),
        MANDATE_ID(35),
        MANDATE_SIGNATURE(-1),
        CREDITOR_ID(RegularExpressions.SEPA_CREDITOR_ID),
        SEQUENCE_TYPE(4),
        DEBIT_TYPE(4),
        PURPOSE_CODE(4),
        RECIPIENT_STREET(70),
        RECIPIENT_TOWN(70),
        RECIPIENT_COUNTRY(2),
        INSTRUCTION_ID(35),
        CURRENCY(3),
        ACCOUNT_CURRENCY(3),
        ORIGINATOR_STREET(70),
        ORIGINATOR_TOWN(70),
        ORIGINATOR_COUNTRY(2),
        INSTRUCTION_PRIORITY(4),
        CHARGE_BEARER(4),
        BANK_NAME(70),
        BANK_STREET(70),
        BANK_TOWN(70),
        BANK_COUNTRY(2),
        CLEARING_SYSTEM_ID(35),
        PURPOSE_REFERENCE(35);

        private int maxLength = -1;
        private RegularExpressions pattern;

        private Fields(int maxLength) {
            this.maxLength = maxLength;
        }

        private Fields(RegularExpressions pattern) {
            this.pattern = pattern;
        }
    }
}

