/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.csv;

import de.businesslogics.format.AddressData;
import de.businesslogics.format.csv.BaseFormat;
import de.businesslogics.format.csv.CSVConverterException;
import de.businesslogics.format.csv.Column;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellReference;

public class Format
extends BaseFormat {
    public static final String SEPARATOR = "|";
    public static Format DEFAULT_CREDIT = new Format(Fields.ORIGINATOR_NAME, Fields.CATEGORY_PURPOSE, Fields.DATE, Fields.ORIGINATOR_IBAN, Fields.ORIGINATOR_BIC, Fields.END_TO_END, Fields.AMOUNT, Fields.ULTIMATE_ORIGINATOR, Fields.RECIPIENT_BIC, Fields.RECIPIENT_NAME, Fields.RECIPIENT_IBAN, Fields.ULTIMATE_RECIPIENT, Fields.PURPOSE, Fields.SINGLE_BOOKING, Fields.PURPOSE_CODE, Fields.PURPOSE_REFERENCE).add(Fields.CREDIT_TYPE, new Column("SEPA", Fields.CREDIT_TYPE.name(), Fields.CREDIT_TYPE.maxLength, Fields.CREDIT_TYPE.pattern));
    public static Format DEFAULT_DEBIT = new Format(Fields.ORIGINATOR_NAME, Fields.CATEGORY_PURPOSE, Fields.SEQUENCE_TYPE, Fields.DATE, Fields.ORIGINATOR_IBAN, Fields.ORIGINATOR_BIC, Fields.END_TO_END, Fields.AMOUNT, Fields.MANDATE_ID, Fields.MANDATE_SIGNATURE, Fields.CREDITOR_ID, Fields.ULTIMATE_ORIGINATOR, Fields.RECIPIENT_BIC, Fields.RECIPIENT_NAME, Fields.RECIPIENT_IBAN, Fields.ULTIMATE_RECIPIENT, Fields.PURPOSE, Fields.SINGLE_BOOKING, Fields.PURPOSE_CODE, Fields.RECIPIENT_STREET, Fields.RECIPIENT_TOWN, Fields.RECIPIENT_COUNTRY, Fields.PURPOSE_REFERENCE).add(Fields.DEBIT_TYPE, new Column("CORE", Fields.DEBIT_TYPE.name(), Fields.DEBIT_TYPE.maxLength, Fields.DEBIT_TYPE.pattern));
    private final Map<Fields, Column> mapping = new HashMap<Fields, Column>();
    private int minimum = -1;
    private GeneralSEPAWriter.Version sepaVersion;
    private boolean createInstantPayments = false;

    public Column getColumn(Fields field) {
        return this.mapping.get((Object)field);
    }

    public GeneralSEPAWriter.Version getSepaVersion() {
        return this.sepaVersion;
    }

    public void setSepaVersion(GeneralSEPAWriter.Version sepaVersion) {
        this.sepaVersion = sepaVersion;
    }

    public void setCreateInstantPayments(boolean createInstantPayments) {
        this.createInstantPayments = createInstantPayments;
    }

    public void setCreditType(String creditType) {
        Column column = new Column(creditType, Fields.CREDIT_TYPE.name(), Fields.CREDIT_TYPE.maxLength, Fields.CREDIT_TYPE.pattern);
        this.add(Fields.CREDIT_TYPE, column);
    }

    public void setDebitType(String debitType) {
        Column column = new Column(debitType, Fields.DEBIT_TYPE.name(), Fields.DEBIT_TYPE.maxLength, Fields.DEBIT_TYPE.pattern);
        this.add(Fields.DEBIT_TYPE, column);
    }

    private Format add(Fields field, Column column) {
        this.mapping.put(field, column);
        return this;
    }

    private Format(Fields ... fields) {
        for (int i = 0; i < fields.length; ++i) {
            Fields field = fields[i];
            this.mapping.put(field, new Column(i, field.name(), field.maxLength, field.pattern));
        }
    }

    public Format(String definition, String language) {
        String[] columns;
        if (language != null) {
            this.numberFormat = NumberFormat.getInstance(new Locale(language));
        }
        if ((columns = definition.split("\\|")) == null || columns.length <= 1) {
            columns = definition.split(",");
        }
        int countFieldsOldConverter = Fields.values().length;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].length() <= 0 || i >= countFieldsOldConverter) continue;
            Fields f = Fields.values()[i];
            if (columns[i].startsWith("=")) {
                this.mapping.put(f, new Column(columns[i].substring(1), f.name(), f.maxLength, f.pattern));
                continue;
            }
            try {
                this.mapping.put(f, new Column(Integer.parseInt(columns[i]), f.name(), f.maxLength, f.pattern));
                continue;
            }
            catch (NumberFormatException nf) {
                this.mapping.put(f, new Column(CellReference.convertColStringToIndex((String)columns[i]), f.name(), f.maxLength, f.pattern));
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Fields f : Fields.values()) {
            Column c = this.mapping.get((Object)f);
            if (c != null) {
                if (b.length() > 0) {
                    b.append(SEPARATOR);
                }
                if (c.getValue() != null) {
                    b.append("=");
                    b.append(c.getValue());
                    continue;
                }
                b.append(c.getColumnIndex());
                continue;
            }
            b.append(SEPARATOR);
        }
        return b.toString();
    }

    @Override
    protected int minimumColumns() {
        if (this.minimum < 0) {
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.ORIGINATOR_NAME).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.ORIGINATOR_IBAN).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.AMOUNT).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.RECIPIENT_NAME).getColumnIndex());
            this.minimum = Math.max(this.minimum, this.mapping.get((Object)Fields.RECIPIENT_IBAN).getColumnIndex());
            Column c = this.mapping.get((Object)Fields.CREDIT_TYPE);
            if (c != null) {
                this.minimum = Math.max(this.minimum, c.getColumnIndex());
            }
            if ((c = this.mapping.get((Object)Fields.MANDATE_ID)) != null) {
                this.minimum = Math.max(this.minimum, c.getColumnIndex());
            }
            if ((c = this.mapping.get((Object)Fields.MANDATE_SIGNATURE)) != null) {
                this.minimum = Math.max(this.minimum, c.getColumnIndex());
            }
            if ((c = this.mapping.get((Object)Fields.CREDITOR_ID)) != null) {
                this.minimum = Math.max(this.minimum, c.getColumnIndex());
            }
        }
        return this.minimum;
    }

    @Override
    protected String validateRow(Row row, String[] row2) {
        String error = this.checkAmount(row, row2, this.mapping.get((Object)Fields.AMOUNT));
        if (error != null) {
            return error;
        }
        error = this.checkString(row, row2, this.mapping.get((Object)Fields.ORIGINATOR_IBAN), RegularExpressions.IBAN);
        if (error != null) {
            return error;
        }
        error = this.checkString(row, row2, this.mapping.get((Object)Fields.RECIPIENT_IBAN), RegularExpressions.IBAN);
        if (error != null) {
            return error;
        }
        if (this.isBicMandatory()) {
            error = this.checkString(row, row2, this.mapping.get((Object)Fields.ORIGINATOR_BIC), RegularExpressions.BIC);
            if (error != null) {
                return error;
            }
            error = this.checkString(row, row2, this.mapping.get((Object)Fields.RECIPIENT_BIC), RegularExpressions.BIC);
            if (error != null) {
                return error;
            }
        }
        if ((error = this.checkString(row, row2, this.mapping.get((Object)Fields.CREDITOR_ID), RegularExpressions.SEPA_CREDITOR_ID)) != null) {
            return error;
        }
        error = this.checkDate(row, row2, this.mapping.get((Object)Fields.DATE));
        if (error != null) {
            return error;
        }
        error = this.checkDate(row, row2, this.mapping.get((Object)Fields.MANDATE_SIGNATURE));
        if (error != null) {
            return error;
        }
        return null;
    }

    @Override
    protected String getValidString(String s, int maxFieldLength) {
        return SEPAUtil.getSEPAString(s, maxFieldLength, GeneralSEPAWriter.DEFAULT_VERSION);
    }

    @Override
    public boolean isCreditFormat() {
        Column column = this.mapping.get((Object)Fields.CREDIT_TYPE);
        return column != null;
    }

    private boolean isBicMandatory() {
        switch (this.sepaVersion) {
            case V24: 
            case V25: 
            case V24Iso: {
                return true;
            }
        }
        return false;
    }

    public SEPAPaymentData getPaymentData(Row row) throws CSVConverterException {
        return this.getPaymentData(row, null, row.getRowNum());
    }

    public SEPAPaymentData getPaymentData(String[] row, int line) throws CSVConverterException {
        return this.getPaymentData(null, row, line);
    }

    private SEPAPaymentData getPaymentData(Row row, String[] row2, int line) throws CSVConverterException {
        String countryCode;
        String town;
        SEPAPaymentData data = new SEPAPaymentData();
        data.setOriginator(this.getString(row, row2, line, this.mapping.get((Object)Fields.ORIGINATOR_NAME), true));
        data.setUltimateOriginator(this.getString(row, row2, line, this.mapping.get((Object)Fields.ULTIMATE_ORIGINATOR), false));
        data.setOriginatorIban(this.getString(row, row2, line, this.mapping.get((Object)Fields.ORIGINATOR_IBAN), true));
        data.setOriginatorBic(this.getString(row, row2, line, this.mapping.get((Object)Fields.ORIGINATOR_BIC), false));
        if (this.isCreditFormat()) {
            data.setServiceLevel(this.getString(row, row2, line, this.mapping.get((Object)Fields.CREDIT_TYPE), false));
        } else {
            data.setDebitType(this.getString(row, row2, line, this.mapping.get((Object)Fields.DEBIT_TYPE), true));
            data.setCreditorId(this.getString(row, row2, line, this.mapping.get((Object)Fields.CREDITOR_ID), true));
            data.setMandateId(this.getString(row, row2, line, this.mapping.get((Object)Fields.MANDATE_ID), true));
            data.setMandateSignDate(this.getDate(row, row2, line, this.mapping.get((Object)Fields.MANDATE_SIGNATURE), true));
            data.setSequenceType(this.getString(row, row2, line, this.mapping.get((Object)Fields.SEQUENCE_TYPE), true));
        }
        data.setRecipient(this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_NAME), true));
        data.setUltimateRecipient(this.getString(row, row2, line, this.mapping.get((Object)Fields.ULTIMATE_RECIPIENT), false));
        data.setRecipientIban(this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_IBAN), true));
        data.setRecipientBic(this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_BIC), false));
        data.setAmount(this.getAmount(row, row2, line, this.mapping.get((Object)Fields.AMOUNT)));
        String strPurp = this.getString(row, row2, line, this.mapping.get((Object)Fields.PURPOSE_REFERENCE), false);
        if (strPurp != null && !strPurp.isEmpty()) {
            data.setHasStructuredPurpose(true);
            data.setPurposeReferenceTypeCode("SCOR");
            data.setPurposeReference(strPurp);
        } else {
            data.setPurpose(this.getString(row, row2, line, this.mapping.get((Object)Fields.PURPOSE), false));
        }
        data.setPurposeCode(this.getString(row, row2, line, this.mapping.get((Object)Fields.PURPOSE_CODE), false));
        data.setPaymentCategory(this.getString(row, row2, line, this.mapping.get((Object)Fields.CATEGORY_PURPOSE), false));
        data.setExecutionDate(this.getDate(row, row2, line, this.mapping.get((Object)Fields.DATE), false));
        if (data.getExecutionDate() == null) {
            data.setExecutionDate(SEPAUtil.getEarliestExecutionDate(this.sepaVersion, this.isCreditFormat(), data.getDebitType(), data.getSequenceType(), 1));
        }
        data.setEndToEndId(this.getString(row, row2, line, this.mapping.get((Object)Fields.END_TO_END), false));
        data.setDisplayAsSingleBooking(this.getBoolean(row, row2, this.mapping.get((Object)Fields.SINGLE_BOOKING), false));
        AddressData recipientAddress = null;
        String street = this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_STREET), false);
        if (!StringUtils.isEmpty(street)) {
            if (recipientAddress == null) {
                recipientAddress = new AddressData();
            }
            recipientAddress.getAddressLines().add(street);
        }
        if (!StringUtils.isEmpty(town = this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_TOWN), false))) {
            if (recipientAddress == null) {
                recipientAddress = new AddressData();
            }
            recipientAddress.getAddressLines().add(town);
        }
        if (!StringUtils.isEmpty(countryCode = this.getString(row, row2, line, this.mapping.get((Object)Fields.RECIPIENT_COUNTRY), false))) {
            if (recipientAddress == null) {
                recipientAddress = new AddressData();
            }
            recipientAddress.setCountry(countryCode);
        }
        data.setRecipientAddressData(recipientAddress);
        if (this.createInstantPayments) {
            data.setLocalInstrument(SEPALocalInstrument.INST.name());
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Format> parseFile(File in) throws IOException {
        ArrayList<Format> toReturn;
        block9: {
            toReturn = new ArrayList<Format>();
            Format current = null;
            Scanner s = new Scanner(in);
            block5: while (true) {
                while (s.hasNextLine()) {
                    String line = s.nextLine();
                    if (line == null || line.trim().isEmpty()) continue;
                    if (line.startsWith("[")) {
                        current = new Format(new Fields[0]);
                        toReturn.add(current);
                        continue;
                    }
                    int div = line.indexOf(61);
                    String key = div > 0 ? line.substring(0, div).trim() : line;
                    String value = div > 0 ? line.substring(div + 1) : null;
                    Fields f = Fields.valueOf(key);
                    if (value.startsWith("=")) {
                        current.mapping.put(f, new Column(value.substring(1), f.name(), f.maxLength, f.pattern));
                        continue;
                    }
                    try {
                        int c = Integer.parseInt(value);
                        current.mapping.put(f, new Column(c, f.name(), f.maxLength, f.pattern));
                        continue block5;
                    }
                    catch (NumberFormatException nf) {
                        current.mapping.put(f, new Column(CellReference.convertColStringToIndex((String)value), f.name(), f.maxLength, f.pattern));
                    }
                }
                break block9;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                s.close();
            }
        }
        return toReturn;
    }

    public static enum Fields {
        ORIGINATOR_NAME(70),
        ORIGINATOR_IBAN(RegularExpressions.IBAN),
        AMOUNT(-1),
        RECIPIENT_NAME(70),
        RECIPIENT_IBAN(RegularExpressions.IBAN),
        ORIGINATOR_BIC(RegularExpressions.BIC),
        ULTIMATE_ORIGINATOR(70),
        RECIPIENT_BIC(RegularExpressions.BIC),
        ULTIMATE_RECIPIENT(70),
        DATE(-1),
        CATEGORY_PURPOSE(4),
        END_TO_END(35),
        PURPOSE(140),
        SINGLE_BOOKING(-1),
        CREDIT_TYPE(4),
        MANDATE_ID(RegularExpressions.SEPA_RESTRICTED_IDENTIFICATION_1),
        MANDATE_SIGNATURE(-1),
        CREDITOR_ID(RegularExpressions.SEPA_CREDITOR_ID),
        SEQUENCE_TYPE(4),
        DEBIT_TYPE(4),
        PURPOSE_CODE(4),
        RECIPIENT_STREET(70),
        RECIPIENT_TOWN(70),
        RECIPIENT_COUNTRY(2),
        PURPOSE_REFERENCE(35);

        private int maxLength = -1;
        private RegularExpressions pattern;

        private Fields(int maxLength) {
            this.maxLength = maxLength;
        }

        private Fields(RegularExpressions pattern) {
            this.pattern = pattern;
        }
    }
}

