/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.csv;

import de.businesslogics.format.csv.CSVConverterException;
import de.businesslogics.format.csv.CSVConverterUtil;
import de.businesslogics.format.csv.XLSUtil;
import de.businesslogics.format.sepa.ConverterConfiguration;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.csv.CSVConverter;
import de.businesslogics.format.sepa.csv.Format2;
import de.businesslogics.format.sepa.csv.SepaCSVFormatParser;
import de.businesslogics.format.sepa.csv.SepaXLSFormatParser;
import de.businesslogics.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.xml.sax.SAXException;

public class Converter2
extends CSVConverter {
    private static final int MAX_MESSAGES_TO_DISPLAY = 10;

    public Converter2() {
        this.UI_FRAME = new JFrame("XLS Converter");
        this.UI_FRAME.setDefaultCloseOperation(3);
    }

    public Converter2(boolean noGUI) {
        if (!noGUI) {
            this.UI_FRAME = new JFrame("XLS Converter");
            this.UI_FRAME.setDefaultCloseOperation(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void convertFile(File f, List<Format2> formats, File out, String baseId, GeneralSEPAWriter.Version sepaVersion) throws IOException, SAXException {
        try (Workbook workbook = null;){
            workbook = XLSUtil.createWorkbook(f);
            Object invalidSheets = null;
            ArrayList<Object> errorMessages = null;
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                int row;
                Sheet sheet = workbook.getSheetAt(i);
                String sheetName = sheet.getSheetName();
                Format2 format = null;
                block6: for (row = sheet.getFirstRowNum(); row <= sheet.getLastRowNum(); ++row) {
                    String formatError = null;
                    Row r = sheet.getRow(row);
                    if (r == null) continue;
                    for (Format2 fo : formats) {
                        SepaXLSFormatParser p = new SepaXLSFormatParser(fo);
                        fo.setSepaVersion(sepaVersion);
                        formatError = p.checkRow(r);
                        if (formatError == null) {
                            format = fo;
                            break block6;
                        }
                        if (errorMessages == null) {
                            errorMessages = new ArrayList<Object>();
                        }
                        if (errorMessages.size() < 10) {
                            errorMessages.add("Sheet " + sheetName + ", row " + (row + 1) + ": " + formatError);
                            continue;
                        }
                        if (errorMessages.size() != 10) continue;
                        errorMessages.add("...");
                    }
                }
                if (format != null) {
                    this.convert(sheet, row, format, Converter2.buildOutputFile(f, out, sheetName), baseId);
                    continue;
                }
                if (this.UI_FRAME == null) {
                    throw new IOException("Unknown file-format - The format of sheet '" + sheetName + "' of file " + f.getAbsolutePath() + " is not known.\n" + StringUtils.getStringFromStringList(errorMessages, "\n"));
                }
                invalidSheets = invalidSheets == null ? sheetName : (String)invalidSheets + ", " + sheetName;
            }
            if (invalidSheets != null) {
                this.showWarning("Unknown file format", "Unknown format of file '" + f.getAbsolutePath() + "':\n" + StringUtils.getStringFromStringList(errorMessages, "\n"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkXLS(File f, Format2 format, boolean hasHeader) {
        Workbook workbook = null;
        SepaXLSFormatParser p = new SepaXLSFormatParser(format);
        try {
            workbook = XLSUtil.createWorkbook(f);
        }
        catch (Exception format1) {
            int n = -1;
            return n;
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        block11: for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            boolean hasReadHeader;
            Sheet sheet = workbook.getSheetAt(i);
            boolean bl = hasReadHeader = !hasHeader;
            for (int row = sheet.getFirstRowNum(); row <= sheet.getLastRowNum(); ++row) {
                Row r = sheet.getRow(row);
                if (r == null) continue;
                if (p.checkRow(r) == null) {
                    return i;
                }
                if (hasReadHeader) continue block11;
                hasReadHeader = true;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertXLS(File f, int sheetIndex, File out, Format2 format, boolean hasHeader, String baseId) throws IOException, SAXException {
        int startRow;
        Workbook workbook = XLSUtil.createWorkbook(f);
        SepaXLSFormatParser p = new SepaXLSFormatParser(format);
        if (sheetIndex < 0 || sheetIndex >= workbook.getNumberOfSheets()) {
            throw new IOException("No sheet with index = " + sheetIndex);
        }
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        ArrayList<SEPAPaymentData> datas = new ArrayList<SEPAPaymentData>();
        boolean hasReadHeader = !hasHeader;
        for (int i = startRow = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            if (!hasReadHeader) {
                hasReadHeader = true;
                if (p.checkRow(row) != null) continue;
            }
            if (XLSUtil.isEmpty(row)) continue;
            datas.add(ConverterConfiguration.setDefaultCurrency(p.getPaymentData(row)));
        }
        try (FileOutputStream fout = null;){
            fout = new FileOutputStream(out);
            Converter2.writeFile(datas, fout, baseId, format.getSepaVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertCSVFile(File in, File out, Format2 format, boolean hasHeader, String baseId, String encoding) throws IOException, SAXException {
        boolean hasReadHeader = !hasHeader;
        Charset charset = Converter2.getCharset(encoding);
        BufferedReader r = charset != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in), charset)) : new BufferedReader(new FileReader(in));
        ArrayList<SEPAPaymentData> datas = new ArrayList<SEPAPaymentData>();
        String line = r.readLine();
        int lineCounter = 0;
        SepaCSVFormatParser p = new SepaCSVFormatParser(format);
        while (line != null) {
            ++lineCounter;
            if (line.trim().length() > 0) {
                String[] row = CSVConverterUtil.splitLineAndTrim(line);
                if (!hasReadHeader) {
                    hasReadHeader = true;
                    if (p.checkRow(row) != null) {
                        line = r.readLine();
                        continue;
                    }
                }
                datas.add(p.getPaymentData(row, lineCounter - 1));
            }
            line = r.readLine();
        }
        r.close();
        try (FileOutputStream fout = null;){
            fout = new FileOutputStream(out);
            Converter2.writeFile(datas, fout, baseId, format.getSepaVersion());
        }
    }

    private static Charset getCharset(String encoding) {
        if (encoding != null) {
            try {
                return Charset.forName(encoding);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convert(Sheet sheet, int startRow, Format2 format, File out, String baseId) throws IOException, CSVConverterException, SAXException {
        ArrayList<SEPAPaymentData> datas = new ArrayList<SEPAPaymentData>();
        SepaXLSFormatParser p = new SepaXLSFormatParser(format);
        ArrayList<Object> errorMessages = null;
        for (int i = startRow; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            String rowError = p.checkRow(row);
            if (rowError == null) {
                datas.add(ConverterConfiguration.setDefaultCurrency(p.getPaymentData(row)));
                continue;
            }
            if (XLSUtil.isEmpty(row)) continue;
            if (errorMessages == null) {
                errorMessages = new ArrayList<Object>();
                errorMessages.add("Invalid row(s) in file '" + baseId + "', sheet '" + sheet.getSheetName() + "':");
                errorMessages.add("Row " + (i + 1) + ": " + rowError);
                continue;
            }
            if (errorMessages.size() < 10) {
                errorMessages.add("Row " + (i + 1) + ": " + rowError);
                continue;
            }
            if (errorMessages.size() != 10) continue;
            errorMessages.add("...");
        }
        if (errorMessages != null) {
            this.showWarning("Invalid Rows", StringUtils.getStringFromStringList(errorMessages, "\n"));
        }
        try (FileOutputStream fout = null;){
            fout = new FileOutputStream(out);
            Converter2.writeFile(datas, fout, baseId, format.getSepaVersion());
        }
    }

    @Override
    protected FilenameFilter getConverterFilter() {
        return new ConverterFilter();
    }

    private static class ConverterFilter
    implements FilenameFilter {
        private ConverterFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".xls") || name.endsWith(".xlsx") || name.endsWith(".csv");
        }
    }
}

