/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.csv;

import de.businesslogics.format.csv.BaseFormat;
import de.businesslogics.format.csv.CSVConverterException;
import de.businesslogics.format.csv.CSVConverterUtil;
import de.businesslogics.format.csv.XLSUtil;
import de.businesslogics.format.sepa.ConverterConfiguration;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.csv.Format;
import de.businesslogics.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.xml.sax.SAXException;

public class Converter {
    private static final int MAX_MESSAGES_TO_DISPLAY = 10;
    private static JFrame UI_FRAME = null;
    private static String systemBaseId = System.getProperty("de.businesslogics.format.sepa.CSVConverter.baseId");

    public static void main(String[] args) {
        boolean noGui = false;
        if (args != null) {
            for (String a : args) {
                if (!"--nogui".equals(a)) continue;
                noGui = true;
            }
        }
        if (!noGui) {
            UI_FRAME = new JFrame("CSV Converter");
            UI_FRAME.setDefaultCloseOperation(3);
        }
        File in = null;
        File out = null;
        if (args != null && args.length >= 1) {
            in = new File(args[0]);
            if (args != null && args.length >= 2) {
                out = new File(args[1]);
            }
        }
        if (in == null) {
            in = new File(".");
        }
        try {
            ConverterConfiguration.checkLicense();
            Converter.doIt(in, out);
        }
        catch (Exception e) {
            Converter.showException("Error occurred", e);
        }
        if (!noGui) {
            UI_FRAME.dispose();
        }
    }

    private static void doIt(File in, File out) throws Exception {
        File dir = in.isDirectory() ? in : in.getParentFile();
        File formatDefinition = new File(dir, "format.txt");
        ArrayList<Format> formats = new ArrayList<Format>();
        if (formatDefinition.exists()) {
            try {
                formats.addAll(Format.parseFile(formatDefinition));
            }
            catch (Exception e) {
                Converter.showException("Error reading format.txt", e);
                return;
            }
        }
        formats.add(Format.DEFAULT_CREDIT);
        formats.add(Format.DEFAULT_DEBIT);
        File[] filesToConvert = null;
        filesToConvert = in.isDirectory() ? in.listFiles(new ConverterFilter()) : new File[]{in};
        if (filesToConvert == null || filesToConvert.length == 0) {
            Converter.showWarning("No files found", "There are no files to convert. Check that there are files in " + in.getAbsolutePath());
            return;
        }
        GeneralSEPAWriter.Version sepaVersion = ConverterConfiguration.getSepaVersion();
        for (File f : filesToConvert) {
            Converter.convertFile(f, formats, out, f.getName(), sepaVersion);
        }
    }

    private static void convertFile(File f, List<Format> formats, File out, String baseId, GeneralSEPAWriter.Version sepaVersion) throws IOException, SAXException {
        try {
            Workbook workbook = XLSUtil.createWorkbook(f);
            Object invalidSheets = null;
            ArrayList<Object> errorMessages = null;
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                int row;
                Sheet sheet = workbook.getSheetAt(i);
                String sheetName = sheet.getSheetName();
                Format format = null;
                block3: for (row = sheet.getFirstRowNum(); row <= sheet.getLastRowNum(); ++row) {
                    String formatError = null;
                    Row r = sheet.getRow(row);
                    if (r == null) continue;
                    for (Format fo : formats) {
                        fo.setSepaVersion(sepaVersion);
                        formatError = fo.checkRow(r);
                        if (formatError == null) {
                            format = fo;
                            break block3;
                        }
                        if (errorMessages == null) {
                            errorMessages = new ArrayList<Object>();
                        }
                        if (errorMessages.size() < 10) {
                            errorMessages.add("Sheet " + sheetName + ", row " + (row + 1) + ": " + formatError);
                            continue;
                        }
                        if (errorMessages.size() != 10) continue;
                        errorMessages.add("...");
                    }
                }
                if (format != null) {
                    Converter.convert(sheet, row, format, Converter.buildOutputFile(f, out, sheetName), baseId);
                    continue;
                }
                if (UI_FRAME == null) {
                    throw new IOException("Unknown file-format - The format of sheet '" + sheetName + "' of file " + f.getAbsolutePath() + " is not known.\n" + StringUtils.getStringFromStringList(errorMessages, "\n"));
                }
                invalidSheets = invalidSheets == null ? sheetName : (String)invalidSheets + ", " + sheetName;
            }
            if (invalidSheets != null && UI_FRAME != null) {
                Converter.showWarning("Unknown file format", "Unknown format of file '" + f.getAbsolutePath() + "':\n" + StringUtils.getStringFromStringList(errorMessages, "\n"));
            }
        }
        catch (IOException io) {
            Converter.convertCSVFile(f, formats, Converter.buildOutputFile(f, out, null), baseId, sepaVersion);
        }
    }

    private static void convertCSVFile(File in, List<Format> formats, File out, String baseId, GeneralSEPAWriter.Version sepaVersion) throws IOException, SAXException {
        String[] row;
        BufferedReader r = new BufferedReader(new FileReader(in));
        ArrayList<SEPAPaymentData> datas = new ArrayList<SEPAPaymentData>();
        int rowNumber = 0;
        String line = r.readLine();
        ++rowNumber;
        BaseFormat format = null;
        ArrayList<Object> errorMessages = null;
        block0: while (line != null) {
            row = CSVConverterUtil.splitLineAndTrim(line);
            for (Format f : formats) {
                f.setSepaVersion(sepaVersion);
                String formatError = f.checkRow(row);
                if (formatError == null) {
                    format = f;
                    break block0;
                }
                if (errorMessages == null) {
                    errorMessages = new ArrayList();
                }
                if (errorMessages.size() < 10) {
                    errorMessages.add("Row " + rowNumber + ": " + formatError);
                    continue;
                }
                if (errorMessages.size() != 10) continue;
                errorMessages.add("...");
            }
            line = r.readLine();
            ++rowNumber;
        }
        if (format == null) {
            r.close();
            if (UI_FRAME == null) {
                throw new IOException("Unknown file format - The format of the file " + in.getAbsolutePath() + " is not known.\n" + StringUtils.getStringFromStringList(errorMessages, "\n"));
            }
            Converter.showWarning("Unknown file format", "Unknown format of file '" + in.getAbsolutePath() + "'\n" + StringUtils.getStringFromStringList(errorMessages, "\n"));
            return;
        }
        errorMessages = null;
        while (line != null) {
            row = CSVConverterUtil.splitLineAndTrim(line);
            String rowError = format.checkRow(row);
            if (rowError == null) {
                datas.add(((Format)format).getPaymentData(row, rowNumber));
            } else if (errorMessages == null) {
                errorMessages = new ArrayList<Object>();
                errorMessages.add("Invalid row(s) in file '" + in.getName() + "'");
                errorMessages.add("Row " + rowNumber + ": " + rowError);
            } else if (errorMessages.size() < 10) {
                errorMessages.add("Row " + rowNumber + ": " + rowError);
            } else if (errorMessages.size() == 10) {
                errorMessages.add("...");
            }
            line = r.readLine();
            ++rowNumber;
        }
        r.close();
        if (errorMessages != null) {
            if (UI_FRAME == null) {
                throw new IOException(StringUtils.getStringFromStringList(errorMessages, "\n"));
            }
            Converter.showWarning("Invalid Rows", StringUtils.getStringFromStringList(errorMessages, "\n"));
            return;
        }
        Converter.writeFile(datas, out, baseId, sepaVersion);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int checkXLS(File f, Format format, boolean hasHeader) {
        try (Workbook workbook = XLSUtil.createWorkbook(f);){
            block8: for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                boolean hasReadHeader;
                Sheet sheet = workbook.getSheetAt(i);
                boolean bl = hasReadHeader = !hasHeader;
                for (int row = sheet.getFirstRowNum(); row <= sheet.getLastRowNum(); ++row) {
                    Row r = sheet.getRow(row);
                    if (r == null) continue;
                    if (format.checkRow(r) == null) {
                        int n = i;
                        return n;
                    }
                    if (hasReadHeader) continue block8;
                    hasReadHeader = true;
                }
            }
            int n = -1;
            return n;
        }
        catch (Exception format1) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkCSVFile(File in, Format format, boolean hasHeader) {
        try (BufferedReader r = new BufferedReader(new FileReader(in));){
            String line = r.readLine();
            boolean hasReadHeader = !hasHeader;
            while (line != null) {
                if (line.trim().length() > 0) {
                    String[] row = CSVConverterUtil.splitLineAndTrim(line);
                    if (format.checkRow(row) == null) {
                        boolean bl = true;
                        return bl;
                    }
                    if (hasReadHeader) {
                        boolean bl = false;
                        return bl;
                    }
                    hasReadHeader = true;
                }
                line = r.readLine();
            }
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void convertXLS(File f, int sheetIndex, File out, Format format, boolean hasHeader, String baseId) throws IOException, SAXException {
        int startRow;
        Workbook workbook = XLSUtil.createWorkbook(f);
        if (sheetIndex < 0 || sheetIndex >= workbook.getNumberOfSheets()) {
            throw new IOException("No sheet with index = " + sheetIndex);
        }
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        ArrayList<SEPAPaymentData> datas = new ArrayList<SEPAPaymentData>();
        boolean hasReadHeader = !hasHeader;
        for (int i = startRow = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            if (!hasReadHeader) {
                hasReadHeader = true;
                if (format.checkRow(row) != null) continue;
            }
            if (XLSUtil.isEmpty(row)) continue;
            datas.add(format.getPaymentData(row));
        }
        Converter.writeFile(datas, out, baseId, format.getSepaVersion());
    }

    public static void convertCSVFile(File in, File out, Format format, boolean hasHeader, String baseId) throws IOException, SAXException {
        boolean hasReadHeader = !hasHeader;
        ArrayList<SEPAPaymentData> datas = new ArrayList<SEPAPaymentData>();
        try (BufferedReader r = new BufferedReader(new FileReader(in));){
            String line = r.readLine();
            int lineCounter = 0;
            while (line != null) {
                ++lineCounter;
                if (line.trim().length() > 0) {
                    String[] row = CSVConverterUtil.splitLineAndTrim(line);
                    if (!hasReadHeader) {
                        hasReadHeader = true;
                        if (format.checkRow(row) != null) {
                            line = r.readLine();
                            continue;
                        }
                    }
                    datas.add(format.getPaymentData(row, lineCounter - 1));
                }
                line = r.readLine();
            }
        }
        Converter.writeFile(datas, out, baseId, format.getSepaVersion());
    }

    private static File buildOutputFile(File in, File out, String sheetname) {
        Object filename;
        if (out != null && !out.isDirectory()) {
            if (sheetname == null) {
                return out;
            }
            int lastDot = out.getName().lastIndexOf(46);
            if (lastDot < 0) {
                return new File(out.getParentFile(), out.getName() + sheetname);
            }
            String pre = out.getName().substring(0, lastDot);
            String post = out.getName().substring(lastDot);
            return new File(out.getParent(), pre + sheetname + post);
        }
        File outDir = out == null ? in.getParentFile() : out;
        int lastDot = in.getName().lastIndexOf(46);
        if (lastDot < 0) {
            filename = in.getName();
            if (sheetname != null) {
                filename = (String)filename + sheetname;
            }
            filename = (String)filename + ".xml";
        } else {
            filename = in.getName().substring(0, lastDot);
            if (sheetname != null) {
                filename = (String)filename + sheetname;
            }
            filename = (String)filename + ".xml";
        }
        return new File(outDir, (String)filename);
    }

    private static void convert(Sheet sheet, int startRow, Format format, File out, String baseId) throws IOException, CSVConverterException, SAXException {
        ArrayList<SEPAPaymentData> datas = new ArrayList<SEPAPaymentData>();
        ArrayList<Object> errorMessages = null;
        for (int i = startRow; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            String rowError = format.checkRow(row);
            if (rowError == null) {
                datas.add(format.getPaymentData(row));
                continue;
            }
            if (XLSUtil.isEmpty(row)) continue;
            if (errorMessages == null) {
                errorMessages = new ArrayList<Object>();
                errorMessages.add("Invalid row(s) in file '" + baseId + "', sheet '" + sheet.getSheetName() + "':");
                errorMessages.add("Row " + (i + 1) + ": " + rowError);
                continue;
            }
            if (errorMessages.size() < 10) {
                errorMessages.add("Row " + (i + 1) + ": " + rowError);
                continue;
            }
            if (errorMessages.size() != 10) continue;
            errorMessages.add("...");
        }
        if (errorMessages != null) {
            Converter.showWarning("Invalid Rows", StringUtils.getStringFromStringList(errorMessages, "\n"));
        }
        Converter.writeFile(datas, out, baseId, format.getSepaVersion());
    }

    private static void writeFile(List<SEPAPaymentData> datas, File out, String baseId, GeneralSEPAWriter.Version sepaVersion) throws IOException, SAXException {
        if (datas == null || datas.isEmpty()) {
            return;
        }
        String myBaseId = systemBaseId;
        boolean onePaymentReferenceAsBaseId = false;
        if (sepaVersion == null) {
            sepaVersion = GeneralSEPAWriter.DEFAULT_VERSION;
        }
        SEPAPaymentData firstPayment = datas.get(0);
        if (myBaseId == null) {
            if (datas.size() == 1 && onePaymentReferenceAsBaseId) {
                myBaseId = firstPayment.getEndToEndId();
            }
            if (myBaseId == null || "NOTPROVIDED".equals(myBaseId)) {
                myBaseId = baseId;
            }
        }
        myBaseId = ConverterConfiguration.correctBaseId(myBaseId);
        List<List<SEPAPaymentData>> files = SEPAPaymentData.groupPayments(datas);
        FileOutputStream fout = new FileOutputStream(out);
        GeneralSEPAWriter.write(sepaVersion, firstPayment.getCreditorId() == null, myBaseId, firstPayment.getOriginator(), files, fout);
        fout.close();
    }

    public static JOptionPane getNarrowOptionPane(int maxCharactersPerLineCount) {
        class NarrowOptionPane
        extends JOptionPane {
            private static final long serialVersionUID = 1L;
            int maxCharactersPerLineCount;

            NarrowOptionPane(int maxCharactersPerLineCount) {
                this.maxCharactersPerLineCount = maxCharactersPerLineCount;
            }

            @Override
            public int getMaxCharactersPerLineCount() {
                return this.maxCharactersPerLineCount;
            }
        }
        return new NarrowOptionPane(maxCharactersPerLineCount);
    }

    private static void showWarning(String title, String message) {
        if (UI_FRAME != null) {
            JOptionPane pane = Converter.getNarrowOptionPane(80);
            pane.setMessage(message);
            pane.setMessageType(2);
            JDialog dialog = pane.createDialog(UI_FRAME, title);
            dialog.setVisible(true);
        } else {
            System.out.println(title + ": " + message);
        }
    }

    private static void showException(String title, Exception e) {
        if (UI_FRAME != null) {
            JOptionPane pane = Converter.getNarrowOptionPane(80);
            StringWriter w = new StringWriter();
            PrintWriter p = new PrintWriter(w);
            e.printStackTrace(p);
            p.close();
            pane.setMessage(w.toString());
            pane.setMessageType(0);
            JDialog dialog = pane.createDialog(UI_FRAME, title);
            dialog.setVisible(true);
        } else {
            System.err.println(title);
            e.printStackTrace(System.err);
        }
    }

    private static class ConverterFilter
    implements FilenameFilter {
        private ConverterFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".xls") || name.endsWith(".xlsx") || name.endsWith(".csv");
        }
    }
}

