/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.csv;

import de.businesslogics.format.csv.CSVConverterUtil;
import de.businesslogics.format.sepa.ConverterConfiguration;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.csv.BaseConverter;
import de.businesslogics.format.sepa.csv.ColumnHandler;
import de.businesslogics.format.sepa.csv.ErrorMessage;
import de.businesslogics.format.sepa.csv.Format2;
import de.businesslogics.format.sepa.csv.SepaCSVFormatParser;
import de.businesslogics.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.xml.sax.SAXException;

public class CSVConverter
extends BaseConverter {
    private static final int MAX_MESSAGES_TO_DISPLAY = 10;

    public CSVConverter() {
    }

    public CSVConverter(boolean nogui) {
        if (!nogui) {
            this.UI_FRAME = new JFrame("CSV Converter");
            this.UI_FRAME.setDefaultCloseOperation(3);
        }
    }

    @Override
    protected void convertFile(File f, List<Format2> formats, File out, String baseId, GeneralSEPAWriter.Version sepaVersion) throws IOException, SAXException {
        this.convertCSVFile(f, formats, CSVConverter.buildOutputFile(f, out, null), baseId, sepaVersion);
    }

    protected void convertCSVFile(File in, List<Format2> formats, File out, String baseId, GeneralSEPAWriter.Version sepaVersion) throws IOException, SAXException {
        try (FileOutputStream fout = new FileOutputStream(out);){
            this.convertCSVFile(in, formats, fout, baseId, sepaVersion);
        }
    }

    private void convertCSVFile(File in, List<Format2> formats, OutputStream out, String baseId, GeneralSEPAWriter.Version sepaVersion) throws IOException, SAXException {
        ArrayList<SEPAPaymentData> datas = new ArrayList<SEPAPaymentData>();
        ArrayList<Object> errorMessages = null;
        try (InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(in), ConverterConfiguration.getEncoding());
             BufferedReader r = new BufferedReader(fr);){
            int rowNumber = 0;
            String line = r.readLine();
            ++rowNumber;
            Format2 format = null;
            block12: while (line != null) {
                String[] row = CSVConverterUtil.splitLineAndTrim(line);
                for (Format2 f : formats) {
                    SepaCSVFormatParser p = new SepaCSVFormatParser(f);
                    f.setSepaVersion(sepaVersion);
                    String formatError = p.checkRow(row);
                    if (formatError == null) {
                        format = f;
                        break block12;
                    }
                    if (errorMessages == null) {
                        errorMessages = new ArrayList();
                    }
                    if (errorMessages.size() < 10) {
                        errorMessages.add("Row " + rowNumber + ": " + formatError);
                        continue;
                    }
                    if (errorMessages.size() != 10) continue;
                    errorMessages.add("...");
                }
                line = r.readLine();
                ++rowNumber;
            }
            if (format == null) {
                this.showWarning("Unknown file format", "Unknown format of file '" + in.getAbsolutePath() + "'\n" + StringUtils.getStringFromStringList(errorMessages, "\n"));
                return;
            }
            errorMessages = null;
            SepaCSVFormatParser p = new SepaCSVFormatParser(format);
            while (line != null) {
                String[] row = CSVConverterUtil.splitLineAndTrim(line);
                String rowError = p.checkRow(row);
                if (rowError == null) {
                    datas.add(p.getPaymentData(row, rowNumber));
                } else if (errorMessages == null) {
                    errorMessages = new ArrayList<Object>();
                    errorMessages.add("Invalid row(s) in file '" + in.getName() + "'");
                    errorMessages.add("Row " + rowNumber + ": " + rowError);
                } else if (errorMessages.size() < 10) {
                    errorMessages.add("Row " + rowNumber + ": " + rowError);
                } else if (errorMessages.size() == 10) {
                    errorMessages.add("...");
                }
                line = r.readLine();
                ++rowNumber;
            }
        }
        if (errorMessages != null) {
            this.showWarning("Invalid Rows", StringUtils.getStringFromStringList((List<String>)errorMessages, "\n"));
            return;
        }
        CSVConverter.writeFile(datas, out, baseId, sepaVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkCSVFile(File in, Format2 format, boolean hasHeader) {
        SepaCSVFormatParser p = new SepaCSVFormatParser(format);
        try (FileReader fr = new FileReader(in);
             BufferedReader r = new BufferedReader(fr);){
            String line = r.readLine();
            boolean hasReadHeader = !hasHeader;
            while (line != null) {
                if (line.trim().length() > 0) {
                    String[] row = CSVConverterUtil.splitLineAndTrim(line);
                    if (p.checkRow(row) == null) {
                        boolean bl = true;
                        return bl;
                    }
                    if (hasReadHeader) {
                        boolean bl = false;
                        return bl;
                    }
                    hasReadHeader = true;
                }
                line = r.readLine();
            }
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static List<ErrorMessage> convertCSVFile(Reader in, List<Format2> formats, OutputStream fout, boolean hasHeader, String baseId, GeneralSEPAWriter.Version sepaVersion) throws IOException, SAXException {
        boolean hasReadHeader = !hasHeader;
        BufferedReader r = new BufferedReader(in);
        ArrayList<SEPAPaymentData> datas = new ArrayList<SEPAPaymentData>();
        String line = r.readLine();
        int rowNumber = 0;
        Format2 format = null;
        ArrayList<ErrorMessage> errorMessages = null;
        block0: while (line != null) {
            ++rowNumber;
            if (line.trim().length() > 0) {
                String[] row = CSVConverterUtil.splitLineAndTrim(line);
                if (!hasReadHeader) {
                    hasReadHeader = true;
                    line = r.readLine();
                    continue;
                }
                for (Format2 f : formats) {
                    SepaCSVFormatParser p = new SepaCSVFormatParser(f);
                    f.setSepaVersion(sepaVersion);
                    String formatError = p.checkRow(row);
                    if (formatError == null) {
                        format = f;
                        errorMessages = null;
                        break block0;
                    }
                    if (errorMessages == null) {
                        errorMessages = new ArrayList();
                    }
                    errorMessages.add(new ErrorMessage(rowNumber, formatError));
                }
                break;
            }
            line = r.readLine();
        }
        if (format == null) {
            return errorMessages;
        }
        errorMessages = null;
        SepaCSVFormatParser p = new SepaCSVFormatParser(format);
        while (line != null) {
            String[] row = CSVConverterUtil.splitLineAndTrim(line);
            String rowError = p.checkRow(row);
            if (rowError == null) {
                datas.add(p.getPaymentData(row, rowNumber));
            } else {
                if (errorMessages == null) {
                    errorMessages = new ArrayList<ErrorMessage>();
                }
                errorMessages.add(new ErrorMessage(rowNumber, rowError));
            }
            line = r.readLine();
            ++rowNumber;
        }
        CSVConverter.writeFile(datas, fout, baseId, sepaVersion);
        return errorMessages;
    }

    @Override
    protected FilenameFilter getConverterFilter() {
        return new ConverterFilter();
    }

    @Override
    protected ColumnHandler getColumnHandler() {
        return null;
    }

    private static class ConverterFilter
    implements FilenameFilter {
        private ConverterFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".csv");
        }
    }
}

