/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.csv;

import de.businesslogics.format.sepa.ConverterConfiguration;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.csv.ColumnHandler;
import de.businesslogics.format.sepa.csv.Format2;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.xml.sax.SAXException;

public abstract class BaseConverter {
    protected JFrame UI_FRAME = null;
    private static String systemBaseId = System.getProperty("de.businesslogics.format.sepa.CSVConverter.baseId");

    protected void doIt(File in, File out, String type) throws Exception {
        GeneralSEPAWriter.DebitType debitType;
        File dir = in.isDirectory() ? in : in.getParentFile();
        File formatDefinition = new File(dir, "format.txt");
        GeneralSEPAWriter.Version version = ConverterConfiguration.getSepaVersion();
        ArrayList<Format2> formats = new ArrayList<Format2>();
        if (GeneralSEPAWriter.ServiceLevel.URGP.equals(type) && version.ordinal() < GeneralSEPAWriter.Version.V27.ordinal()) {
            version = GeneralSEPAWriter.Version.V27;
        }
        if (GeneralSEPAWriter.DebitType.COR1.equals((Object)(debitType = GeneralSEPAWriter.DebitType.valueOf(type))) && (version.ordinal() < GeneralSEPAWriter.Version.V27.ordinal() || version.ordinal() > GeneralSEPAWriter.Version.V27.ordinal())) {
            version = GeneralSEPAWriter.Version.V27;
        }
        if (formatDefinition.exists()) {
            try {
                formats.addAll(Format2.parseFile(formatDefinition, this.getColumnHandler()));
            }
            catch (Exception e) {
                this.showException("Error reading format.txt", e);
                return;
            }
        }
        formats.add(Format2.DEFAULT_CREDIT);
        formats.add(Format2.DEFAULT_DEBIT);
        for (Format2 f : formats) {
            if (type != null && f.getColumn(Format2.Fields.DEBIT_TYPE) != null) {
                f.setDebitType(type);
            }
            if (type == null || f.getColumn(Format2.Fields.CREDIT_TYPE) == null) continue;
            f.setCreditType(type);
        }
        this.doIt(in, out, formats, version);
    }

    protected void doIt(File in, File out, List<Format2> formats, GeneralSEPAWriter.Version sepaVersion) throws Exception {
        File[] filesToConvert = null;
        filesToConvert = in.isDirectory() ? in.listFiles(this.getConverterFilter()) : new File[]{in};
        if (filesToConvert == null || filesToConvert.length == 0) {
            this.showWarning("No files found", "There are no files to convert. Check that there are files in " + in.getAbsolutePath());
            return;
        }
        String s = ConverterConfiguration.getBaseId();
        for (File f : filesToConvert) {
            String baseId = null;
            baseId = s != null && s.length() > 0 ? s : f.getName();
            this.convertFile(f, formats, out, baseId, sepaVersion);
        }
    }

    protected abstract ColumnHandler getColumnHandler();

    protected abstract FilenameFilter getConverterFilter();

    protected abstract void convertFile(File var1, List<Format2> var2, File var3, String var4, GeneralSEPAWriter.Version var5) throws IOException, SAXException;

    protected static File buildOutputFile(File in, File out, String sheetname) {
        Object filename;
        if (out != null && !out.getAbsoluteFile().getParentFile().exists()) {
            out.getAbsoluteFile().getParentFile().mkdirs();
        }
        if (out != null && !out.isDirectory()) {
            if (sheetname == null) {
                return out;
            }
            int lastDot = out.getName().lastIndexOf(46);
            if (lastDot < 0) {
                return new File(out.getAbsoluteFile().getParentFile(), out.getName() + sheetname);
            }
            String pre = out.getName().substring(0, lastDot);
            String post = out.getName().substring(lastDot);
            return new File(out.getParent(), pre + sheetname + post);
        }
        File outDir = out == null ? in.getAbsoluteFile().getParentFile() : out;
        int lastDot = in.getName().lastIndexOf(46);
        if (lastDot < 0) {
            filename = in.getName();
            if (sheetname != null) {
                filename = (String)filename + sheetname;
            }
            filename = (String)filename + ".xml";
        } else {
            filename = in.getName().substring(0, lastDot);
            if (sheetname != null) {
                filename = (String)filename + sheetname;
            }
            filename = (String)filename + ".xml";
        }
        return new File(outDir, (String)filename);
    }

    public static void writeFile(List<SEPAPaymentData> datas, OutputStream fout, String baseId, GeneralSEPAWriter.Version sepaVersion) throws IOException, SAXException {
        if (datas == null || datas.isEmpty()) {
            return;
        }
        String myBaseId = systemBaseId;
        boolean onePaymentReferenceAsBaseId = false;
        if (sepaVersion == null) {
            sepaVersion = GeneralSEPAWriter.DEFAULT_VERSION;
        }
        SEPAPaymentData firstPayment = datas.get(0);
        if (myBaseId == null) {
            if (datas.size() == 1 && onePaymentReferenceAsBaseId) {
                myBaseId = firstPayment.getEndToEndId();
            }
            if (myBaseId == null || "NOTPROVIDED".equals(myBaseId)) {
                myBaseId = baseId;
            }
        }
        myBaseId = ConverterConfiguration.correctBaseId(myBaseId);
        List<List<SEPAPaymentData>> files = SEPAPaymentData.groupPayments(datas);
        GeneralSEPAWriter.write(sepaVersion, firstPayment.getCreditorId() == null, myBaseId, firstPayment.getOriginator(), files, fout);
    }

    public static JOptionPane getNarrowOptionPane(int maxCharactersPerLineCount) {
        class NarrowOptionPane
        extends JOptionPane {
            private static final long serialVersionUID = 1L;
            int maxCharactersPerLineCount;

            NarrowOptionPane(int maxCharactersPerLineCount) {
                this.maxCharactersPerLineCount = maxCharactersPerLineCount;
            }

            @Override
            public int getMaxCharactersPerLineCount() {
                return this.maxCharactersPerLineCount;
            }
        }
        return new NarrowOptionPane(maxCharactersPerLineCount);
    }

    protected void showWarning(String title, String message) throws IOException {
        if (this.UI_FRAME == null) {
            throw new IOException(message);
        }
        JOptionPane pane = BaseConverter.getNarrowOptionPane(80);
        pane.setMessage(message);
        pane.setMessageType(2);
        JDialog dialog = pane.createDialog(this.UI_FRAME, title);
        dialog.setVisible(true);
    }

    protected void showException(String title, Throwable e) {
        if (this.UI_FRAME != null) {
            JOptionPane pane = BaseConverter.getNarrowOptionPane(80);
            StringWriter w = new StringWriter();
            PrintWriter p = new PrintWriter(w);
            e.printStackTrace(p);
            p.close();
            pane.setMessage(w.toString());
            pane.setMessageType(0);
            JDialog dialog = pane.createDialog(this.UI_FRAME, title);
            dialog.setVisible(true);
        } else {
            System.err.println(title);
            e.printStackTrace(System.out);
        }
    }

    protected void dispose() {
        if (this.UI_FRAME != null) {
            this.UI_FRAME.dispose();
        }
    }
}

