/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.at;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostbarPurpose {
    private static final Pattern DATE_PATTERN = Pattern.compile("\\d{8}");
    private static final Pattern POSTBAR_PATTERN = Pattern.compile("((?:K1D\\d{8}|K3|K4|K8D\\d{8}|K21|K22|K23P43\\d{9,11}|K24|K25Z\\d{4})*)([^ZDPK0-9])(.*)");
    private String address1;
    private String address2;
    private String plz;
    private String earliestDate;
    private boolean noForward;
    private boolean inPerson;
    private String storeDate;
    private PayOffMode payOffMode;
    private String smsNumber;
    private String postPLZ;
    private String purpose;

    public static boolean isPostbarPurpose(String purpose) {
        return POSTBAR_PATTERN.matcher(purpose).matches();
    }

    public static PostbarPurpose getPostbarPurpose(String purpose) {
        Matcher m = POSTBAR_PATTERN.matcher(purpose);
        if (m.matches()) {
            String[] s1;
            PostbarPurpose p = new PostbarPurpose();
            for (String s : s1 = m.group(1).split("K")) {
                if (s.startsWith("1D")) {
                    p.earliestDate = s.substring(2);
                    continue;
                }
                if (s.startsWith("3")) {
                    p.noForward = true;
                    continue;
                }
                if (s.startsWith("4")) {
                    p.inPerson = true;
                    continue;
                }
                if (s.startsWith("8D")) {
                    p.storeDate = s.substring(2);
                    continue;
                }
                if (s.startsWith("21")) {
                    p.payOffMode = PayOffMode.PayOff;
                    continue;
                }
                if (s.startsWith("22")) {
                    p.payOffMode = PayOffMode.PayOffYellowPaper;
                    continue;
                }
                if (s.startsWith("23P43")) {
                    p.payOffMode = PayOffMode.PayOffSms;
                    p.smsNumber = s.substring(5);
                    continue;
                }
                if (s.startsWith("24")) {
                    p.payOffMode = PayOffMode.PayOffPost;
                    continue;
                }
                if (!s.startsWith("25Z")) continue;
                p.payOffMode = PayOffMode.PayOffPostPlz;
                p.postPLZ = s.substring(3);
            }
            if (p.payOffMode == null) {
                p.payOffMode = PayOffMode.PayOff;
            }
            String sep = m.group(2);
            String[] s2 = m.group(3).split(Pattern.quote(sep));
            p.plz = PostbarPurpose.checkForNullAndTrim(s2[0]);
            if (s2.length > 1) {
                p.address1 = PostbarPurpose.checkForNullAndTrim(s2[1]);
            }
            if (s2.length > 2) {
                p.address2 = PostbarPurpose.checkForNullAndTrim(s2[2]);
            }
            if (s2.length > 3) {
                p.purpose = PostbarPurpose.checkForNullAndTrim(s2[3]);
            }
            return p;
        }
        return null;
    }

    private PostbarPurpose() {
        this.address1 = "";
        this.address2 = "";
        this.plz = "";
        this.earliestDate = null;
        this.noForward = false;
        this.inPerson = false;
        this.storeDate = null;
        this.payOffMode = null;
        this.smsNumber = "";
        this.postPLZ = "";
        this.purpose = "";
    }

    public PostbarPurpose(String address1, String address2, String plz, String earliestDate, boolean noForward, boolean inPerson, String storeDate, PayOffMode payOffMode, String smsNumber, String postPLZ, String purpose) {
        this.address1 = PostbarPurpose.checkForNullAndTrim(address1);
        this.address2 = PostbarPurpose.checkForNullAndTrim(address2);
        this.plz = PostbarPurpose.checkForNullAndTrim(plz);
        this.earliestDate = PostbarPurpose.checkDateFormat(earliestDate);
        this.noForward = noForward;
        this.inPerson = inPerson;
        this.storeDate = PostbarPurpose.checkDateFormat(storeDate);
        this.payOffMode = payOffMode != null ? payOffMode : PayOffMode.PayOff;
        this.smsNumber = PostbarPurpose.checkForNullAndTrim(smsNumber);
        this.postPLZ = PostbarPurpose.checkForNullAndTrim(postPLZ);
        this.purpose = PostbarPurpose.checkForNullAndTrim(purpose);
    }

    public String getTotalPurpose() {
        StringBuilder b = new StringBuilder();
        if (this.earliestDate != null) {
            b.append("K1D");
            b.append(this.earliestDate);
        }
        if (this.noForward) {
            b.append("K3");
        }
        if (this.inPerson) {
            b.append("K4");
        }
        if (this.storeDate != null) {
            b.append("K8D");
            b.append(this.storeDate);
        }
        if (PayOffMode.PayOff.equals((Object)this.payOffMode)) {
            b.append("K21");
        } else if (PayOffMode.PayOffYellowPaper.equals((Object)this.payOffMode)) {
            b.append("K22");
        } else if (PayOffMode.PayOffSms.equals((Object)this.payOffMode)) {
            b.append("K23P43");
            b.append(this.smsNumber);
        } else if (PayOffMode.PayOffPost.equals((Object)this.payOffMode)) {
            b.append("K24");
        } else if (PayOffMode.PayOffPostPlz.equals((Object)this.payOffMode)) {
            b.append("K25Z");
            b.append(this.postPLZ);
        }
        char separator = this.findSeparator();
        b.append(separator);
        b.append(this.plz);
        b.append(separator);
        b.append(this.address1);
        b.append(separator);
        b.append(this.address2);
        b.append(separator);
        b.append(this.purpose);
        return b.toString();
    }

    public String getAddress1() {
        return this.address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public String getPlz() {
        return this.plz;
    }

    public String getEarliestDate() {
        return this.earliestDate;
    }

    public boolean isNoForward() {
        return this.noForward;
    }

    public boolean isInPerson() {
        return this.inPerson;
    }

    public String getStoreDate() {
        return this.storeDate;
    }

    public PayOffMode getPayOffMode() {
        return this.payOffMode;
    }

    public String getSmsNumber() {
        return this.smsNumber;
    }

    public String getPostPLZ() {
        return this.postPLZ;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = PostbarPurpose.checkForNullAndTrim(purpose);
    }

    private char findSeparator() {
        char[] separators;
        for (char c : separators = new char[]{'?', ')', '(', ':', '\'', '+'}) {
            if (this.plz.indexOf(c) >= 0 || this.address1.indexOf(c) >= 0 || this.address2.indexOf(c) >= 0) continue;
            return c;
        }
        return '+';
    }

    private static String checkForNullAndTrim(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    private static final String checkDateFormat(String s) {
        if (s != null && DATE_PATTERN.matcher(s).matches()) {
            return s;
        }
        return null;
    }

    public static enum PayOffMode {
        PayOff,
        PayOffYellowPaper,
        PayOffSms,
        PayOffPost,
        PayOffPostPlz;

    }
}

