/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.at;

import de.businesslogics.banking.database.vo.PaymentRecipient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class KnownTaxOfficeRecipient {
    private static final List<KnownTaxOfficeRecipient> LIST = new ArrayList<KnownTaxOfficeRecipient>();
    private final String name;
    private final String iban;

    static void init(File file) throws IOException {
        InputStream in = file == null || !file.exists() ? KnownTaxOfficeRecipient.class.getResourceAsStream("/de/businesslogics/format/sepa/at/KnownTaxOfficeRecipients.txt") : new FileInputStream(file);
        if (in == null) {
            throw new RuntimeException("KnownTaxOfficeRecipients.txt not found");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.ISO_8859_1));){
            LIST.clear();
            String s = reader.readLine();
            while (s != null) {
                if (!s.startsWith("#")) {
                    String[] strings = s.split(";");
                    LIST.add(new KnownTaxOfficeRecipient(strings[0], strings[1]));
                }
                s = reader.readLine();
            }
        }
    }

    private KnownTaxOfficeRecipient(String name, String iban) {
        this.name = name;
        this.iban = iban;
    }

    public static List<KnownTaxOfficeRecipient> getKnownRecipients() {
        if (LIST.isEmpty()) {
            try {
                KnownTaxOfficeRecipient.init(null);
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
        return LIST;
    }

    public static List<PaymentRecipient> findKnownRecipientsByNameOrAccountNumberLike(String nameOrAccountNumber) {
        if (LIST.isEmpty()) {
            try {
                KnownTaxOfficeRecipient.init(null);
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
        ArrayList<PaymentRecipient> filteredRecipients = new ArrayList<PaymentRecipient>();
        for (KnownTaxOfficeRecipient knownRecipient : LIST) {
            if (!knownRecipient.name.contains(nameOrAccountNumber) && !knownRecipient.iban.contains(nameOrAccountNumber)) continue;
            PaymentRecipient recipient = new PaymentRecipient();
            recipient.setAccountNumber(knownRecipient.getIban());
            recipient.setName(knownRecipient.getName());
            recipient.setDisplayName(knownRecipient.getName());
            filteredRecipients.add(recipient);
        }
        return filteredRecipients;
    }

    public static PaymentRecipient findKnownRecipientByName(String name) {
        if (LIST.isEmpty()) {
            try {
                KnownTaxOfficeRecipient.init(null);
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
        for (KnownTaxOfficeRecipient knownRecipient : LIST) {
            if (!knownRecipient.name.equals(name)) continue;
            PaymentRecipient recipient = new PaymentRecipient();
            recipient.setAccountNumber(knownRecipient.getIban());
            recipient.setName(knownRecipient.getName());
            recipient.setDisplayName(knownRecipient.getName());
            return recipient;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getIban() {
        return this.iban;
    }
}

