/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.at;

import de.businesslogics.format.sepa.at.AustrianFeeType;
import de.businesslogics.format.sepa.at.KnownTaxOfficeRecipient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public class AustrianFeeTypeProvider {
    private final Map<String, AustrianFeeType> feeTypeMap = new HashMap<String, AustrianFeeType>();
    private final Map<DateType, List<AustrianFeeType>> dateFeeTypeMap = new HashMap<DateType, List<AustrianFeeType>>();
    private final Set<String> duplicateCodes = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AustrianFeeTypeProvider(File file) throws Exception {
        try (BufferedReader reader = null;){
            InputStream in = file.exists() ? new FileInputStream(file) : this.getClass().getResourceAsStream("/de/businesslogics/format/sepa/at/AustrianFeeTypes.txt");
            if (in == null) {
                throw new RuntimeException("Cant not find AustrianFeeTypes.txt");
            }
            reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.ISO_8859_1));
            String s = reader.readLine();
            if (s != null) {
                do {
                    if (s.startsWith("#")) continue;
                    StringTokenizer st = new StringTokenizer(s, ";");
                    String code = st.nextToken().trim();
                    int dateType = Integer.parseInt(st.nextToken().trim());
                    int amountType = Integer.parseInt(st.nextToken().trim());
                    String description = st.nextToken().trim();
                    boolean hasPriority = st.hasMoreTokens() && "prio".equals(st.nextToken().trim());
                    AustrianFeeType feeType = new AustrianFeeType(code, description, dateType, amountType, hasPriority);
                    if (dateType == 8) {
                        this.duplicateCodes.add(code);
                        this.feeTypeMap.put(code + "8", feeType);
                    } else {
                        this.feeTypeMap.put(code, feeType);
                    }
                    if (dateType >= 32) {
                        this.addFeeType(feeType, DateType.DATE);
                        dateType -= 32;
                    }
                    if (dateType >= 16) {
                        this.addFeeType(feeType, DateType.QUARTER);
                        dateType -= 16;
                    }
                    if (dateType >= 8) {
                        this.addFeeType(feeType, DateType.YEAR_01_12);
                        dateType -= 8;
                    }
                    if (dateType >= 4) {
                        this.addFeeType(feeType, DateType.INTERVAL);
                        this.addFeeType(feeType, DateType.QUARTER);
                        this.addFeeType(feeType, DateType.YEAR_01_12);
                        dateType -= 4;
                    }
                    if (dateType >= 2) {
                        this.addFeeType(feeType, DateType.MONTH);
                        dateType -= 2;
                    }
                    if (dateType < 1) continue;
                    this.addFeeType(feeType, DateType.YEAR);
                } while ((s = reader.readLine()) != null);
                for (DateType dateType : this.dateFeeTypeMap.keySet()) {
                    List<AustrianFeeType> feeTypes = this.dateFeeTypeMap.get((Object)dateType);
                    feeTypes.sort(Comparator.comparing(AustrianFeeType::getCode));
                }
            }
        }
        KnownTaxOfficeRecipient.init(new File(file.getParentFile(), "KnownTaxOfficeRecipients.txt"));
    }

    private void addFeeType(AustrianFeeType feeType, DateType dateType) {
        List feeTypeList = this.dateFeeTypeMap.computeIfAbsent(dateType, k -> new ArrayList());
        feeTypeList.add(feeType);
    }

    public DateType getDateType(String dateInfo) {
        if (dateInfo != null) {
            int length = (dateInfo = dateInfo.trim()).length();
            if (length == 2) {
                return DateType.YEAR;
            }
            if (length == 4) {
                return DateType.MONTH;
            }
            if (length == 6) {
                return DateType.DATE;
            }
            if (length == 7) {
                String startMonth = dateInfo.substring(2, 4);
                String endMonth = dateInfo.substring(5);
                if ("01".equals(startMonth) && "03".equals(endMonth) || "04".equals(startMonth) && "06".equals(endMonth) || "07".equals(startMonth) && "09".equals(endMonth) || "10".equals(startMonth) && "12".equals(endMonth)) {
                    return DateType.QUARTER;
                }
                if ("01".equals(startMonth) && "12".equals(endMonth)) {
                    return DateType.YEAR_01_12;
                }
                return DateType.INTERVAL;
            }
        }
        return null;
    }

    public boolean isDateTypeAllowed(AustrianFeeType feeType, DateType periodType) {
        List<AustrianFeeType> feeTypes = this.getFeeTypes(periodType);
        if (feeTypes != null) {
            return feeTypes.contains(feeType);
        }
        return false;
    }

    public List<AustrianFeeType> getFeeTypes(DateType periodType) {
        return this.dateFeeTypeMap.get((Object)periodType);
    }

    public List<AustrianFeeType> getHighPriorityFeeTypes(DateType periodType) {
        return this.dateFeeTypeMap.get((Object)periodType).stream().filter(AustrianFeeType::isPrioritized).collect(Collectors.toList());
    }

    public List<AustrianFeeType> getLowPriorityFeeTypes(DateType periodType) {
        return this.dateFeeTypeMap.get((Object)periodType).stream().filter(ft -> !ft.isPrioritized()).collect(Collectors.toList());
    }

    public AustrianFeeType getFeeType(String code, String dateInfo) {
        return this.getFeeType(code, this.getDateType(dateInfo));
    }

    public AustrianFeeType getFeeType(String code, DateType dateType) {
        if (this.duplicateCodes.contains(code) && DateType.YEAR_01_12.equals((Object)dateType)) {
            return this.feeTypeMap.get(code + "8");
        }
        return this.feeTypeMap.get(code);
    }

    public static enum DateType {
        YEAR,
        MONTH,
        INTERVAL,
        DATE,
        QUARTER,
        YEAR_01_12;

    }
}

