/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.at;

import de.businesslogics.format.sepa.at.AustrianFeeMessageHandler;
import java.math.BigDecimal;

public class AustrianFeeType {
    private String code;
    private String description;
    private int dateType;
    private int amountType;
    private boolean hasPriority;

    public AustrianFeeType(String code, String description, int dateType, int amountType, boolean hasPriority) {
        this.code = code;
        this.description = description;
        this.dateType = dateType;
        this.amountType = amountType;
        this.hasPriority = hasPriority;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDateType() {
        return this.dateType;
    }

    public int getAmountType() {
        return this.amountType;
    }

    public boolean isPrioritized() {
        return this.hasPriority;
    }

    public boolean canAmountBeNegative() {
        return this.getAmountType() >= 2;
    }

    public String toString() {
        return this.code + " - " + this.description;
    }

    public static boolean isValidAmount(AustrianFeeType feeType, BigDecimal amount) {
        return AustrianFeeType.isValidAmount(feeType, amount, false);
    }

    public static boolean isValidAmount(AustrianFeeType feeType, BigDecimal amount, boolean isCredit) {
        String amountString = AustrianFeeMessageHandler.getAmountString(amount, isCredit);
        if (amountString.length() > 12) {
            return false;
        }
        switch (feeType.getAmountType()) {
            case 0: {
                return amount.signum() > 0;
            }
            case 1: {
                return amount.signum() >= 0;
            }
            case 2: {
                return amount.signum() != 0;
            }
        }
        return true;
    }
}

