/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa.at;

import de.businesslogics.format.sepa.at.AustrianFeeItem;
import de.businesslogics.format.sepa.at.AustrianFeeMessage;
import de.businesslogics.format.sepa.at.AustrianFeeType;
import de.businesslogics.format.sepa.at.AustrianFeeTypeProvider;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AustrianFeeMessageHandler {
    private static final Pattern purposePattern = Pattern.compile("(\\d{2}(\\d{2}(/?\\d{2})?)?([-+](0|([1-9]([0-9]{0,10})?))[A-Z]{1,3})+)+");
    private static final Pattern messagePattern = Pattern.compile("\\d{2}(\\d{2}(/?\\d{2})?)?([-+](0|([1-9]([0-9]{0,10})?))[A-Z]{1,3})+");
    private static final Pattern datePattern = Pattern.compile("\\d{2}(\\d{2}(/?\\d{2})?)?");
    private static final Pattern itemPattern = Pattern.compile("([-+](0|([1-9]([0-9]{0,10})?))[A-Z]{1,3})");
    private static final Pattern amountPattern = Pattern.compile("[-+](0|([1-9]([0-9]{0,10})?))");

    public static boolean isValidPattern(String purpose) {
        Matcher m = purposePattern.matcher(purpose);
        return m.matches();
    }

    public static BigDecimal getAmountSum(List<AustrianFeeMessage> messages) {
        BigDecimal result = BigDecimal.ZERO;
        for (AustrianFeeMessage message : messages) {
            result = result.add(AustrianFeeMessageHandler.getAmountSum(message));
        }
        return result;
    }

    private static BigDecimal getAmountSum(AustrianFeeMessage message) {
        BigDecimal result = BigDecimal.ZERO;
        for (AustrianFeeItem item : message.getFeeItems()) {
            if (item.isCredit()) {
                result = result.subtract(item.getAmount());
                continue;
            }
            result = result.add(item.getAmount());
        }
        return result;
    }

    public static String getPurpose(List<AustrianFeeMessage> messages) {
        StringBuffer sb = new StringBuffer();
        for (AustrianFeeMessage message : messages) {
            sb.append(AustrianFeeMessageHandler.getPurpose(message));
        }
        return sb.toString();
    }

    public static String getPurpose(AustrianFeeMessage message) {
        StringBuffer sb = new StringBuffer();
        sb.append(message.getDateInfo());
        sb.append(AustrianFeeMessageHandler.getPurposePart(message.getFeeItems()));
        return sb.toString();
    }

    public static String getPurposePart(List<AustrianFeeItem> feeItems) {
        StringBuffer sb = new StringBuffer();
        for (AustrianFeeItem feeItem : feeItems) {
            sb.append(AustrianFeeMessageHandler.getAmountString(feeItem.getAmount(), feeItem.isCredit()));
            sb.append(feeItem.getFeeType().getCode());
        }
        return sb.toString();
    }

    public static String getAmountString(BigDecimal amount) {
        return AustrianFeeMessageHandler.getAmountString(amount, false);
    }

    public static String getAmountString(BigDecimal amount, boolean isCredit) {
        BigDecimal amountInCent = amount.scaleByPowerOfTen(2);
        if (isCredit) {
            amountInCent = amountInCent.multiply(BigDecimal.valueOf(-1L));
        }
        DecimalFormat df = new DecimalFormat("+0;-0");
        return df.format(amountInCent);
    }

    private static BigDecimal getAmount(String s) {
        BigDecimal amountInCent = new BigDecimal(s);
        return amountInCent.scaleByPowerOfTen(-2);
    }

    public static Map<String, AustrianFeeMessage> getFeeMessages(String purpose, AustrianFeeTypeProvider provider) {
        List<AustrianFeeMessage> messages;
        if (purpose != null && AustrianFeeMessageHandler.isValidPattern(purpose) && (messages = AustrianFeeMessageHandler.parse(purpose, provider)) != null) {
            return AustrianFeeMessageHandler.getFeeMessageMap(messages);
        }
        return null;
    }

    public static List<AustrianFeeMessage> getFeeMessagesAsList(String purpose, AustrianFeeTypeProvider provider) {
        List<AustrianFeeMessage> messages;
        if (purpose != null && AustrianFeeMessageHandler.isValidPattern(purpose) && (messages = AustrianFeeMessageHandler.parse(purpose, provider)) != null) {
            return AustrianFeeMessageHandler.getUniqueFeeMessages(messages);
        }
        return null;
    }

    public static List<AustrianFeeMessage> getUniqueFeeMessages(List<AustrianFeeMessage> messages) {
        if (messages != null) {
            ArrayList<AustrianFeeMessage> result = new ArrayList<AustrianFeeMessage>();
            result.addAll(AustrianFeeMessageHandler.getFeeMessageMap(messages).values());
            return result;
        }
        return null;
    }

    private static Map<String, AustrianFeeMessage> getFeeMessageMap(List<AustrianFeeMessage> messages) {
        HashMap<String, AustrianFeeMessage> feeMessageMap = new HashMap<String, AustrianFeeMessage>();
        for (AustrianFeeMessage message : messages) {
            String dateInfo = message.getDateInfo();
            AustrianFeeMessage existingMessage = feeMessageMap.get(dateInfo);
            if (existingMessage != null) {
                existingMessage.addFeeItems(message.getFeeItems());
                continue;
            }
            feeMessageMap.put(dateInfo, message);
        }
        return feeMessageMap;
    }

    private static List<AustrianFeeMessage> parse(String purpose, AustrianFeeTypeProvider provider) {
        ArrayList<AustrianFeeMessage> messages = new ArrayList<AustrianFeeMessage>();
        for (MatchResult r : AustrianFeeMessageHandler.findMatches(messagePattern, purpose)) {
            String message = r.group();
            MatchResult dateResult = AustrianFeeMessageHandler.findFirstMatch(datePattern, message);
            String dateInfo = dateResult.group();
            String remainingMessage = message.substring(dateResult.end());
            ArrayList<AustrianFeeItem> items = new ArrayList<AustrianFeeItem>();
            for (MatchResult r2 : AustrianFeeMessageHandler.findMatches(itemPattern, remainingMessage)) {
                String item = r2.group();
                MatchResult amountResult = AustrianFeeMessageHandler.findFirstMatch(amountPattern, item);
                String amountString = amountResult.group();
                String feeCode = item.substring(amountResult.end());
                BigDecimal amount = AustrianFeeMessageHandler.getAmount(amountString);
                boolean isCredit = amount.signum() < 0;
                items.add(new AustrianFeeItem(provider.getFeeType(feeCode, dateInfo), amount.abs(), isCredit));
            }
            messages.add(new AustrianFeeMessage(dateInfo, items));
        }
        return messages;
    }

    private static Iterable<MatchResult> findMatches(Pattern pattern, CharSequence s) {
        ArrayList<MatchResult> results = new ArrayList<MatchResult>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            results.add(m.toMatchResult());
        }
        return results;
    }

    private static MatchResult findFirstMatch(Pattern pattern, CharSequence s) {
        Matcher m = pattern.matcher(s);
        m.find();
        return m.toMatchResult();
    }

    private static String getMessageInfo(AustrianFeeMessage message) {
        StringBuffer sb = new StringBuffer();
        sb.append("Zeitraum: " + message.getDateInfo());
        sb.append("\n");
        for (AustrianFeeItem item : message.getFeeItems()) {
            AustrianFeeType type = item.getFeeType();
            sb.append("Abgabentyp: ");
            sb.append(type.toString());
            sb.append("\n");
            sb.append("Betrag: ");
            sb.append(item.getAmount());
            sb.append(" EUR");
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String[] purposes;
        File file = new File("D:\\Client_Development\\blbanking\\SG_Schulung\\data\\AustrianFeeTypes.txt");
        AustrianFeeTypeProvider provider = new AustrianFeeTypeProvider(file);
        for (String purpose : purposes = new String[]{"08+100AZ", "1601/04+1234U+32199EEE15+1234U+32199EEE"}) {
            List<AustrianFeeMessage> messages = AustrianFeeMessageHandler.parse(purpose, provider);
            System.out.println("Verwendungszweck <" + purpose + ">------------------");
            for (AustrianFeeMessage message : messages) {
                System.out.println(AustrianFeeMessageHandler.getMessageInfo(message));
            }
        }
        ArrayList<BigDecimal> l = new ArrayList<BigDecimal>();
        l.add(new BigDecimal("999999999.99"));
        l.add(new BigDecimal("1234567.89"));
        l.add(new BigDecimal(".8"));
        l.add(new BigDecimal("123"));
        l.add(new BigDecimal("123."));
        l.add(new BigDecimal("-123."));
        for (BigDecimal bd : l) {
            System.out.println("BigDeciaml <" + String.valueOf(bd) + "> PlainString <" + bd.toPlainString() + "> + String <" + bd.toString() + ">");
        }
    }

    public static class FeeMessageDate {
        private AustrianFeeTypeProvider.DateType dateType = AustrianFeeTypeProvider.DateType.YEAR;
        private Integer year;
        private String month1 = "";
        private String month2 = "";
        private String quarterString = "";
        private Integer quarter;
        private Calendar date = Calendar.getInstance();

        public static String getDateInfo(AustrianFeeTypeProvider.DateType dateType, Integer year, String month1, String month2, String quarter, Date date) {
            StringBuilder sb = new StringBuilder();
            switch (dateType) {
                case YEAR: {
                    sb.append(year - 2000);
                    break;
                }
                case MONTH: {
                    sb.append(year - 2000);
                    sb.append(month1);
                    break;
                }
                case INTERVAL: {
                    sb.append(year - 2000);
                    sb.append(month1);
                    sb.append('/');
                    sb.append(month2);
                    break;
                }
                case QUARTER: {
                    sb.append(year - 2000);
                    sb.append(quarter);
                    break;
                }
                case YEAR_01_12: {
                    sb.append(year - 2000);
                    sb.append("01/12");
                    break;
                }
                case DATE: {
                    sb.append(new SimpleDateFormat("yyMMdd").format(date));
                }
            }
            return sb.toString();
        }

        public FeeMessageDate(String dateInfo) {
            int length = dateInfo.length();
            this.year = 2000 + Integer.parseInt(dateInfo.substring(0, 2));
            if (length == 2) {
                this.dateType = AustrianFeeTypeProvider.DateType.YEAR;
            } else if (length == 4) {
                this.dateType = AustrianFeeTypeProvider.DateType.MONTH;
                this.month1 = dateInfo.substring(2);
            } else if (length == 6) {
                this.dateType = AustrianFeeTypeProvider.DateType.DATE;
                this.date = Calendar.getInstance();
                this.date.set(this.year, Integer.parseInt(dateInfo.substring(2, 4)) - 1, Integer.parseInt(dateInfo.substring(4)));
            } else if (length == 7) {
                this.month1 = dateInfo.substring(2, 4);
                this.month2 = dateInfo.substring(5);
                this.dateType = this.isYear() ? AustrianFeeTypeProvider.DateType.YEAR_01_12 : (this.isQuarter() ? AustrianFeeTypeProvider.DateType.QUARTER : AustrianFeeTypeProvider.DateType.INTERVAL);
            }
        }

        private boolean isYear() {
            return "01".equals(this.month1) && "12".equals(this.month2);
        }

        private boolean isQuarter() {
            if ("01".equals(this.month1) && "03".equals(this.month2)) {
                this.quarter = 1;
            } else if ("04".equals(this.month1) && "06".equals(this.month2)) {
                this.quarter = 2;
            } else if ("07".equals(this.month1) && "09".equals(this.month2)) {
                this.quarter = 3;
            } else if ("10".equals(this.month1) && "12".equals(this.month2)) {
                this.quarter = 4;
            }
            if (this.quarter != null) {
                this.quarterString = this.month1 + "/" + this.month2;
                return true;
            }
            return false;
        }

        public AustrianFeeTypeProvider.DateType getDateType() {
            return this.dateType;
        }

        public Integer getYear() {
            return this.year;
        }

        public String getMonth1() {
            return this.month1;
        }

        public String getMonth2() {
            return this.month2;
        }

        public String getQuarterString() {
            return this.quarterString;
        }

        public Integer getQuarter() {
            return this.quarter;
        }

        public Calendar getDate() {
            return this.date;
        }
    }
}

