/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;

public class StatusTransactionInfo {
    private final String statusCode;
    private int countTransactions;
    private BigDecimal totalAmount;
    private final boolean isCalculated;
    private final Set<Currency> currencies = new HashSet<Currency>();
    boolean hasMissingCurrency = false;
    boolean hasMissingAmount = false;

    public StatusTransactionInfo(String statusCode, int countTransactions, BigDecimal totalAmount) {
        this.statusCode = statusCode;
        this.countTransactions = countTransactions;
        this.totalAmount = totalAmount;
        this.isCalculated = false;
    }

    public StatusTransactionInfo(String statusCode) {
        this.statusCode = statusCode;
        this.countTransactions = 0;
        this.totalAmount = BigDecimal.ZERO;
        this.isCalculated = true;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public int getCountTransactions() {
        return this.countTransactions;
    }

    public BigDecimal getTotalAmount() {
        return !this.hasMissingAmount ? this.totalAmount : null;
    }

    public boolean isCalculated() {
        return this.isCalculated;
    }

    public void addPayment(SEPAPaymentData data) {
        ++this.countTransactions;
        BigDecimal amt = data.getAmount();
        if (amt == null) {
            this.hasMissingAmount = true;
            return;
        }
        this.totalAmount = this.totalAmount.add(amt);
        Currency ccy = data.getCurrency();
        if (ccy == null) {
            this.hasMissingCurrency = true;
        } else {
            this.currencies.add(ccy);
        }
    }

    public Currency getCurrency() {
        if (!this.hasMissingAmount && !this.hasMissingCurrency && this.currencies.size() == 1) {
            return this.currencies.iterator().next();
        }
        return null;
    }
}

