/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import java.time.LocalDate;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;

public enum SepaCountry {
    AUSTRIA("AT", true),
    BELGIUM("BE", true),
    BULGARIA("BG", true),
    SWITZERLAND("CH", true, true),
    CYPRUS("CY", true),
    CZECHIA("CZ", true),
    GERMANY("DE", true),
    DENMARK("DK", true),
    ESTONIA("EE", true),
    SPAIN("ES", true),
    FINLAND("FI", true),
    FRANCE("FR", true),
    GREAT_BRITAIN("GB", true, true, true),
    GIBRALTAR("GI", true, true, true),
    GREECE("GR", true),
    CROATIA("HR", true),
    HUNGARY("HU", true),
    IRELAND("IE", true),
    ICELAND("IS", true),
    ITALY("IT", true),
    LIECHTENSTEIN("LI", true),
    LITHUANIA("LT", true),
    LUXEMBOURG("LU", true),
    LATVIA("LV", true),
    MONACO("MC", true, true),
    MALTA("MT", true),
    NETHERLANDS("NL", true),
    NORWAY("NO", true),
    POLAND("PL", true),
    PORTUGAL("PT", true),
    ROMANIA("RO", true),
    SWEDEN("SE", true),
    SLOVENIA("SI", true),
    SLOVAKIA("SK", true),
    SAN_MARINO("SM", true, true),
    ANDORRA("AD", true),
    VATICAN_CITY("VA", true),
    FAROE_ISLANDS("FO", true),
    GREENLAND("GL", true),
    ALBANIA("AL", true, false, false, LocalDate.of(2025, 10, 5)),
    MOLDOVA("MD", true, false, false, LocalDate.of(2025, 10, 5)),
    MONTENEGRO("ME", true, false, false, LocalDate.of(2025, 10, 5)),
    NORTH_MACEDONIA("MK", true, false, false, LocalDate.of(2025, 10, 5)),
    SERBIA("RS", true, false, false, LocalDate.of(2026, 5, 1));

    private static final HashMap<String, SepaCountry> ALL;
    private final String countryCode;
    private final boolean ibanOnlyAllowed;
    private final boolean debtorAddressMandatory;
    private final boolean originatorAddressMandatory;
    private final LocalDate validAfter;
    private final Locale locale;
    private final Currency localCurrency;

    public static boolean isSepaCountry(String countryCode) {
        return SepaCountry.getSepaCountry(countryCode) != null;
    }

    public static SepaCountry getSepaCountry(String countryCode) {
        return ALL.get(countryCode);
    }

    public static String getCountryName(String countryCode, Locale locale) {
        SepaCountry sepaCountry = SepaCountry.getSepaCountry(countryCode);
        if (sepaCountry != null) {
            return sepaCountry.getCountryName(locale);
        }
        return null;
    }

    public static boolean isIbanOnlyAllowed(String countryCode) {
        SepaCountry sepaCountry = SepaCountry.getSepaCountry(countryCode);
        if (sepaCountry != null) {
            return sepaCountry.isIbanOnlyAllowed();
        }
        return false;
    }

    public static boolean isDebtorAddressMandatory(String countryCode) {
        SepaCountry sepaCountry = SepaCountry.getSepaCountry(countryCode);
        if (sepaCountry != null) {
            return sepaCountry.isDebtorAddressMandatory();
        }
        return false;
    }

    public static boolean isOriginatorAddressMandatory(String recipientCountryCode) {
        SepaCountry sepaCountry = SepaCountry.getSepaCountry(recipientCountryCode);
        if (sepaCountry != null) {
            return sepaCountry.isOriginatorAddressMandatory();
        }
        return false;
    }

    public static String getAllowedCountries(Locale locale) {
        StringBuilder result = new StringBuilder();
        for (SepaCountry country : SepaCountry.values()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(country.countryCode);
            String countryName = country.locale.getDisplayCountry(locale);
            if (countryName == null) continue;
            result.append(" (").append(countryName).append(')');
        }
        return result.toString();
    }

    public static Currency getCurrency(String countryCode) {
        for (SepaCountry sepaCountry : SepaCountry.values()) {
            if (!sepaCountry.countryCode.equals(countryCode)) continue;
            return sepaCountry.localCurrency;
        }
        return null;
    }

    private SepaCountry(String countryCode, boolean ibanOnlyAllowed) {
        this(countryCode, ibanOnlyAllowed, false);
    }

    private SepaCountry(String countryCode, boolean ibanOnlyAllowed, boolean debtorAddressMandatory) {
        this(countryCode, ibanOnlyAllowed, debtorAddressMandatory, false);
    }

    private SepaCountry(String countryCode, boolean ibanOnlyAllowed, boolean debtorAddressMandatory, boolean originatorAddressMandatory) {
        this(countryCode, ibanOnlyAllowed, debtorAddressMandatory, originatorAddressMandatory, null);
    }

    private SepaCountry(String countryCode, boolean ibanOnlyAllowed, boolean debtorAddressMandatory, boolean originatorAddressMandatory, LocalDate validAfter) {
        this.countryCode = countryCode;
        this.ibanOnlyAllowed = ibanOnlyAllowed;
        this.debtorAddressMandatory = debtorAddressMandatory;
        this.originatorAddressMandatory = originatorAddressMandatory;
        this.locale = new Locale(countryCode, countryCode);
        this.localCurrency = Currency.getInstance(this.locale);
        this.validAfter = validAfter;
    }

    public Currency getLocalCurrency() {
        return this.localCurrency;
    }

    public String getLocalCurrencyCode() {
        return this.localCurrency.getCurrencyCode();
    }

    public boolean isIbanOnlyAllowed() {
        return this.ibanOnlyAllowed;
    }

    public boolean isDebtorAddressMandatory() {
        return this.debtorAddressMandatory;
    }

    public boolean isOriginatorAddressMandatory() {
        return this.originatorAddressMandatory;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCountryName(Locale l) {
        return this.locale.getDisplayCountry(l);
    }

    static {
        ALL = new HashMap();
        LocalDate now = LocalDate.now();
        for (SepaCountry c : SepaCountry.values()) {
            if (c.validAfter != null && now.isBefore(c.validAfter)) continue;
            ALL.put(c.countryCode, c);
        }
    }
}

